/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.ExternalLibraryModel;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.NoImplicit;
import org.mule.runtime.extension.api.exception.IllegalConfigurationModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.module.extension.api.loader.java.type.ComponentElement;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.api.loader.java.type.OperationContainerElement;
import org.mule.runtime.module.extension.internal.loader.java.TypeAwareConfigurationFactory;
import org.mule.runtime.module.extension.internal.loader.java.property.ConfigurationFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionTypeDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.parser.ConfigurationModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.ConnectionProviderModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.FunctionModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.OperationModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.ParameterGroupModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.SourceModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.StereotypeModelFactory;
import org.mule.runtime.module.extension.internal.loader.parser.java.AbstractJavaModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaExtensionModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaExtensionModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.MuleExtensionAnnotationParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.ParameterDeclarationContext;
import org.mule.runtime.module.extension.internal.loader.parser.java.lib.JavaExternalLibModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.stereotypes.JavaStereotypeModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.utils.MinMuleVersionUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.utils.ResolvedMinMuleVersion;
import org.mule.sdk.api.annotation.Configuration;
import org.mule.sdk.api.annotation.Configurations;

public class JavaConfigurationModelParser
extends AbstractJavaModelParser
implements ConfigurationModelParser {
    private final JavaExtensionModelParser extensionModelParser;
    private final ComponentElement configElement;
    private final ResolvedMinMuleVersion resolvedMinMuleVersion;

    public JavaConfigurationModelParser(JavaExtensionModelParser extensionModelParser, ExtensionElement extensionElement, ComponentElement configElement, ExtensionLoadingContext loadingContext) {
        super(extensionElement, loadingContext);
        this.extensionModelParser = extensionModelParser;
        this.configElement = configElement;
        this.parseStructure();
        this.resolvedMinMuleVersion = MinMuleVersionUtils.resolveConfigurationMinMuleVersion(configElement, MinMuleVersionUtils.getContainerAnnotationMinMuleVersion(extensionElement, Configurations.class, Configurations::value, configElement));
    }

    private void parseStructure() {
        this.checkConfigurationIsNotAnOperation(this.extensionElement, this.configElement);
        this.additionalModelProperties.add(new ImplementingTypeModelProperty(this.configElement.getDeclaringClass().orElse(Object.class)));
        this.additionalModelProperties.add(new ExtensionTypeDescriptorModelProperty(this.configElement));
    }

    @Override
    public String getName() {
        return MuleExtensionAnnotationParser.mapReduceSingleAnnotation(this.configElement, "Configuration", this.configElement.getName(), org.mule.runtime.extension.api.annotation.Configuration.class, Configuration.class, value -> value.getStringValue(org.mule.runtime.extension.api.annotation.Configuration::name), value -> value.getStringValue(Configuration::name)).map(name -> StringUtils.isBlank((String)name) ? "config" : name).orElse("config");
    }

    @Override
    public String getDescription() {
        return this.configElement.getDescription();
    }

    @Override
    public List<ParameterGroupModelParser> getParameterGroupParsers() {
        return JavaExtensionModelParserUtils.getParameterGroupParsers(this.configElement.getParameters(), ParameterDeclarationContext.forConfig(this.configElement.getName()));
    }

    @Override
    public List<OperationModelParser> getOperationParsers() {
        ArrayList operationModelParsers = new ArrayList(JavaExtensionModelParserUtils.getOperationParsers(this.extensionModelParser, this.extensionElement, this.configElement, this.loadingContext).collect(Collectors.toList()));
        Collections.sort(operationModelParsers, Comparator.comparing(OperationModelParser::getName));
        return Collections.unmodifiableList(operationModelParsers);
    }

    @Override
    public List<SourceModelParser> getSourceModelParsers() {
        return JavaExtensionModelParserUtils.getSourceParsers(this.extensionElement, this.configElement.getSources(), this.loadingContext).collect(Collectors.toList());
    }

    @Override
    public List<ConnectionProviderModelParser> getConnectionProviderModelParsers() {
        return JavaExtensionModelParserUtils.getConnectionProviderModelParsers(this.extensionModelParser, this.extensionElement, this.configElement.getConnectionProviders());
    }

    @Override
    public List<FunctionModelParser> getFunctionModelParsers() {
        return JavaExtensionModelParserUtils.getFunctionModelParsers(this.extensionElement, this.configElement.getFunctionContainers(), this.loadingContext);
    }

    @Override
    public ConfigurationFactoryModelProperty getConfigurationFactoryModelProperty() {
        Class<Object> extensionClass = this.extensionElement.getDeclaringClass().orElse(Object.class);
        Class<Object> configClass = this.configElement.getDeclaringClass().orElse(Object.class);
        ClassLoader classLoader = extensionClass.getClassLoader() != null ? extensionClass.getClassLoader() : Thread.currentThread().getContextClassLoader();
        TypeAwareConfigurationFactory typeAwareConfigurationFactory = new TypeAwareConfigurationFactory(configClass, classLoader);
        return new ConfigurationFactoryModelProperty(typeAwareConfigurationFactory);
    }

    @Override
    public boolean isForceNoImplicit() {
        return this.configElement.isAnnotatedWith(NoImplicit.class) || this.configElement.isAnnotatedWith(org.mule.sdk.api.annotation.NoImplicit.class);
    }

    @Override
    public List<ExternalLibraryModel> getExternalLibraryModels() {
        return JavaExternalLibModelParserUtils.parseExternalLibraryModels(this.configElement);
    }

    @Override
    public Optional<StereotypeModel> getStereotype(StereotypeModelFactory factory) {
        return JavaStereotypeModelParserUtils.resolveStereotype(this.configElement, "Configuration", this.getName(), factory);
    }

    private void checkConfigurationIsNotAnOperation(ExtensionElement extensionElement, ComponentElement componentElement) {
        ArrayList<OperationContainerElement> allOperations = new ArrayList<OperationContainerElement>();
        allOperations.addAll(extensionElement.getOperationContainers());
        allOperations.addAll(componentElement.getOperationContainers());
        for (OperationContainerElement operationClass : allOperations) {
            if (!componentElement.isAssignableFrom(operationClass) && !componentElement.isAssignableTo(operationClass)) continue;
            throw new IllegalConfigurationModelDefinitionException(String.format("Configuration class '%s' cannot be the same class (nor a derivative) of any operation class '%s", componentElement.getName(), operationClass.getName()));
        }
    }

    @Override
    public Optional<DeprecationModel> getDeprecationModel() {
        return JavaExtensionModelParserUtils.getDeprecationModel(this.configElement);
    }

    @Override
    public Optional<DisplayModel> getDisplayModel() {
        return JavaExtensionModelParserUtils.getDisplayModel(this.configElement, "configuration", this.configElement.getName());
    }

    @Override
    public Optional<ResolvedMinMuleVersion> getResolvedMinMuleVersion() {
        return Optional.of(this.resolvedMinMuleVersion);
    }
}

