/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.utils;

import java.util.Optional;
import org.mule.runtime.module.extension.api.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.api.loader.java.type.WithAnnotations;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaAttributesResolverModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaOutputResolverModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.MuleExtensionAnnotationParser;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.sdk.api.annotation.metadata.MetadataScope;
import org.mule.sdk.api.annotation.metadata.OutputResolver;
import org.mule.sdk.api.metadata.NullMetadataResolver;

public class JavaOutputResolverModelParserUtils {
    public static boolean hasOutputResolverAnnotation(MethodElement<?> methodElement) {
        return methodElement.isAnnotatedWith(org.mule.runtime.extension.api.annotation.metadata.OutputResolver.class) || methodElement.isAnnotatedWith(OutputResolver.class);
    }

    public static boolean hasMetadataScopeAnnotation(Class<?> type) {
        return IntrospectionUtils.getAnnotation(type, org.mule.runtime.extension.api.annotation.metadata.MetadataScope.class) != null || IntrospectionUtils.getAnnotation(type, MetadataScope.class) != null;
    }

    public static JavaOutputResolverModelParser parseOutputResolverModelParser(MethodElement<?> methodElement) {
        return MuleExtensionAnnotationParser.mapReduceSingleAnnotation(methodElement, "operation", methodElement.getName(), org.mule.runtime.extension.api.annotation.metadata.OutputResolver.class, OutputResolver.class, value -> JavaOutputResolverModelParserUtils.outputResolverFromType(value.getClassValue(org.mule.runtime.extension.api.annotation.metadata.OutputResolver::output)), value -> JavaOutputResolverModelParserUtils.outputResolverFromType(value.getClassValue(OutputResolver::output))).orElse(new JavaOutputResolverModelParser(NullMetadataResolver.class));
    }

    public static JavaOutputResolverModelParser parseOutputResolverModelParser(Type extensionType, WithAnnotations annotatedType) {
        Optional<JavaOutputResolverModelParser> javaOutputResolverModelParse = MuleExtensionAnnotationParser.mapReduceSingleAnnotation(annotatedType, "source", "", org.mule.runtime.extension.api.annotation.metadata.MetadataScope.class, MetadataScope.class, value -> JavaOutputResolverModelParserUtils.outputResolverFromType(value.getClassValue(org.mule.runtime.extension.api.annotation.metadata.MetadataScope::outputResolver)), value -> JavaOutputResolverModelParserUtils.outputResolverFromType(value.getClassValue(MetadataScope::outputResolver)));
        if (!javaOutputResolverModelParse.isPresent()) {
            javaOutputResolverModelParse = MuleExtensionAnnotationParser.mapReduceSingleAnnotation(extensionType, "source", "", org.mule.runtime.extension.api.annotation.metadata.MetadataScope.class, MetadataScope.class, value -> JavaOutputResolverModelParserUtils.outputResolverFromType(value.getClassValue(org.mule.runtime.extension.api.annotation.metadata.MetadataScope::outputResolver)), value -> JavaOutputResolverModelParserUtils.outputResolverFromType(value.getClassValue(MetadataScope::outputResolver)));
        }
        return javaOutputResolverModelParse.orElse(new JavaOutputResolverModelParser(NullMetadataResolver.class));
    }

    public static JavaAttributesResolverModelParser parseAttributesResolverModelParser(MethodElement<?> methodElement) {
        return MuleExtensionAnnotationParser.mapReduceSingleAnnotation(methodElement, "operation", methodElement.getName(), org.mule.runtime.extension.api.annotation.metadata.OutputResolver.class, OutputResolver.class, value -> JavaOutputResolverModelParserUtils.attributesResolverFromType(value.getClassValue(org.mule.runtime.extension.api.annotation.metadata.OutputResolver::attributes)), value -> JavaOutputResolverModelParserUtils.attributesResolverFromType(value.getClassValue(OutputResolver::attributes))).orElse(new JavaAttributesResolverModelParser(NullMetadataResolver.class));
    }

    public static JavaAttributesResolverModelParser parseAttributesResolverModelParser(Type extensionType, WithAnnotations annotatedType) {
        Optional<JavaAttributesResolverModelParser> javaAttributesResolverModelParser = MuleExtensionAnnotationParser.mapReduceSingleAnnotation(annotatedType, "source", "", org.mule.runtime.extension.api.annotation.metadata.MetadataScope.class, MetadataScope.class, value -> JavaOutputResolverModelParserUtils.attributesResolverFromType(value.getClassValue(org.mule.runtime.extension.api.annotation.metadata.MetadataScope::attributesResolver)), value -> JavaOutputResolverModelParserUtils.attributesResolverFromType(value.getClassValue(MetadataScope::attributesResolver)));
        if (!javaAttributesResolverModelParser.isPresent()) {
            javaAttributesResolverModelParser = MuleExtensionAnnotationParser.mapReduceSingleAnnotation(extensionType, "source", "", org.mule.runtime.extension.api.annotation.metadata.MetadataScope.class, MetadataScope.class, value -> JavaOutputResolverModelParserUtils.attributesResolverFromType(value.getClassValue(org.mule.runtime.extension.api.annotation.metadata.MetadataScope::outputResolver)), value -> JavaOutputResolverModelParserUtils.attributesResolverFromType(value.getClassValue(MetadataScope::outputResolver)));
        }
        return javaAttributesResolverModelParser.orElse(new JavaAttributesResolverModelParser(NullMetadataResolver.class));
    }

    private static JavaOutputResolverModelParser outputResolverFromType(Type type) {
        return new JavaOutputResolverModelParser(type.getDeclaringClass().get());
    }

    private static JavaAttributesResolverModelParser attributesResolverFromType(Type type) {
        return new JavaAttributesResolverModelParser(type.getDeclaringClass().get());
    }
}

