/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.annotation.privileged.DeclarationEnrichers;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.internal.loader.AbstractExtensionModelLoader;
import org.mule.runtime.module.extension.internal.loader.ModelLoaderDelegateFactory;
import org.mule.runtime.module.extension.internal.loader.delegate.DefaultExtensionModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.delegate.ModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.enricher.DefaultEncodingDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.enricher.DynamicMetadataDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.enricher.ExtensionDescriptionsEnricher;
import org.mule.runtime.module.extension.internal.loader.java.enricher.JavaConfigurationDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.enricher.JavaMimeTypeParametersDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.enricher.JavaOAuthDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.enricher.JavaObjectStoreParameterDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.enricher.ParameterAllowedStereotypesDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.enricher.PollingSourceDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.enricher.RefNameDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.enricher.RequiredForMetadataDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.enricher.RuntimeVersionDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.enricher.SampleDataDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.enricher.ValueProvidersParameterDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.validation.ComponentLocationModelValidator;
import org.mule.runtime.module.extension.internal.loader.java.validation.IgnoredExtensionParameterModelValidator;
import org.mule.runtime.module.extension.internal.loader.java.validation.InjectedFieldsModelValidator;
import org.mule.runtime.module.extension.internal.loader.java.validation.JavaInputParametersTypeModelValidator;
import org.mule.runtime.module.extension.internal.loader.java.validation.JavaOAuthConnectionProviderModelValidator;
import org.mule.runtime.module.extension.internal.loader.java.validation.JavaParameterTypeModelValidator;
import org.mule.runtime.module.extension.internal.loader.java.validation.JavaSampleDataModelValidator;
import org.mule.runtime.module.extension.internal.loader.java.validation.JavaScopeModelValidator;
import org.mule.runtime.module.extension.internal.loader.java.validation.JavaSubtypesModelValidator;
import org.mule.runtime.module.extension.internal.loader.java.validation.JavaValueProviderModelValidator;
import org.mule.runtime.module.extension.internal.loader.java.validation.MediaTypeModelValidator;
import org.mule.runtime.module.extension.internal.loader.java.validation.MetadataComponentModelValidator;
import org.mule.runtime.module.extension.internal.loader.java.validation.NullSafeModelValidator;
import org.mule.runtime.module.extension.internal.loader.java.validation.OperationParametersTypeModelValidator;
import org.mule.runtime.module.extension.internal.loader.java.validation.OperationReturnTypeModelValidator;
import org.mule.runtime.module.extension.internal.loader.java.validation.PagedOperationModelValidator;
import org.mule.runtime.module.extension.internal.loader.java.validation.ParameterGroupModelValidator;
import org.mule.runtime.module.extension.internal.loader.java.validation.PojosModelValidator;
import org.mule.runtime.module.extension.internal.loader.java.validation.PrivilegedApiValidator;
import org.mule.runtime.module.extension.internal.loader.java.validation.SourceCallbacksModelValidator;
import org.mule.runtime.module.extension.internal.loader.parser.ExtensionModelParserFactory;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaExtensionModelParserFactory;
import org.mule.runtime.module.extension.internal.loader.validator.DeprecationModelValidator;
import org.mule.runtime.module.extension.internal.loader.validator.JavaConfigurationModelValidator;
import org.mule.runtime.module.extension.internal.loader.validator.JavaConnectionProviderModelValidator;
import org.mule.runtime.module.extension.internal.loader.validator.ParameterPluralNameModelValidator;

public abstract class AbstractJavaExtensionModelLoader
extends AbstractExtensionModelLoader {
    public static final String TYPE_PROPERTY_NAME = "type";
    public static final String EXTENSION_TYPE = "EXTENSION_TYPE";
    public static final String VERSION = "version";
    private final List<ExtensionModelValidator> customValidators = Collections.unmodifiableList(Arrays.asList(new JavaConfigurationModelValidator(), new JavaConnectionProviderModelValidator(), new PojosModelValidator(), new DeprecationModelValidator(), new JavaInputParametersTypeModelValidator(), new JavaSubtypesModelValidator(), new MediaTypeModelValidator(), new MetadataComponentModelValidator(), new NullSafeModelValidator(), new OperationReturnTypeModelValidator(), new OperationParametersTypeModelValidator(), new SourceCallbacksModelValidator(), new PagedOperationModelValidator(), new ParameterGroupModelValidator(), new JavaParameterTypeModelValidator(), new ParameterPluralNameModelValidator(), new JavaOAuthConnectionProviderModelValidator(), new JavaValueProviderModelValidator(), new JavaSampleDataModelValidator(), new PrivilegedApiValidator(), new ComponentLocationModelValidator(), new InjectedFieldsModelValidator(), new IgnoredExtensionParameterModelValidator(), new JavaScopeModelValidator()));
    private final List<DeclarationEnricher> customDeclarationEnrichers = Collections.unmodifiableList(Arrays.asList(new RefNameDeclarationEnricher(), new DefaultEncodingDeclarationEnricher(), new RuntimeVersionDeclarationEnricher(), new JavaMimeTypeParametersDeclarationEnricher(), new DynamicMetadataDeclarationEnricher(), new RequiredForMetadataDeclarationEnricher(), new JavaConfigurationDeclarationEnricher(), new JavaOAuthDeclarationEnricher(), new ExtensionDescriptionsEnricher(), new ValueProvidersParameterDeclarationEnricher(), new SampleDataDeclarationEnricher(), new ParameterAllowedStereotypesDeclarationEnricher(), new JavaObjectStoreParameterDeclarationEnricher(), new PollingSourceDeclarationEnricher()));
    private final String id;
    private final ModelLoaderDelegateFactory modelLoaderDelegateFactory;

    @Deprecated
    public AbstractJavaExtensionModelLoader(String id, BiFunction<Class<?>, String, ModelLoaderDelegate> delegate) {
        this(id, (ExtensionElement extensionElement, String version) -> (ModelLoaderDelegate)delegate.apply(extensionElement.getDeclaringClass().get(), version));
    }

    @Deprecated
    public AbstractJavaExtensionModelLoader(String id, ModelLoaderDelegateFactory modelLoaderDelegateFactory) {
        this.id = id;
        this.modelLoaderDelegateFactory = modelLoaderDelegateFactory;
    }

    public AbstractJavaExtensionModelLoader(String id) {
        this(id, (ExtensionElement e, String v) -> new DefaultExtensionModelLoaderDelegate(v));
    }

    public String getId() {
        return this.id;
    }

    @Override
    protected void configureContextBeforeDeclaration(ExtensionLoadingContext context) {
        super.configureContextBeforeDeclaration(context);
        context.addCustomValidators(this.customValidators);
        context.addCustomDeclarationEnrichers(this.customDeclarationEnrichers);
        context.addCustomDeclarationEnrichers(this.getPrivilegedDeclarationEnrichers(context));
    }

    @Override
    protected ExtensionModelParserFactory getExtensionModelParserFactory(ExtensionLoadingContext context) {
        return new JavaExtensionModelParserFactory();
    }

    @Override
    protected ModelLoaderDelegate getModelLoaderDelegate(ExtensionLoadingContext context, String version) {
        return this.modelLoaderDelegateFactory.getLoader(JavaExtensionModelParserFactory.getExtensionElement(context), version);
    }

    private Collection<DeclarationEnricher> getPrivilegedDeclarationEnrichers(ExtensionLoadingContext context) {
        ExtensionElement extensionType = JavaExtensionModelParserFactory.getExtensionElement(context);
        if (extensionType.getDeclaringClass().isPresent()) {
            try {
                ClassLoader extensionClassLoader = context.getExtensionClassLoader();
                Class<?> annotation = extensionClassLoader.loadClass(DeclarationEnrichers.class.getName());
                return extensionType.getValueFromAnnotation(annotation).map(value -> ((List)ClassUtils.withContextClassLoader((ClassLoader)extensionClassLoader, () -> value.getClassArrayValue(DeclarationEnrichers::value))).stream().map(type -> this.instantiateOrFail(type.getDeclaringClass().get())).collect(Collectors.toList())).orElse(Collections.emptyList());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }

    private <R> R instantiateOrFail(Class<R> clazz) {
        try {
            return (R)ClassUtils.instantiateClass(clazz, (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error instantiating class: [" + clazz + "].", e);
        }
    }
}

