/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.client.operation;

import java.util.Objects;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.util.func.CheckedBiFunction;
import org.mule.runtime.core.api.util.func.CheckedFunction;
import org.mule.runtime.core.api.util.func.Once;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;

public class OperationKey {
    private final String extensionName;
    private final String configName;
    private final String operationName;
    private final Once.RunOnce initializer;
    private final ExtensionManager extensionManager;
    private ExtensionModel extensionModel;
    private Optional<ConfigurationProvider> configurationProvider;
    private OperationModel operationModel;

    public OperationKey(String extensionName, String configName, String operationName, CheckedFunction<String, ExtensionModel> extensionResolver, CheckedBiFunction<ExtensionModel, String, OperationModel> operationResolver, ExtensionManager extensionManager) {
        this.extensionName = extensionName;
        this.configName = configName;
        this.operationName = operationName;
        this.extensionManager = extensionManager;
        this.initializer = Once.of(() -> {
            this.extensionModel = (ExtensionModel)extensionResolver.apply((Object)extensionName);
            this.operationModel = (OperationModel)operationResolver.apply((Object)this.extensionModel, (Object)operationName);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<ConfigurationProvider> getConfigurationProvider(CoreEvent contextEvent) {
        this.initialize();
        if (this.configurationProvider != null) {
            return this.configurationProvider;
        }
        OperationKey operationKey = this;
        synchronized (operationKey) {
            if (this.configurationProvider != null) {
                return this.configurationProvider;
            }
            this.configurationProvider = this.configName != null ? Optional.of(this.extensionManager.getConfigurationProvider(this.configName).map(configurationProvider -> {
                if (configurationProvider.getExtensionModel() != this.extensionModel) {
                    throw new IllegalArgumentException(String.format("A config of the '%s' extension was expected but one from '%s' was parameterized instead", this.extensionModel.getName(), configurationProvider.getExtensionModel().getName()));
                }
                return configurationProvider;
            }).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("No configuration [" + this.configName + "] found"))))) : this.extensionManager.getConfigurationProvider(this.extensionModel, (ComponentModel)this.operationModel, contextEvent);
        }
        return this.configurationProvider;
    }

    private void initialize() {
        this.initializer.runOnce();
    }

    public ExtensionModel getExtensionModel() {
        this.initialize();
        return this.extensionModel;
    }

    public OperationModel getOperationModel() {
        this.initialize();
        return this.operationModel;
    }

    public boolean equals(Object o) {
        if (o instanceof OperationKey) {
            OperationKey that = (OperationKey)o;
            return Objects.equals(this.extensionName, that.extensionName) && Objects.equals(this.configName, that.configName) && Objects.equals(this.operationName, that.operationName);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.extensionName, this.operationName, this.configName);
    }

    public String toString() {
        return String.format("[Extension: %s; Operation: %s, ConfigName: %s", this.extensionName, this.operationName, this.configName);
    }
}

