/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.enricher;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.parameter.ActingParameterModel;
import org.mule.runtime.api.meta.model.parameter.FieldValueProviderModel;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.values.ValuePart;
import org.mule.runtime.extension.api.declaration.type.DefaultExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.IdempotentDeclarationEnricherWalkDelegate;
import org.mule.runtime.extension.api.loader.WalkingDeclarationEnricher;
import org.mule.runtime.extension.api.model.parameter.ImmutableActingParameterModel;
import org.mule.runtime.extension.api.property.SinceMuleVersionModelProperty;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.FieldElement;
import org.mule.runtime.module.extension.internal.loader.java.property.FieldsValueProviderFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ValueProviderFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ParameterizableTypeWrapper;
import org.mule.runtime.module.extension.internal.loader.utils.FieldValueProviderNameUtils;
import org.mule.runtime.module.extension.internal.loader.utils.ParameterUtils;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.value.OfValueInformation;
import org.mule.runtime.module.extension.internal.value.ValueProviderUtils;
import org.mule.sdk.api.annotation.binding.Binding;
import org.mule.sdk.api.annotation.values.FieldValues;
import org.mule.sdk.api.annotation.values.FieldsValues;
import org.mule.sdk.api.annotation.values.OfValues;

public class ValueProvidersParameterDeclarationEnricher
implements WalkingDeclarationEnricher {
    private static final SinceMuleVersionModelProperty SINCE_MULE_VERSION_MODEL_PROPERTY_SDK_API_VP = new SinceMuleVersionModelProperty("4.4.0");
    private final ClassTypeLoader classTypeLoader = new DefaultExtensionsTypeLoaderFactory().createTypeLoader();

    public Optional<WalkingDeclarationEnricher.DeclarationEnricherWalkDelegate> getWalkDelegate(ExtensionLoadingContext extensionLoadingContext) {
        return MuleExtensionUtils.extractImplementingTypeProperty((BaseDeclaration<? extends BaseDeclaration>)extensionLoadingContext.getExtensionDeclarer().getDeclaration()).map(p -> new IdempotentDeclarationEnricherWalkDelegate(){

            public void onSource(SourceDeclaration declaration) {
                ValueProvidersParameterDeclarationEnricher.this.enrichContainerModel((ParameterizedDeclaration)declaration, declaration.getName(), "source");
            }

            public void onOperation(OperationDeclaration declaration) {
                ValueProvidersParameterDeclarationEnricher.this.enrichContainerModel((ParameterizedDeclaration)declaration, declaration.getName(), "operation");
            }

            public void onConfiguration(ConfigurationDeclaration declaration) {
                ValueProvidersParameterDeclarationEnricher.this.enrichContainerModel((ParameterizedDeclaration)declaration, declaration.getName(), "configuration");
            }

            protected void onConnectionProvider(ConnectionProviderDeclaration declaration) {
                ValueProvidersParameterDeclarationEnricher.this.enrichContainerModel((ParameterizedDeclaration)declaration, declaration.getName(), "connection provider");
            }
        });
    }

    private void enrichContainerModel(ParameterizedDeclaration<?> containerDeclaration, String componentName, String componentType) {
        List allParameters = containerDeclaration.getAllParameters();
        Map<String, String> parameterNames = this.getContainerParameterNames(allParameters);
        Map<ParameterGroupDeclaration, OfValueInformation> dynamicGroupOptions = this.introspectParameterGroups(containerDeclaration.getParameterGroups(), componentName, componentType);
        Map<ParameterDeclaration, OfValueInformation> dynamicOptions = this.introspectParameters(allParameters, componentName, componentType);
        Map<ParameterDeclaration, List<FieldValues>> dynamicFieldOptions = this.introspectParameterFields(allParameters);
        dynamicOptions.forEach((paramDeclaration, ofValueInformation) -> this.enrichParameter((OfValueInformation)ofValueInformation, (BaseDeclaration)paramDeclaration, arg_0 -> ((ParameterDeclaration)paramDeclaration).setValueProviderModel(arg_0), 1, parameterNames, paramDeclaration.getName(), allParameters));
        dynamicFieldOptions.forEach((paramDeclaration, fieldsValues) -> this.enrichParameterFields((List<FieldValues>)fieldsValues, (ParameterDeclaration)paramDeclaration, parameterNames, paramDeclaration.getName(), allParameters));
        dynamicGroupOptions.forEach((paramGroupDeclaration, ofValueInformation) -> this.getParts((ParameterGroupDeclaration)paramGroupDeclaration).forEach((paramDeclaration, order) -> this.enrichParameter((OfValueInformation)ofValueInformation, (BaseDeclaration)paramDeclaration, arg_0 -> ((ParameterDeclaration)paramDeclaration).setValueProviderModel(arg_0), (Integer)order, parameterNames, paramGroupDeclaration.getName(), allParameters)));
    }

    private void enrichParameter(OfValueInformation ofValueInformation, BaseDeclaration paramDeclaration, Consumer<ValueProviderModel> valueProviderModelConsumer, Integer partOrder, Map<String, String> containerParameterNames, String name, List<ParameterDeclaration> allParameters) {
        Map<String, String> bindingMap = this.getBindingsMap(ofValueInformation.getBindings());
        ValueProviderFactoryModelProperty.ValueProviderFactoryModelPropertyBuilder propertyBuilder = ValueProviderFactoryModelProperty.builder(ofValueInformation.getValue());
        ParameterizableTypeWrapper resolverClassWrapper = new ParameterizableTypeWrapper((Class)ofValueInformation.getValue(), this.classTypeLoader);
        List<ExtensionParameter> resolverParameters = resolverClassWrapper.getParametersAnnotatedWith(Parameter.class);
        resolverParameters.forEach(param -> propertyBuilder.withInjectableParameter(param.getName(), param.getType().asMetadataType(), param.isRequired(), bindingMap.getOrDefault(param.getName(), containerParameterNames.getOrDefault(param.getName(), param.getName()))));
        Reference requiresConfiguration = new Reference((Object)false);
        Reference requiresConnection = new Reference((Object)false);
        this.enrichWithConnection(propertyBuilder, resolverClassWrapper).ifPresent(field -> {
            Boolean cfr_ignored_0 = (Boolean)requiresConnection.set((Object)true);
        });
        this.enrichWithConfiguration(propertyBuilder, resolverClassWrapper).ifPresent(field -> {
            Boolean cfr_ignored_0 = (Boolean)requiresConfiguration.set((Object)true);
        });
        paramDeclaration.addModelProperty((ModelProperty)propertyBuilder.build());
        if (ofValueInformation.isFromLegacyAnnotation()) {
            valueProviderModelConsumer.accept(new ValueProviderModel(this.getActingParametersModel(resolverParameters, containerParameterNames, allParameters, bindingMap), ((Boolean)requiresConfiguration.get()).booleanValue(), ((Boolean)requiresConnection.get()).booleanValue(), ofValueInformation.isOpen(), partOrder, name, ValueProviderUtils.getValueProviderId(ofValueInformation.getValue())));
        } else {
            valueProviderModelConsumer.accept(new ValueProviderModel(this.getActingParametersModel(resolverParameters, containerParameterNames, allParameters, bindingMap), ((Boolean)requiresConfiguration.get()).booleanValue(), ((Boolean)requiresConnection.get()).booleanValue(), ofValueInformation.isOpen(), partOrder, name, ValueProviderUtils.getValueProviderId(ofValueInformation.getValue()), new ModelProperty[]{SINCE_MULE_VERSION_MODEL_PROPERTY_SDK_API_VP}));
        }
    }

    private Map<String, String> getBindingsMap(Binding[] bindings) {
        HashMap<String, String> bindingsMap = new HashMap<String, String>();
        for (Binding binding : bindings) {
            bindingsMap.put(binding.actingParameter(), binding.extractionExpression());
        }
        return bindingsMap;
    }

    private void enrichParameterFields(List<FieldValues> fieldsValues, ParameterDeclaration paramDeclaration, Map<String, String> parameterNames, String name, List<ParameterDeclaration> allParameters) {
        LinkedList<FieldValueProviderModel> fieldValueProviderModels = new LinkedList<FieldValueProviderModel>();
        HashMap<String, ValueProviderFactoryModelProperty> valueProviderFactoryModelProperties = new HashMap<String, ValueProviderFactoryModelProperty>();
        for (FieldValues fieldValues : fieldsValues) {
            Map<String, String> bindingsMap = this.getBindingsMap(fieldValues.bindings());
            ValueProviderFactoryModelProperty.ValueProviderFactoryModelPropertyBuilder propertyBuilder = ValueProviderFactoryModelProperty.builder(fieldValues.value());
            ParameterizableTypeWrapper resolverClassWrapper = new ParameterizableTypeWrapper(fieldValues.value(), this.classTypeLoader);
            List<ExtensionParameter> resolverParameters = resolverClassWrapper.getParametersAnnotatedWith(Parameter.class);
            resolverParameters.forEach(param -> propertyBuilder.withInjectableParameter(param.getName(), param.getType().asMetadataType(), param.isRequired(), bindingsMap.getOrDefault(param.getName(), parameterNames.getOrDefault(param.getName(), param.getName()))));
            Reference requiresConfiguration = new Reference((Object)false);
            Reference requiresConnection = new Reference((Object)false);
            this.enrichWithConnection(propertyBuilder, resolverClassWrapper).ifPresent(field -> {
                Boolean cfr_ignored_0 = (Boolean)requiresConnection.set((Object)true);
            });
            this.enrichWithConfiguration(propertyBuilder, resolverClassWrapper).ifPresent(field -> {
                Boolean cfr_ignored_0 = (Boolean)requiresConfiguration.set((Object)true);
            });
            int partOrder = 1;
            String providerName = FieldValueProviderNameUtils.getFieldValueProviderName(name, fieldValues.targetSelectors());
            for (String targetSelector : fieldValues.targetSelectors()) {
                ValueProviderFactoryModelProperty valueProviderFactoryModelProperty = propertyBuilder.build();
                valueProviderFactoryModelProperties.put(targetSelector, valueProviderFactoryModelProperty);
                fieldValueProviderModels.add(new FieldValueProviderModel(this.getActingParametersModel(resolverParameters, parameterNames, allParameters, bindingsMap), ((Boolean)requiresConfiguration.get()).booleanValue(), ((Boolean)requiresConnection.get()).booleanValue(), fieldValues.open(), Integer.valueOf(partOrder), providerName, ValueProviderUtils.getValueProviderId(fieldValues.value()), targetSelector));
                ++partOrder;
            }
            paramDeclaration.setFieldValueProviderModels(fieldValueProviderModels);
            paramDeclaration.addModelProperty((ModelProperty)new FieldsValueProviderFactoryModelProperty(valueProviderFactoryModelProperties));
        }
    }

    private Optional<Field> enrichWithConnection(ValueProviderFactoryModelProperty.ValueProviderFactoryModelPropertyBuilder modelPropertyBuilder, ParameterizableTypeWrapper parameterizableComponent) {
        List<FieldElement> connectionFields = ParameterUtils.getConnectionFields(parameterizableComponent);
        if (!connectionFields.isEmpty()) {
            Field field = connectionFields.get(0).getField().get();
            modelPropertyBuilder.withConnection(field);
            return Optional.of(field);
        }
        return Optional.empty();
    }

    private Optional<Field> enrichWithConfiguration(ValueProviderFactoryModelProperty.ValueProviderFactoryModelPropertyBuilder modelPropertyBuilder, ParameterizableTypeWrapper parameterizableComponent) {
        List<FieldElement> configFields = ParameterUtils.getConfigFields(parameterizableComponent);
        if (!configFields.isEmpty()) {
            Field field = configFields.get(0).getField().get();
            modelPropertyBuilder.withConfig(field);
            return Optional.of(field);
        }
        return Optional.empty();
    }

    private Map<ParameterDeclaration, OfValueInformation> introspectParameters(List<ParameterDeclaration> parameters, String componentName, String componentType) {
        HashMap<ParameterDeclaration, OfValueInformation> optionResolverEnabledParameters = new HashMap<ParameterDeclaration, OfValueInformation>();
        parameters.forEach(param -> this.getOfValueInformation((ParameterDeclaration)param, componentName, componentType).ifPresent(optionAnnotation -> optionResolverEnabledParameters.put((ParameterDeclaration)param, (OfValueInformation)optionAnnotation)));
        return optionResolverEnabledParameters;
    }

    private Map<ParameterGroupDeclaration, OfValueInformation> introspectParameterGroups(List<ParameterGroupDeclaration> parameterGroups, String componentName, String componentType) {
        HashMap<ParameterGroupDeclaration, OfValueInformation> optionResolverEnabledParameters = new HashMap<ParameterGroupDeclaration, OfValueInformation>();
        parameterGroups.forEach(paramGroup -> paramGroup.getModelProperty(ParameterGroupModelProperty.class).ifPresent(modelProperty -> {
            AnnotatedElement container = modelProperty.getDescriptor().getContainer();
            if (container != null) {
                this.getOfValueInformation((ParameterGroupDeclaration)paramGroup, container, componentName, componentType).ifPresent(v -> optionResolverEnabledParameters.put((ParameterGroupDeclaration)paramGroup, (OfValueInformation)v));
            }
        }));
        return optionResolverEnabledParameters;
    }

    private Map<ParameterDeclaration, List<FieldValues>> introspectParameterFields(List<ParameterDeclaration> parameters) {
        HashMap<ParameterDeclaration, List<FieldValues>> optionResolverEnabledParameters = new HashMap<ParameterDeclaration, List<FieldValues>>();
        parameters.forEach(param -> {
            ArrayList fieldValuesList = new ArrayList();
            this.getAnnotation((ParameterDeclaration)param, (Class)FieldsValues.class).ifPresent(optionAnnotation -> fieldValuesList.addAll(Arrays.asList(optionAnnotation.value())));
            this.getAnnotation((ParameterDeclaration)param, (Class)FieldValues.class).ifPresent(fieldValuesList::add);
            optionResolverEnabledParameters.put((ParameterDeclaration)param, fieldValuesList);
        });
        return optionResolverEnabledParameters;
    }

    private <T extends Annotation> Optional<T> getAnnotation(ParameterDeclaration param, Class<T> annotationClass) {
        return IntrospectionUtils.getAnnotatedElement(param).map(annotatedElement -> Optional.ofNullable(annotatedElement.getAnnotation(annotationClass))).orElse(Optional.empty());
    }

    private List<ActingParameterModel> getActingParametersModel(List<ExtensionParameter> parameterDeclarations, Map<String, String> parameterNames, List<ParameterDeclaration> allParameters, Map<String, String> bindings) {
        return parameterDeclarations.stream().map(extensionParameter -> {
            if (bindings.containsKey(extensionParameter.getName())) {
                return new ImmutableActingParameterModel(extensionParameter.getName(), extensionParameter.isRequired(), (String)bindings.get(extensionParameter.getName()));
            }
            return new ImmutableActingParameterModel(parameterNames.getOrDefault(extensionParameter.getName(), extensionParameter.getName()), extensionParameter.isRequired(), parameterNames.getOrDefault(extensionParameter.getName(), extensionParameter.getName()));
        }).collect(Collectors.toList());
    }

    private Map<ParameterDeclaration, Integer> getParts(ParameterGroupDeclaration paramDeclaration) {
        HashMap<ParameterDeclaration, Integer> parts = new HashMap<ParameterDeclaration, Integer>();
        paramDeclaration.getParameters().forEach(param -> this.getAnnotation((ParameterDeclaration)param, (Class)ValuePart.class).ifPresent(part -> parts.put((ParameterDeclaration)param, part.order())));
        return parts;
    }

    private Map<String, String> getContainerParameterNames(List<ParameterDeclaration> allParameters) {
        HashMap<String, String> parameterNames = new HashMap<String, String>();
        for (ParameterDeclaration parameterDeclaration : allParameters) {
            parameterNames.put(IntrospectionUtils.getImplementingName(parameterDeclaration), parameterDeclaration.getName());
        }
        return parameterNames;
    }

    private Optional<OfValueInformation> getOfValueInformation(ParameterDeclaration parameterDeclaration, String componentName, String componentType) {
        Optional<org.mule.runtime.extension.api.annotation.values.OfValues> legacyAnnotation = this.getAnnotation(parameterDeclaration, org.mule.runtime.extension.api.annotation.values.OfValues.class);
        Optional<OfValues> sdkAnnotation = this.getAnnotation(parameterDeclaration, OfValues.class);
        return this.getOfValueInformation(legacyAnnotation.orElse(null), sdkAnnotation.orElse(null), parameterDeclaration.getName(), componentName, componentType, "parameter");
    }

    private Optional<OfValueInformation> getOfValueInformation(ParameterGroupDeclaration parameterGroupDeclaration, AnnotatedElement annotatedElement, String componentName, String componentType) {
        org.mule.runtime.extension.api.annotation.values.OfValues legacyAnnotation = annotatedElement.getAnnotation(org.mule.runtime.extension.api.annotation.values.OfValues.class);
        OfValues sdkAnnotation = annotatedElement.getAnnotation(OfValues.class);
        return this.getOfValueInformation(legacyAnnotation, sdkAnnotation, parameterGroupDeclaration.getName(), componentName, componentType, "parameter group");
    }

    private Optional<OfValueInformation> getOfValueInformation(org.mule.runtime.extension.api.annotation.values.OfValues legacyOfValues, OfValues ofValues, String elementName, String componentName, String componentType, String elementType) {
        if (legacyOfValues != null && ofValues != null) {
            throw new IllegalModelDefinitionException(String.format("Annotations %s and %s are both present at the same time on %s %s of %s %s", org.mule.runtime.extension.api.annotation.values.OfValues.class.getName(), OfValues.class.getName(), elementType, elementName, componentType, componentName));
        }
        if (legacyOfValues != null) {
            return Optional.of(new OfValueInformation(legacyOfValues.value(), legacyOfValues.open(), new Binding[0], true));
        }
        if (ofValues != null) {
            return Optional.of(new OfValueInformation(ofValues.value(), ofValues.open(), ofValues.bindings(), false));
        }
        return Optional.empty();
    }
}

