/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.enricher;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.WithAnnotation;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.AttributeFieldType;
import org.mule.metadata.api.model.AttributeKeyType;
import org.mule.metadata.api.model.BinaryType;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.DateTimeType;
import org.mule.metadata.api.model.DateType;
import org.mule.metadata.api.model.FunctionType;
import org.mule.metadata.api.model.IntersectionType;
import org.mule.metadata.api.model.LocalDateTimeType;
import org.mule.metadata.api.model.LocalTimeType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NothingType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectKeyType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.PeriodType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.TimeType;
import org.mule.metadata.api.model.TimeZoneType;
import org.mule.metadata.api.model.TupleType;
import org.mule.metadata.api.model.TypeParameterType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.model.impl.DefaultAttributeFieldType;
import org.mule.metadata.api.model.impl.DefaultAttributeKeyType;
import org.mule.metadata.api.model.impl.DefaultFunctionType;
import org.mule.metadata.api.model.impl.DefaultIntersectionType;
import org.mule.metadata.api.model.impl.DefaultObjectFieldType;
import org.mule.metadata.api.model.impl.DefaultObjectKeyType;
import org.mule.metadata.api.model.impl.DefaultObjectType;
import org.mule.metadata.api.model.impl.DefaultTupleType;
import org.mule.metadata.api.model.impl.DefaultUnionType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;

public class MetadataTypeEnricher {
    public MetadataType enrich(MetadataType target, Set<TypeAnnotation> annotations) {
        TypeEnricherVisitor visitor = new TypeEnricherVisitor(target, annotations);
        target.accept((MetadataTypeVisitor)visitor);
        return visitor.type;
    }

    private static class TypeEnricherVisitor
    extends MetadataTypeVisitor {
        private final MetadataType target;
        private final BaseTypeBuilder typeBuilder;
        private final Set<TypeAnnotation> annotations;
        private MetadataType type;

        private TypeEnricherVisitor(MetadataType target, Set<TypeAnnotation> annotations) {
            this.target = target;
            this.annotations = annotations;
            this.typeBuilder = BaseTypeBuilder.create((MetadataFormat)target.getMetadataFormat());
        }

        protected void defaultVisit(MetadataType metadataType) {
            this.type = metadataType;
        }

        public void visitAnyType(AnyType anyType) {
            this.type = this.withNewAnnotations(this.typeBuilder.anyType());
        }

        public void visitArrayType(ArrayType arrayType) {
            this.type = this.withNewAnnotations(this.typeBuilder.arrayType().of(arrayType.getType()));
        }

        public void visitBinaryType(BinaryType binaryType) {
            this.type = this.withNewAnnotations(this.typeBuilder.binaryType());
        }

        public void visitBoolean(BooleanType booleanType) {
            this.type = this.withNewAnnotations(this.typeBuilder.booleanType());
        }

        public void visitDateTime(DateTimeType dateTimeType) {
            this.type = this.withNewAnnotations(this.typeBuilder.dateTimeType());
        }

        public void visitDate(DateType dateType) {
            this.type = this.withNewAnnotations(this.typeBuilder.dateType());
        }

        public void visitNumber(NumberType numberType) {
            this.type = this.withNewAnnotations(this.typeBuilder.numberType());
        }

        public void visitObject(ObjectType objectType) {
            this.type = new DefaultObjectType(objectType.getFields(), objectType.isOrdered(), (MetadataType)objectType.getOpenRestriction().orElse(null), objectType.getMetadataFormat(), this.getAllTypeAnnotationsMap());
        }

        public void visitString(StringType stringType) {
            this.type = this.withNewAnnotations(this.typeBuilder.stringType());
        }

        public void visitTime(TimeType timeType) {
            this.type = this.withNewAnnotations(this.typeBuilder.timeType());
        }

        public void visitTuple(TupleType tupleType) {
            this.type = new DefaultTupleType(tupleType.getTypes(), tupleType.getMetadataFormat(), this.getAllTypeAnnotationsMap());
        }

        public void visitUnion(UnionType unionType) {
            this.type = new DefaultUnionType(unionType.getTypes(), unionType.getMetadataFormat(), this.getAllTypeAnnotationsMap());
        }

        public void visitObjectKey(ObjectKeyType objectKeyType) {
            this.type = new DefaultObjectKeyType(Optional.ofNullable(objectKeyType.getName()), Optional.ofNullable(objectKeyType.getPattern()), objectKeyType.getAttributes(), objectKeyType.getMetadataFormat(), this.getAllTypeAnnotationsMap());
        }

        public void visitAttributeKey(AttributeKeyType attributeKeyType) {
            this.type = new DefaultAttributeKeyType(Optional.ofNullable(attributeKeyType.getName()), Optional.ofNullable(attributeKeyType.getPattern()), attributeKeyType.getMetadataFormat(), this.getAllTypeAnnotationsMap());
        }

        public void visitAttributeField(AttributeFieldType attributeFieldType) {
            this.type = new DefaultAttributeFieldType(attributeFieldType.getKey(), attributeFieldType.getValue(), attributeFieldType.isRequired(), attributeFieldType.getMetadataFormat(), this.getAllTypeAnnotationsMap());
        }

        public void visitObjectField(ObjectFieldType objectFieldType) {
            this.type = new DefaultObjectFieldType(objectFieldType.getKey(), objectFieldType.getValue(), objectFieldType.isRequired(), objectFieldType.isRepeated(), objectFieldType.getMetadataFormat(), this.getAllTypeAnnotationsMap());
        }

        public void visitNothing(NothingType nothingType) {
            this.type = this.withNewAnnotations(this.typeBuilder.nothingType());
        }

        public void visitFunction(FunctionType functionType) {
            this.type = new DefaultFunctionType(functionType.getMetadataFormat(), this.getAllTypeAnnotationsMap(), functionType.getReturnType(), functionType.getParameters());
        }

        public void visitLocalDateTime(LocalDateTimeType localDateTimeType) {
            this.type = this.withNewAnnotations(this.typeBuilder.localDateTimeType());
        }

        public void visitLocalTime(LocalTimeType localTimeType) {
            this.type = this.withNewAnnotations(this.typeBuilder.localTimeType());
        }

        public void visitPeriod(PeriodType periodType) {
            this.type = this.withNewAnnotations(this.typeBuilder.localTimeType());
        }

        public void visitTimeZone(TimeZoneType timeZoneType) {
            this.type = this.withNewAnnotations(this.typeBuilder.timeZoneType());
        }

        public void visitTypeParameter(TypeParameterType defaultTypeParameter) {
            this.type = this.withNewAnnotations(this.typeBuilder.typeParameter(defaultTypeParameter.getName()));
        }

        public void visitIntersection(IntersectionType intersectionType) {
            this.type = new DefaultIntersectionType(intersectionType.getTypes(), intersectionType.getMetadataFormat(), this.getAllTypeAnnotationsMap());
        }

        private <T extends TypeBuilder & WithAnnotation> MetadataType withNewAnnotations(T builder) {
            Set<TypeAnnotation> all = this.getAllTypeAnnotations();
            for (TypeAnnotation typeAnnotation : all) {
                ((WithAnnotation)builder).with(typeAnnotation);
            }
            return builder.build();
        }

        private Map<Class<? extends TypeAnnotation>, TypeAnnotation> getAllTypeAnnotationsMap() {
            return this.getAllTypeAnnotations().stream().collect(Collectors.toMap(Object::getClass, a -> a));
        }

        private Set<TypeAnnotation> getAllTypeAnnotations() {
            LinkedHashSet<TypeAnnotation> all = new LinkedHashSet<TypeAnnotation>(this.annotations);
            all.addAll(this.target.getAnnotations());
            return all;
        }
    }
}

