/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import com.google.common.collect.ImmutableBiMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.util.FunctionalUtils;
import org.mule.runtime.extension.api.component.ComponentParameterization;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.CollectionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ComponentParameterizationUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.MapValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ObjectBuilderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParametersResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.runtime.resolver.resolver.ValueResolverFactory;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public class ResolverSetUtils {
    private static final String PAYLOAD_EXPRESSION = "#[payload]";
    private static final String APPLICATION_JAVA = "application/java";

    private ResolverSetUtils() {
    }

    public static ResolverSet getResolverSetFromStaticValues(ParameterizedModel parameterizedModel, Map<String, Object> parameters, MuleContext muleContext, boolean disableValidations, ReflectionCache reflectionCache, ExpressionManager expressionManager, String parametersOwner) throws MuleException {
        return ResolverSetUtils.getResolverSetFromComponentParameterization(ComponentParameterizationUtils.createComponentParameterization(parameterizedModel, parameters), muleContext, disableValidations, reflectionCache, expressionManager, parametersOwner);
    }

    public static ResolverSet getResolverSetFromComponentParameterization(ComponentParameterization<?> componentParameterization, MuleContext muleContext, boolean disableValidations, ReflectionCache reflectionCache, ExpressionManager expressionManager, String parametersOwner) throws MuleException {
        HashMap<String, ValueResolver> resolvers = new HashMap<String, ValueResolver>();
        ValueResolverFactory valueResolverFactory = new ValueResolverFactory();
        for (ParameterGroupModel parameterGroupModel : componentParameterization.getModel().getParameterGroupModels()) {
            resolvers.putAll(ResolverSetUtils.getParameterGroupValueResolvers(componentParameterization, parameterGroupModel, reflectionCache, muleContext, valueResolverFactory));
        }
        return ParametersResolver.fromValues(resolvers, muleContext, disableValidations, reflectionCache, expressionManager, parametersOwner).getParametersAsResolverSet(componentParameterization.getModel(), muleContext);
    }

    private static Map<String, ValueResolver> getParameterGroupValueResolvers(ComponentParameterization componentParameterization, ParameterGroupModel parameterGroupModel, ReflectionCache reflectionCache, MuleContext muleContext, ValueResolverFactory valueResolverFactory) throws MuleException {
        Optional<Class<?>> parameterGroupDeclaringClass;
        Optional parameterGroupModelProperty;
        Map<String, ValueResolver> parameterGroupParametersValueResolvers = ResolverSetUtils.getParameterGroupParametersValueResolvers(parameterGroupModel, componentParameterization, reflectionCache, muleContext, valueResolverFactory);
        if (parameterGroupModel.isShowInDsl() && !parameterGroupParametersValueResolvers.isEmpty() && (parameterGroupModelProperty = parameterGroupModel.getModelProperty(ParameterGroupModelProperty.class)).isPresent() && (parameterGroupDeclaringClass = ((ParameterGroupModelProperty)parameterGroupModelProperty.get()).getDescriptor().getType().getDeclaringClass()).isPresent()) {
            DefaultObjectBuilder defaultObjectBuilder = new DefaultObjectBuilder(parameterGroupDeclaringClass.get(), reflectionCache);
            for (Map.Entry<String, ValueResolver> stringValueResolverEntry : parameterGroupParametersValueResolvers.entrySet()) {
                defaultObjectBuilder.addPropertyResolver(stringValueResolverEntry.getKey(), (ValueResolver<Object>)stringValueResolverEntry.getValue());
            }
            ObjectBuilderValueResolver objectBuilderValuerResolver = new ObjectBuilderValueResolver(defaultObjectBuilder, muleContext);
            return ImmutableBiMap.of((Object)((Field)((ParameterGroupModelProperty)parameterGroupModelProperty.get()).getDescriptor().getContainer()).getName(), objectBuilderValuerResolver);
        }
        return parameterGroupParametersValueResolvers;
    }

    private static Map<String, ValueResolver> getParameterGroupParametersValueResolvers(ParameterGroupModel parameterGroupModel, ComponentParameterization componentParameterization, ReflectionCache reflectionCache, MuleContext muleContext, ValueResolverFactory valueResolverFactory) throws MuleException {
        HashMap<String, ValueResolver> parameterGroupParametersValueResolvers = new HashMap<String, ValueResolver>();
        for (ParameterModel parameterModel : parameterGroupModel.getParameterModels()) {
            Object value = componentParameterization.getParameter(parameterGroupModel, parameterModel);
            if (value == null) continue;
            parameterGroupParametersValueResolvers.put(parameterModel.getName(), ResolverSetUtils.getParameterValueResolver(parameterModel.getName(), parameterModel.getType(), value, parameterModel.getModelProperties(), reflectionCache, muleContext, valueResolverFactory, ResolverSetUtils.acceptsReferences(parameterModel)));
        }
        return parameterGroupParametersValueResolvers;
    }

    private static ValueResolver getParameterValueResolver(final String parameterName, final MetadataType type, final Object value, final Set<ModelProperty> modelProperties, final ReflectionCache reflectionCache, final MuleContext muleContext, final ValueResolverFactory valueResolverFactory, final boolean acceptsReferences) throws MuleException {
        final Reference resolverReference = new Reference();
        if (type.getMetadataFormat().equals((Object)MetadataFormat.JAVA)) {
            type.accept(new MetadataTypeVisitor(){

                public void visitArrayType(ArrayType arrayType) {
                    boolean effectivelyAcceptReferences = acceptsReferences;
                    try {
                        ValueResolver<Object> resolver;
                        if (value instanceof Collection) {
                            resolver = ResolverSetUtils.getParameterValueResolverForCollection(parameterName, arrayType, (Collection)value, reflectionCache, muleContext, valueResolverFactory);
                            effectivelyAcceptReferences = false;
                        } else {
                            resolver = new StaticValueResolver<Object>(value);
                        }
                        resolverReference.set((Object)ResolverSetUtils.getValueResolverFor(parameterName, (MetadataType)arrayType, ResolverSetUtils.resolveAndInjectIfStatic(resolver, muleContext), MetadataTypeUtils.getDefaultValue((MetadataType)type), ExtensionMetadataTypeUtils.getExpressionSupport((MetadataType)arrayType), false, modelProperties, effectivelyAcceptReferences, valueResolverFactory));
                    }
                    catch (MuleException e) {
                        throw new MuleRuntimeException((Throwable)e);
                    }
                }

                public void visitObject(ObjectType objectType) {
                    boolean effectivelyAcceptReferences = acceptsReferences;
                    try {
                        ValueResolver<Object> resolver;
                        if (ExtensionMetadataTypeUtils.isMap((MetadataType)objectType)) {
                            if (value instanceof Map) {
                                resolver = ResolverSetUtils.getParameterValueResolverForMap(parameterName, objectType, (Map)value, reflectionCache, muleContext, valueResolverFactory);
                                effectivelyAcceptReferences = false;
                            } else {
                                resolver = new StaticValueResolver<Object>(value);
                            }
                        } else {
                            Optional pojoResolver = ResolverSetUtils.getPojoParameterValueResolver(parameterName, objectType, value, reflectionCache, muleContext, valueResolverFactory);
                            if (pojoResolver.isPresent()) {
                                resolver = (ValueResolver)pojoResolver.get();
                                effectivelyAcceptReferences = false;
                            } else {
                                resolver = new StaticValueResolver<Object>(value);
                            }
                        }
                        resolverReference.set((Object)ResolverSetUtils.getValueResolverFor(parameterName, (MetadataType)objectType, ResolverSetUtils.resolveAndInjectIfStatic(resolver, muleContext), MetadataTypeUtils.getDefaultValue((MetadataType)type), ExtensionMetadataTypeUtils.getExpressionSupport((MetadataType)objectType), false, modelProperties, effectivelyAcceptReferences, valueResolverFactory));
                    }
                    catch (MuleException e) {
                        throw new MuleRuntimeException((Throwable)e);
                    }
                }

                protected void defaultVisit(MetadataType metadataType) {
                    resolverReference.set((Object)ResolverSetUtils.getValueResolverFor(parameterName, metadataType, value, MetadataTypeUtils.getDefaultValue((MetadataType)type), ExtensionMetadataTypeUtils.getExpressionSupport((MetadataType)metadataType), false, modelProperties, acceptsReferences, valueResolverFactory));
                }
            });
        } else {
            Object convertedValue = ResolverSetUtils.convertValueWithExpressionLanguage(value, type, (ExpressionManager)muleContext.getExpressionManager());
            resolverReference.set((Object)ResolverSetUtils.getValueResolverFor(parameterName, type, convertedValue, null, ExpressionSupport.NOT_SUPPORTED, false, modelProperties, false, valueResolverFactory));
        }
        LifecycleUtils.initialiseIfNeeded((Object)resolverReference.get(), (MuleContext)muleContext);
        return (ValueResolver)resolverReference.get();
    }

    private static Object convertValueWithExpressionLanguage(Object value, MetadataType type, ExpressionManager expressionManager) {
        TypedValue typedValue = value instanceof TypedValue ? (TypedValue)value : TypedValue.of((Object)value);
        return expressionManager.evaluate(PAYLOAD_EXPRESSION, DataType.builder().type(ExtensionMetadataTypeUtils.getType((MetadataType)type).orElse(Object.class)).mediaType(ResolverSetUtils.getFirstValidMimeType(type)).build(), BindingContext.builder().addBinding("payload", typedValue).build()).getValue();
    }

    private static MediaType getFirstValidMimeType(MetadataType type) {
        Collection validMimeTypes = type.getMetadataFormat().getValidMimeTypes();
        String mimeType = validMimeTypes.isEmpty() ? APPLICATION_JAVA : (String)validMimeTypes.iterator().next();
        return MediaType.parse((String)mimeType);
    }

    private static ValueResolver getValueResolverFor(String parameterName, MetadataType metadataType, Object value, Object defaultValue, ExpressionSupport expressionSupport, boolean required, Set<ModelProperty> modelProperties, boolean acceptsReferences, ValueResolverFactory valueResolverFactory) {
        return valueResolverFactory.of(parameterName, metadataType, value, defaultValue, expressionSupport, required, modelProperties, acceptsReferences);
    }

    private static Object resolveAndInjectIfStatic(ValueResolver valueResolver, MuleContext muleContext) throws MuleException {
        if (valueResolver.isDynamic()) {
            return valueResolver;
        }
        return FunctionalUtils.withNullEvent(event -> {
            try (ValueResolvingContext ctx = ValueResolvingContext.builder(event, (ExpressionManager)muleContext.getExpressionManager()).build();){
                Object staticProduct = valueResolver.resolve(ctx);
                if (staticProduct != null) {
                    muleContext.getInjector().inject(staticProduct);
                }
                Object t = staticProduct;
                return t;
            }
        });
    }

    private static Optional<ValueResolver> getPojoParameterValueResolver(String parameterName, ObjectType objectType, Object value, ReflectionCache reflectionCache, MuleContext muleContext, ValueResolverFactory valueResolverFactory) throws MuleException {
        Optional pojoClass = ExtensionMetadataTypeUtils.getType((MetadataType)objectType);
        if (pojoClass.isPresent() && value instanceof Map) {
            DefaultObjectBuilder objectBuilder = new DefaultObjectBuilder((Class)pojoClass.get(), reflectionCache);
            Iterator iterator = objectType.getFields().iterator();
            while (iterator.hasNext()) {
                Map valuesMap = (Map)value;
                ObjectFieldType objectFieldType = (ObjectFieldType)iterator.next();
                if (!valuesMap.containsKey(objectFieldType.getKey().getName().toString())) continue;
                objectBuilder.addPropertyResolver(objectFieldType.getKey().getName().toString(), (ValueResolver<Object>)ResolverSetUtils.getParameterValueResolver(parameterName, objectFieldType.getValue(), valuesMap.get(objectFieldType.getKey().getName().toString()), Collections.emptySet(), reflectionCache, muleContext, valueResolverFactory, false));
            }
            ObjectBuilderValueResolver objectBuilderValueResolver = new ObjectBuilderValueResolver(objectBuilder, muleContext);
            return Optional.of(objectBuilderValueResolver);
        }
        return Optional.empty();
    }

    private static ValueResolver getParameterValueResolverForCollection(String parameterName, ArrayType arrayType, Collection collection, ReflectionCache reflectionCache, MuleContext muleContext, ValueResolverFactory valueResolverFactory) throws MuleException {
        Optional expectedType = ExtensionMetadataTypeUtils.getType((MetadataType)arrayType);
        if (expectedType.isPresent()) {
            Class type = (Class)expectedType.get();
            ArrayList itemsResolvers = new ArrayList();
            for (Object collectionItem : collection) {
                itemsResolvers.add(ResolverSetUtils.getParameterValueResolver(parameterName, arrayType.getType(), collectionItem, Collections.emptySet(), reflectionCache, muleContext, valueResolverFactory, false));
            }
            return CollectionValueResolver.of(type, itemsResolvers);
        }
        return new StaticValueResolver<Collection>(collection);
    }

    private static ValueResolver getParameterValueResolverForMap(String parameterName, ObjectType type, Map<Object, Object> map, ReflectionCache reflectionCache, MuleContext muleContext, ValueResolverFactory valueResolverFactory) throws MuleException {
        Optional mapClassOptional = ExtensionMetadataTypeUtils.getType((MetadataType)type);
        Class mapClass = (Class)mapClassOptional.get();
        MetadataType valueType = type.getOpenRestriction().orElse(null);
        Function<Object, ValueResolver> valueValueResolverFunction = valueType != null ? value -> {
            try {
                return ResolverSetUtils.getParameterValueResolver(parameterName, valueType, value, Collections.emptySet(), reflectionCache, muleContext, valueResolverFactory, false);
            }
            catch (MuleException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        } : value -> new StaticValueResolver<Object>(value);
        ArrayList keyResolvers = new ArrayList();
        ArrayList valueResolvers = new ArrayList();
        for (Map.Entry<Object, Object> mapEntry : map.entrySet()) {
            keyResolvers.add(new StaticValueResolver<String>(mapEntry.getKey().toString()));
            valueResolvers.add(valueValueResolverFunction.apply(mapEntry.getValue()));
        }
        return MapValueResolver.of(mapClass, keyResolvers, valueResolvers, reflectionCache, muleContext);
    }

    public static boolean acceptsReferences(ParameterModel parameterModel) {
        return parameterModel.getDslConfiguration().allowsReferences();
    }
}

