/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.client.operation;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutorFactory;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.module.extension.internal.loader.java.property.FieldOperationParameterModelProperty;
import org.mule.runtime.module.extension.internal.runtime.client.NullComponent;
import org.mule.runtime.module.extension.internal.runtime.client.operation.OperationKey;
import org.mule.runtime.module.extension.internal.runtime.execution.CompletableOperationExecutorFactory;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ComponentExecutorResolver {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ComponentExecutorResolver.class);
    protected final OperationKey key;
    private final ExtensionManager extensionManager;
    private final ExpressionManager expressionManager;
    private final ReflectionCache reflectionCache;
    protected final MuleContext muleContext;

    static ComponentExecutorResolver from(OperationKey key, ExtensionManager extensionManager, ExpressionManager expressionManager, ReflectionCache reflectionCache, MuleContext muleContext) {
        List<ParameterModel> initParameterModels = key.getOperationModel().getAllParameterModels().stream().filter(p -> p.getModelProperty(FieldOperationParameterModelProperty.class).isPresent()).collect(Collectors.toList());
        return initParameterModels.isEmpty() ? new StaticComponentExecutorResolver(key, extensionManager, expressionManager, reflectionCache, muleContext) : new WithInitParamsComponentExecutorResolver(initParameterModels, key, extensionManager, expressionManager, reflectionCache, muleContext);
    }

    private ComponentExecutorResolver(OperationKey key, ExtensionManager extensionManager, ExpressionManager expressionManager, ReflectionCache reflectionCache, MuleContext muleContext) {
        this.key = key;
        this.extensionManager = extensionManager;
        this.expressionManager = expressionManager;
        this.reflectionCache = reflectionCache;
        this.muleContext = muleContext;
    }

    abstract CompletableComponentExecutor<OperationModel> resolveExecutor(Map<String, Object> var1);

    protected CompletableComponentExecutor<OperationModel> doCreateExecutor(Map<String, Object> initParams) {
        OperationModel operationModel = this.key.getOperationModel();
        CompletableComponentExecutorFactory<OperationModel> operationExecutorFactory = MuleExtensionUtils.getOperationExecutorFactory(operationModel);
        try {
            initParams.putAll(CompletableOperationExecutorFactory.extractExecutorInitialisationParams(this.key.getExtensionModel(), (ComponentModel)operationModel, initParams, NullComponent.NULL_COMPONENT, Optional.empty(), this.extensionManager, this.expressionManager, this.reflectionCache));
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Exception found resolving parameters for operation client: " + e.getMessage())), (Throwable)e);
        }
        CompletableComponentExecutor executor = operationExecutorFactory.createExecutor((ComponentModel)operationModel, initParams);
        try {
            LifecycleUtils.initialiseIfNeeded((Object)executor, (boolean)true, (MuleContext)this.muleContext);
            LifecycleUtils.startIfNeeded((Object)executor);
            return executor;
        }
        catch (MuleException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    protected void dispose(CompletableComponentExecutor<OperationModel> executor) {
        try {
            LifecycleUtils.stopIfNeeded(executor);
        }
        catch (Exception e) {
            LOGGER.error(String.format("Exception found stopping operation executor. %s", e.getMessage()), (Throwable)e);
        }
        finally {
            LifecycleUtils.disposeIfNeeded(executor, (Logger)LOGGER);
        }
    }

    private class SelfDestructingExecutorCallbackDecorator
    implements CompletableComponentExecutor.ExecutorCallback {
        private final CompletableComponentExecutor<OperationModel> executor;
        private final CompletableComponentExecutor.ExecutorCallback delegate;

        public SelfDestructingExecutorCallbackDecorator(CompletableComponentExecutor<OperationModel> executor, CompletableComponentExecutor.ExecutorCallback delegate) {
            this.executor = executor;
            this.delegate = delegate;
        }

        public void complete(Object value) {
            try {
                this.delegate.complete(value);
            }
            finally {
                ComponentExecutorResolver.this.dispose(this.executor);
            }
        }

        public void error(Throwable e) {
            try {
                this.delegate.error(e);
            }
            finally {
                ComponentExecutorResolver.this.dispose(this.executor);
            }
        }
    }

    private class SelfDestructingExecutorDecorator
    implements CompletableComponentExecutor<OperationModel> {
        private final CompletableComponentExecutor<OperationModel> delegate;

        private SelfDestructingExecutorDecorator(CompletableComponentExecutor<OperationModel> delegate) {
            this.delegate = delegate;
        }

        public void execute(ExecutionContext<OperationModel> executionContext, CompletableComponentExecutor.ExecutorCallback callback) {
            this.delegate.execute(executionContext, (CompletableComponentExecutor.ExecutorCallback)new SelfDestructingExecutorCallbackDecorator(this.delegate, callback));
        }
    }

    private static class WithInitParamsComponentExecutorResolver
    extends ComponentExecutorResolver {
        private List<ParameterModel> initParamModels;

        public WithInitParamsComponentExecutorResolver(List<ParameterModel> initParamModels, OperationKey key, ExtensionManager extensionManager, ExpressionManager expressionManager, ReflectionCache reflectionCache, MuleContext muleContext) {
            super(key, extensionManager, expressionManager, reflectionCache, muleContext);
            this.initParamModels = initParamModels;
        }

        @Override
        public CompletableComponentExecutor<OperationModel> resolveExecutor(Map<String, Object> params) {
            HashMap<String, Object> initParams = new HashMap<String, Object>();
            this.initParamModels.forEach(p -> {
                String paramName = p.getName();
                if (params.containsKey(paramName)) {
                    initParams.put(paramName, params.get(paramName));
                }
            });
            return new SelfDestructingExecutorDecorator(this.doCreateExecutor(initParams));
        }
    }

    private static class StaticComponentExecutorResolver
    extends ComponentExecutorResolver
    implements Disposable {
        private final CompletableComponentExecutor<OperationModel> executor = this.doCreateExecutor(Collections.emptyMap());

        public StaticComponentExecutorResolver(OperationKey key, ExtensionManager extensionManager, ExpressionManager expressionManager, ReflectionCache reflectionCache, MuleContext muleContext) {
            super(key, extensionManager, expressionManager, reflectionCache, muleContext);
        }

        @Override
        public CompletableComponentExecutor<OperationModel> resolveExecutor(Map<String, Object> params) {
            return this.executor;
        }

        public void dispose() {
            this.dispose(this.executor);
        }
    }
}

