/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.metadata;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceCallbackDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.TypedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithOutputDeclaration;
import org.mule.runtime.api.metadata.resolving.AttributesTypeResolver;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.module.extension.api.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.annotations.CustomDefinedStaticTypeAnnotation;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaAttributesResolverModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaInputResolverModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaKeyIdResolverModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaOutputResolverModelParser;
import org.mule.runtime.module.extension.internal.loader.utils.JavaInputResolverModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.utils.JavaMetadataKeyIdModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.utils.JavaOutputResolverModelParserUtils;
import org.mule.runtime.module.extension.internal.metadata.MetadataScopeAdapter;
import org.mule.sdk.api.metadata.NullMetadataResolver;

public final class DefaultMetadataScopeAdapter
implements MetadataScopeAdapter {
    private JavaKeyIdResolverModelParser javaKeyIdResolverModelParser = new JavaKeyIdResolverModelParser(null, null, NullMetadataResolver.class);
    private JavaOutputResolverModelParser javaOutputResolverModelParser = new JavaOutputResolverModelParser(NullMetadataResolver.class);
    private JavaAttributesResolverModelParser javaAttributesResolverModelParser = new JavaAttributesResolverModelParser(NullMetadataResolver.class);
    private List<JavaInputResolverModelParser> javaInputResolverModelParsers = Collections.emptyList();

    public DefaultMetadataScopeAdapter(Type extensionElement, MethodElement operation, OperationDeclaration declaration) {
        this.javaInputResolverModelParsers = JavaInputResolverModelParserUtils.parseInputResolversModelParser(declaration);
        if (JavaOutputResolverModelParserUtils.hasOutputResolverAnnotation(operation) || !this.javaInputResolverModelParsers.isEmpty()) {
            if (!this.hasCustomStaticType((TypedDeclaration)declaration.getOutput())) {
                this.javaOutputResolverModelParser = JavaOutputResolverModelParserUtils.parseOutputResolverModelParser(operation);
            }
            if (!this.hasCustomStaticType((TypedDeclaration)declaration.getOutputAttributes())) {
                this.javaAttributesResolverModelParser = JavaOutputResolverModelParserUtils.parseAttributesResolverModelParser(operation);
            }
            Supplier<String> categoryName = () -> this.getCategoryName(this.javaOutputResolverModelParser, this.javaAttributesResolverModelParser, this.javaInputResolverModelParsers);
            this.javaKeyIdResolverModelParser = JavaMetadataKeyIdModelParserUtils.parseKeyIdResolverModelParser(categoryName, operation);
        } else {
            this.initializeFromClass(extensionElement, (Type)operation.getEnclosingType(), (WithOutputDeclaration)declaration);
        }
    }

    public DefaultMetadataScopeAdapter(Type extensionElement, Type source, SourceDeclaration sourceDeclaration) {
        this.initializeFromClass(extensionElement, source, (WithOutputDeclaration)sourceDeclaration);
    }

    public DefaultMetadataScopeAdapter(SourceCallbackDeclaration sourceCallbackDeclaration) {
        this.javaInputResolverModelParsers = JavaInputResolverModelParserUtils.parseInputResolversModelParser(sourceCallbackDeclaration);
    }

    private void initializeFromClass(Type extensionType, Type annotatedType, WithOutputDeclaration declaration) {
        Optional<Class<?>> extensionClass = extensionType.getDeclaringClass();
        Optional<Class<?>> componentClass = annotatedType.getDeclaringClass();
        if (componentClass.isPresent() && extensionClass.isPresent()) {
            boolean hasMetadataScopeAnnotation;
            boolean bl = hasMetadataScopeAnnotation = JavaOutputResolverModelParserUtils.hasMetadataScopeAnnotation(componentClass.get()) || JavaOutputResolverModelParserUtils.hasMetadataScopeAnnotation(extensionClass.get());
            if (hasMetadataScopeAnnotation && !this.hasCustomStaticType((TypedDeclaration)declaration.getOutput())) {
                this.javaKeyIdResolverModelParser = JavaMetadataKeyIdModelParserUtils.parseKeyIdResolverModelParser(extensionType, annotatedType);
                this.javaOutputResolverModelParser = JavaOutputResolverModelParserUtils.parseOutputResolverModelParser(extensionType, annotatedType);
                this.javaAttributesResolverModelParser = JavaOutputResolverModelParserUtils.parseAttributesResolverModelParser(extensionType, annotatedType);
            }
        }
    }

    private String getCategoryName(JavaOutputResolverModelParser javaOutputResolverModelParser, JavaAttributesResolverModelParser javaAttributesResolverModelParser, List<JavaInputResolverModelParser> javaInputResolverModelParsers) {
        OutputTypeResolver namedTypeResolver = javaOutputResolverModelParser.getOutputResolver();
        if (javaOutputResolverModelParser.hasOutputResolver()) {
            return namedTypeResolver.getCategoryName();
        }
        AttributesTypeResolver namedTypeAttributesResolver = javaAttributesResolverModelParser.getAttributesResolver();
        if (javaAttributesResolverModelParser.hasAttributesResolver()) {
            return namedTypeAttributesResolver.getCategoryName();
        }
        for (JavaInputResolverModelParser inputResolverModelParser : javaInputResolverModelParsers) {
            InputTypeResolver inputTypeResolver = inputResolverModelParser.getInputResolver();
            if (inputTypeResolver instanceof org.mule.runtime.extension.api.metadata.NullMetadataResolver) continue;
            return inputTypeResolver.getCategoryName();
        }
        throw new IllegalModelDefinitionException("Unable to create Keys Resolver. A Keys Resolver is being defined without defining an Output Resolver, Input Resolver nor Attributes Resolver");
    }

    private boolean hasCustomStaticType(TypedDeclaration declaration) {
        return declaration.getType().getAnnotation(CustomDefinedStaticTypeAnnotation.class).isPresent();
    }

    @Override
    public boolean isCustomScope() {
        return this.hasOutputResolver() || this.hasInputResolvers();
    }

    @Override
    public boolean hasKeysResolver() {
        return this.javaKeyIdResolverModelParser.hasKeyIdResolver();
    }

    @Override
    public boolean hasInputResolvers() {
        return !this.javaInputResolverModelParsers.isEmpty();
    }

    @Override
    public boolean hasOutputResolver() {
        return this.javaOutputResolverModelParser.hasOutputResolver();
    }

    @Override
    public boolean hasAttributesResolver() {
        return this.javaAttributesResolverModelParser.hasAttributesResolver();
    }

    @Override
    public boolean isPartialKeyResolver() {
        return this.javaKeyIdResolverModelParser.isPartialKeyResolver();
    }

    @Override
    public TypeKeysResolver getKeysResolver() {
        return this.javaKeyIdResolverModelParser.getKeyResolver();
    }

    @Override
    public Map<String, Supplier<? extends InputTypeResolver>> getInputResolvers() {
        HashMap<String, Supplier<? extends InputTypeResolver>> inputTypeResolvers = new HashMap<String, Supplier<? extends InputTypeResolver>>();
        this.javaInputResolverModelParsers.forEach(parser -> inputTypeResolvers.put(parser.getParameterName(), parser::getInputResolver));
        return inputTypeResolvers;
    }

    @Override
    public OutputTypeResolver getOutputResolver() {
        return this.javaOutputResolverModelParser.getOutputResolver();
    }

    @Override
    public AttributesTypeResolver getAttributesResolver() {
        return this.javaAttributesResolverModelParser.getAttributesResolver();
    }
}

