/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java.error;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.extension.api.annotation.OnException;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalOperationModelDefinitionException;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.api.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.api.loader.java.type.OperationElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.api.loader.java.type.WithAnnotations;
import org.mule.runtime.module.extension.internal.error.AstElementErrorTypeDefinitionAdapter;
import org.mule.runtime.module.extension.internal.error.ErrorModelUtils;
import org.mule.runtime.module.extension.internal.error.SdkErrorTypeDefinitionAdapter;
import org.mule.runtime.module.extension.internal.error.SdkErrorTypeProviderAdapter;
import org.mule.runtime.module.extension.internal.loader.java.property.ExceptionHandlerModelProperty;
import org.mule.runtime.module.extension.internal.loader.parser.ErrorModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.ExtensionModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.MuleExtensionAnnotationParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.error.JavaErrorModelParser;
import org.mule.runtime.module.extension.internal.runtime.exception.DefaultExceptionHandlerFactory;
import org.mule.sdk.api.annotation.error.ErrorTypeProvider;
import org.mule.sdk.api.annotation.error.ErrorTypes;
import org.mule.sdk.api.error.ErrorTypeDefinition;

public final class JavaErrorModelParserUtils {
    private static final String MULE = "mule".toUpperCase(Locale.ROOT);

    public static List<ErrorModelParser> parseExtensionErrorModels(ExtensionElement element, String extensionNamespace) {
        return MuleExtensionAnnotationParser.mapReduceSingleAnnotation(element, org.mule.runtime.extension.api.annotation.error.ErrorTypes.class, ErrorTypes.class, value -> JavaErrorModelParserUtils.parseErrorTypeDefinitions(value.getClassValue(org.mule.runtime.extension.api.annotation.error.ErrorTypes::value), extensionNamespace), value -> JavaErrorModelParserUtils.parseErrorTypeDefinitions(value.getClassValue(ErrorTypes::value), extensionNamespace)).orElse(new LinkedList());
    }

    public static List<ErrorModelParser> parseOperationErrorModels(ExtensionModelParser extensionParser, ExtensionElement extensionElement, OperationElement operation) {
        return JavaErrorModelParserUtils.getThrowsDeclaration(operation, extensionElement).flatMap(withThrows -> MuleExtensionAnnotationParser.mapReduceAnnotation(withThrows, Throws.class, org.mule.sdk.api.annotation.error.Throws.class, ann -> JavaErrorModelParserUtils.parseErrorTypeProviders(ann.getClassArrayValue(Throws::value), extensionParser), ann -> JavaErrorModelParserUtils.parseErrorTypeProviders(ann.getClassArrayValue(org.mule.sdk.api.annotation.error.Throws::value), extensionParser), JavaErrorModelParserUtils.dualThrowsException(operation))).orElse(new LinkedList());
    }

    public static Class<?> getDeclarationClass(ErrorTypeDefinition errorTypeDefinition) {
        return errorTypeDefinition instanceof SdkErrorTypeDefinitionAdapter ? ((SdkErrorTypeDefinitionAdapter)errorTypeDefinition).getDelegate().getClass() : errorTypeDefinition.getClass();
    }

    public static Optional<ExceptionHandlerModelProperty> getExceptionHandlerModelProperty(WithAnnotations element, String elementType, String elementName) {
        Optional<Type> classValue = MuleExtensionAnnotationParser.mapReduceSingleAnnotation(element, elementType, elementName, OnException.class, org.mule.sdk.api.annotation.OnException.class, ann -> ann.getClassValue(OnException::value), ann -> ann.getClassValue(org.mule.sdk.api.annotation.OnException::value));
        return classValue.flatMap(c -> c.getDeclaringClass()).map(clazz -> new ExceptionHandlerModelProperty(new DefaultExceptionHandlerFactory((Class<?>)clazz)));
    }

    private static List<ErrorModelParser> parseErrorTypeDefinitions(Type type, String extensionNamespace) {
        HashMap cycleControl = new HashMap(Collections.emptyMap());
        if (type.getDeclaringClass().isPresent()) {
            Class<?> enumClass = type.getDeclaringClass().get();
            return Stream.of(enumClass.getEnumConstants()).map(def -> JavaErrorModelParserUtils.toParser(extensionNamespace, SdkErrorTypeDefinitionAdapter.from(def), cycleControl)).collect(Collectors.toList());
        }
        return type.getElement().map(element -> element.getEnclosedElements().stream().filter(enclosed -> enclosed.getKind().equals((Object)ElementKind.ENUM_CONSTANT)).map(def -> JavaErrorModelParserUtils.toParser(extensionNamespace, new AstElementErrorTypeDefinitionAdapter((Element)def), cycleControl)).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    private static void validateOperationThrows(ExtensionModelParser extensionParser, ErrorTypeDefinition error) {
        Class<?> errorDefinitionClass = JavaErrorModelParserUtils.getDeclarationClass(error);
        if (ErrorModelUtils.isMuleError(error) || extensionParser.getErrorModelParsers().isEmpty()) {
            return;
        }
        JavaErrorModelParser errorModelParser = (JavaErrorModelParser)extensionParser.getErrorModelParsers().get(0);
        Class<?> extensionErrorType = errorModelParser.getErrorTypeDefinitionDeclarationClass();
        if (!errorDefinitionClass.equals(extensionErrorType) && !errorDefinitionClass.getSuperclass().equals(extensionErrorType)) {
            throw new IllegalModelDefinitionException(String.format("Invalid operation throws detected, the extension declared to throw errors of %s type, but an error of %s type has been detected", extensionErrorType, error.getClass()));
        }
    }

    public static ErrorModelParser toParser(String extensionNamespace, ErrorTypeDefinition<?> errorTypeDefinition) {
        return JavaErrorModelParserUtils.toParser(extensionNamespace, errorTypeDefinition, new HashMap<ErrorTypeDefinition, ErrorModelParser>());
    }

    private static ErrorModelParser toParser(String extensionNamespace, ErrorTypeDefinition<?> errorTypeDefinition, Map<ErrorTypeDefinition, ErrorModelParser> cycleControl) {
        JavaErrorModelParser parser = new JavaErrorModelParser(errorTypeDefinition, ErrorModelUtils.isMuleError(errorTypeDefinition) ? MULE : extensionNamespace);
        cycleControl.put(errorTypeDefinition, parser);
        parser.setParent(errorTypeDefinition.getParent().map(p -> {
            ErrorModelParser parentParser = (ErrorModelParser)cycleControl.get(p);
            if (parentParser == null) {
                parentParser = JavaErrorModelParserUtils.toParser(extensionNamespace, p, cycleControl);
                cycleControl.put((ErrorTypeDefinition)p, parentParser);
            }
            return parentParser;
        }));
        return parser;
    }

    private static List<ErrorModelParser> parseErrorTypeProviders(List<Type> providerTypes, ExtensionModelParser extensionParser) {
        HashMap cycleControl = new HashMap();
        return providerTypes.stream().filter(type -> type.getDeclaringClass().isPresent()).flatMap(type -> {
            try {
                ErrorTypeProvider errorTypeProvider = SdkErrorTypeProviderAdapter.from(type.getDeclaringClass().get().newInstance());
                return errorTypeProvider.getErrorTypes().stream().map(error -> {
                    JavaErrorModelParserUtils.validateOperationThrows(extensionParser, error);
                    return JavaErrorModelParserUtils.toParser(extensionParser.getNamespace(), error, cycleControl);
                });
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not create ErrorTypeProvider of type " + type.getName())), (Throwable)e);
            }
        }).collect(Collectors.toList());
    }

    private static Optional<WithAnnotations> getThrowsDeclaration(MethodElement operationMethod, Type extensionElement) {
        if (JavaErrorModelParserUtils.hasThrowsDeclaration(operationMethod)) {
            return Optional.of(operationMethod);
        }
        Object operationContainer = operationMethod.getEnclosingType();
        if (JavaErrorModelParserUtils.hasThrowsDeclaration(operationContainer)) {
            return Optional.of(operationContainer);
        }
        if (JavaErrorModelParserUtils.hasThrowsDeclaration(extensionElement)) {
            return Optional.of(extensionElement);
        }
        return Optional.empty();
    }

    private static boolean hasThrowsDeclaration(WithAnnotations annotated) {
        return annotated.isAnnotatedWith(Throws.class) || annotated.isAnnotatedWith(org.mule.sdk.api.annotation.error.Throws.class);
    }

    private static Supplier<IllegalModelDefinitionException> dualThrowsException(OperationElement operation) {
        return () -> new IllegalOperationModelDefinitionException(String.format("Operation '%s' is annotated with '@%s' and '@%s' at the same time", operation.getAlias(), Throws.class.getName(), org.mule.sdk.api.annotation.error.Throws.class.getName()));
    }

    private JavaErrorModelParserUtils() {
    }
}

