/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.Cursor;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.profiling.tracing.event.span.InternalSpan;
import org.mule.runtime.core.internal.profiling.tracing.event.span.InternalSpanError;
import org.mule.runtime.core.internal.profiling.tracing.event.tracer.CoreEventTracer;
import org.mule.runtime.core.internal.profiling.tracing.event.tracer.TracingCondition;
import org.mule.runtime.core.internal.trace.DistributedTraceContext;
import org.mule.runtime.core.internal.util.message.stream.UnclosableCursorStream;
import org.mule.runtime.module.extension.internal.loader.java.property.stackabletypes.StackedTypesModelProperty;
import org.mule.runtime.module.extension.internal.runtime.parameter.PropagateAllDistributedTraceContextManager;
import org.mule.runtime.module.extension.internal.runtime.resolver.ExpressionBasedParameterResolverValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ExpressionTypedValueValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeExpressionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.sdk.api.runtime.source.DistributedTraceContextManager;

public class ResolverUtils {
    private ResolverUtils() {
    }

    static ValueResolver<?> getFieldDefaultValueValueResolver(ObjectFieldType field, MuleContext muleContext) {
        Optional defaultValue = MetadataTypeUtils.getDefaultValue((MetadataType)field);
        Preconditions.checkArgument((boolean)defaultValue.isPresent(), (String)("No default value available for field :" + field.getKey().getName()));
        return ResolverUtils.getExpressionBasedValueResolver((String)defaultValue.get(), field.getValue(), muleContext);
    }

    static ValueResolver<?> getFieldDefaultValueValueResolver(MetadataType fieldType, String defaultValue, MuleContext muleContext) {
        return ResolverUtils.getExpressionBasedValueResolver(defaultValue, fieldType, muleContext);
    }

    public static ValueResolver<?> getExpressionBasedValueResolver(String expression, MetadataType metadataType, MuleContext muleContext) {
        return ResolverUtils.getExpressionBasedValueResolver(expression, () -> IntrospectionUtils.isTypedValue(metadataType), () -> IntrospectionUtils.isParameterResolver(metadataType), Optional.empty(), metadataType, muleContext);
    }

    static ValueResolver<?> getExpressionBasedValueResolver(String expression, ParameterModel operationModel, MuleContext muleContext) {
        MetadataType metadataType = operationModel.getType();
        return ResolverUtils.getExpressionBasedValueResolver(expression, () -> IntrospectionUtils.isTypedValue(metadataType), () -> IntrospectionUtils.isParameterResolver(metadataType), StackedTypesModelProperty.getStackedTypesModelProperty(operationModel.getModelProperties()), metadataType, muleContext);
    }

    static ValueResolver<?> getDefaultValueResolver(ParameterModel parameter, MuleContext muleContext) {
        Object defaultValue = parameter.getDefaultValue();
        if (defaultValue instanceof String) {
            return ResolverUtils.getExpressionBasedValueResolver((String)defaultValue, parameter, muleContext);
        }
        if (defaultValue != null) {
            return new StaticValueResolver<Object>(defaultValue);
        }
        return null;
    }

    public static <T> T resolveRecursively(ValueResolver<T> valueResolver, ValueResolvingContext resolvingContext) throws MuleException {
        T resolve = valueResolver.resolve(resolvingContext);
        if (resolve instanceof ValueResolver) {
            resolve = ResolverUtils.resolveRecursively((ValueResolver)resolve, resolvingContext);
        }
        return resolve;
    }

    public static <T> T resolveValue(ValueResolver<T> resolver, ValueResolvingContext context) throws MuleException {
        T value = ResolverUtils.resolveRecursively(resolver, context);
        if (context == null || context.resolveCursors()) {
            return (T)ResolverUtils.resolveCursor(value);
        }
        return value;
    }

    public static Object resolveCursor(Object value) {
        if (value instanceof CursorProvider) {
            return ((CursorProvider)value).openCursor();
        }
        if (value instanceof TypedValue) {
            return ResolverUtils.resolveCursor((TypedValue)value);
        }
        return value;
    }

    public static TypedValue<?> resolveCursor(TypedValue<?> typedValue) {
        Object objectValue = typedValue.getValue();
        if (objectValue instanceof CursorProvider) {
            Cursor cursor = ((CursorProvider)objectValue).openCursor();
            return ResolverUtils.typedValue(typedValue, cursor);
        }
        return typedValue;
    }

    public static Object resolveCursorAsUnclosable(Object value) {
        if (value instanceof CursorProvider) {
            return ResolverUtils.resolveCursorProviderAsUnclosable((CursorProvider)value);
        }
        if (value instanceof TypedValue) {
            return ResolverUtils.resolveCursorAsUnclosable((TypedValue)value);
        }
        if (value instanceof CursorStream) {
            return new UnclosableCursorStream((CursorStream)value);
        }
        return value;
    }

    public static TypedValue<?> resolveCursorAsUnclosable(TypedValue<?> typedValue) {
        Object objectValue = typedValue.getValue();
        if (objectValue instanceof CursorProvider) {
            Cursor cursor = ResolverUtils.resolveCursorProviderAsUnclosable((CursorProvider)objectValue);
            return ResolverUtils.typedValue(typedValue, cursor);
        }
        if (objectValue instanceof CursorStream) {
            return new TypedValue((Object)new UnclosableCursorStream((CursorStream)objectValue), typedValue.getDataType(), typedValue.getByteLength());
        }
        return typedValue;
    }

    public static Object typedValueAsUnclosable(Object value) {
        if (value instanceof TypedValue) {
            return ResolverUtils.typedValueAsUnclosable((TypedValue)value);
        }
        if (value instanceof CursorStream) {
            return new UnclosableCursorStream((CursorStream)value);
        }
        return value;
    }

    public static TypedValue<?> typedValueAsUnclosable(TypedValue<?> typedValue) {
        Object objectValue = typedValue.getValue();
        if (objectValue instanceof CursorStream) {
            return new TypedValue((Object)new UnclosableCursorStream((CursorStream)objectValue), typedValue.getDataType(), typedValue.getByteLength());
        }
        return typedValue;
    }

    public static DistributedTraceContextManager resolveDistributedTraceContextManager(CoreEvent coreEvent, CoreEventTracer coreEventTracer) {
        return new PropagateAllDistributedTraceContextManager(ResolverUtils.resolveDistributedTraceContext(coreEvent, coreEventTracer));
    }

    public static DistributedTraceContext resolveDistributedTraceContext(CoreEvent event, CoreEventTracer coreEventTracer) {
        final Map map = coreEventTracer.getDistributedTraceContextMap(event);
        return new DistributedTraceContext(){

            public Optional<String> getTraceFieldValue(String key) {
                return Optional.ofNullable(map.get(key));
            }

            public Map<String, String> tracingFieldsAsMap() {
                return map;
            }

            public Optional<String> getBaggageItem(String key) {
                return Optional.empty();
            }

            public Map<String, String> baggageItemsAsMap() {
                return new HashMap<String, String>();
            }

            public DistributedTraceContext copy() {
                return this;
            }

            public void endCurrentContextSpan(TracingCondition tracingCondition) {
            }

            public void recordErrorAtCurrentSpan(InternalSpanError error) {
            }

            public void setCurrentSpan(InternalSpan span, TracingCondition tracingCondition) {
            }

            public Optional<InternalSpan> getCurrentSpan() {
                return Optional.empty();
            }
        };
    }

    private static Cursor resolveCursorProviderAsUnclosable(CursorProvider<?> cursorProvider) {
        Cursor cursor = cursorProvider.openCursor();
        if (cursor instanceof CursorStream) {
            return new UnclosableCursorStream((CursorStream)cursor);
        }
        return cursor;
    }

    private static TypedValue<?> typedValue(TypedValue<?> typedValue, Object value) {
        return new TypedValue(value, DataType.builder().type(value != null ? value.getClass() : Object.class).mediaType(typedValue.getDataType().getMediaType()).build(), typedValue.getByteLength());
    }

    private static ValueResolver<?> getExpressionBasedValueResolver(String expression, BooleanSupplier isTypedValue, BooleanSupplier isParameterResolver, Optional<StackedTypesModelProperty> stackedTypesModelProperty, MetadataType type, MuleContext muleContext) {
        try {
            Initialisable resolver;
            if (stackedTypesModelProperty.isPresent()) {
                resolver = stackedTypesModelProperty.get().getValueResolverFactory().getExpressionBasedValueResolver(expression, JavaTypeUtils.getType((MetadataType)type));
            } else if (isTypedValue.getAsBoolean()) {
                ExpressionTypedValueValueResolver valueResolver = new ExpressionTypedValueValueResolver(expression, JavaTypeUtils.getType((MetadataType)type));
                valueResolver.setTransformationService(muleContext.getTransformationService());
                valueResolver.setExtendedExpressionManager(muleContext.getExpressionManager());
                resolver = valueResolver;
            } else if (isParameterResolver.getAsBoolean()) {
                ExpressionBasedParameterResolverValueResolver valueResolver = new ExpressionBasedParameterResolverValueResolver(expression, JavaTypeUtils.getType((MetadataType)type), IntrospectionUtils.toDataType(type));
                valueResolver.setTransformationService(muleContext.getTransformationService());
                valueResolver.setExtendedExpressionManager(muleContext.getExpressionManager());
                resolver = valueResolver;
            } else if (muleContext.getExpressionManager().isExpression(expression)) {
                TypeSafeExpressionValueResolver valueResolver = new TypeSafeExpressionValueResolver(expression, JavaTypeUtils.getType((MetadataType)type), IntrospectionUtils.toDataType(type));
                valueResolver.setTransformationService(muleContext.getTransformationService());
                valueResolver.setExtendedExpressionManager(muleContext.getExpressionManager());
                resolver = valueResolver;
            } else {
                TypeSafeValueResolverWrapper typeSafeValueResolverWrapper = new TypeSafeValueResolverWrapper(new StaticValueResolver<String>(expression), JavaTypeUtils.getType((MetadataType)type));
                typeSafeValueResolverWrapper.setTransformationService(muleContext.getTransformationService());
                resolver = typeSafeValueResolverWrapper;
            }
            LifecycleUtils.initialiseIfNeeded((Object)resolver, (MuleContext)muleContext);
            return resolver;
        }
        catch (InitialisationException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }
}

