/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.util.List;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.internal.exception.EnrichedErrorMapping;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.internal.property.PagedOperationModelProperty;
import org.mule.runtime.module.extension.internal.runtime.operation.ComponentMessageProcessorBuilder;
import org.mule.runtime.module.extension.internal.runtime.operation.OAuthOperationMessageProcessor;
import org.mule.runtime.module.extension.internal.runtime.operation.OperationMessageProcessor;
import org.mule.runtime.module.extension.internal.runtime.operation.ResultTransformer;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public final class OperationMessageProcessorBuilder
extends ComponentMessageProcessorBuilder<OperationModel, OperationMessageProcessor> {
    private final List<EnrichedErrorMapping> errorMappings;

    public OperationMessageProcessorBuilder(ExtensionModel extension, OperationModel operation, List<EnrichedErrorMapping> errorMappings, PolicyManager policyManager, MuleContext muleContext, Registry registry) {
        super(extension, operation, policyManager, (ReflectionCache)registry.lookupByType(ReflectionCache.class).get(), (ExpressionManager)registry.lookupByType(ExpressionManager.class).get(), muleContext, registry);
        this.errorMappings = errorMappings;
    }

    @Override
    protected OperationMessageProcessor createMessageProcessor(ExtensionManager extensionManager, ResolverSet arguments) {
        ValueResolver<ConfigurationProvider> configurationProviderResolver = this.getConfigurationProviderResolver();
        ResultTransformer resultTransformer = null;
        boolean supportsOAuth = MuleExtensionUtils.supportsOAuth(this.extensionModel);
        if (((OperationModel)this.operationModel).getModelProperty(PagedOperationModelProperty.class).isPresent()) {
            resultTransformer = MuleExtensionUtils.getPagingResultTransformer((OperationModel)this.operationModel, this.extensionConnectionSupplier, supportsOAuth).orElse(null);
        }
        if (supportsOAuth) {
            return new OAuthOperationMessageProcessor(this.extensionModel, (OperationModel)this.operationModel, configurationProviderResolver, this.target, this.targetValue, this.errorMappings, arguments, this.cursorProviderFactory, this.retryPolicyTemplate, this.nestedChain, extensionManager, this.policyManager, this.reflectionCache, resultTransformer, this.terminationTimeout);
        }
        return new OperationMessageProcessor(this.extensionModel, (OperationModel)this.operationModel, configurationProviderResolver, this.target, this.targetValue, this.errorMappings, arguments, this.cursorProviderFactory, this.retryPolicyTemplate, this.nestedChain, extensionManager, this.policyManager, this.reflectionCache, resultTransformer, this.terminationTimeout);
    }
}

