/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.client.operation;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.util.DataSize;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.retry.policy.NoRetryPolicyTemplate;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.retry.policy.SimpleRetryPolicyTemplate;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.streaming.NullCursorProviderFactory;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.streaming.bytes.FileStoreCursorStreamConfig;
import org.mule.runtime.core.api.streaming.bytes.InMemoryCursorStreamConfig;
import org.mule.runtime.core.api.streaming.object.FileStoreCursorIteratorConfig;
import org.mule.runtime.core.api.streaming.object.InMemoryCursorIteratorConfig;
import org.mule.runtime.extension.api.client.OperationParameterizer;
import org.mule.runtime.extension.api.component.ComponentParameterization;
import org.mule.runtime.module.extension.internal.runtime.client.operation.InternalOperationParameterizer;

public class DefaultOperationParameterizer
implements InternalOperationParameterizer {
    private static final CursorProviderFactory NULL_CURSOR_PROVIDER_FACTORY = new NullCursorProviderFactory();
    private String configRef;
    private final Map<String, Object> rawParameters = new HashMap<String, Object>();
    private final Map<Pair<String, String>, Object> groupedParameters = new HashMap<Pair<String, String>, Object>();
    private Function<StreamingManager, CursorProviderFactory> cursorProviderFunction = sm -> NULL_CURSOR_PROVIDER_FACTORY;
    private RetryPolicyTemplate retryPolicyTemplate = new NoRetryPolicyTemplate();
    private CoreEvent contextEvent;

    public OperationParameterizer withConfigRef(String configRef) {
        this.configRef = configRef;
        return this;
    }

    public OperationParameterizer withParameter(String parameterName, Object value) {
        this.rawParameters.put(parameterName, value);
        return this;
    }

    public OperationParameterizer withParameter(String parameterGroup, String parameter, Object value) {
        this.groupedParameters.put((Pair<String, String>)new Pair((Object)parameterGroup, (Object)parameter), value);
        return this;
    }

    public OperationParameterizer withSimpleReconnection(int frequency, int maxAttempts) {
        this.retryPolicyTemplate = new SimpleRetryPolicyTemplate((long)frequency, maxAttempts);
        return this;
    }

    public OperationParameterizer reconnectingForever(int frequency) {
        this.withSimpleReconnection(frequency, -1);
        return this;
    }

    public OperationParameterizer withDefaultRepeatableStreaming() {
        this.cursorProviderFunction = sm -> sm.forBytes().getDefaultCursorProviderFactory();
        return this;
    }

    public OperationParameterizer withInMemoryRepeatableStreaming(DataSize initialBufferSize, DataSize bufferSizeIncrement, DataSize maxBufferSize) {
        this.cursorProviderFunction = sm -> sm.forBytes().getInMemoryCursorProviderFactory(new InMemoryCursorStreamConfig(initialBufferSize, bufferSizeIncrement, maxBufferSize));
        return this;
    }

    public OperationParameterizer withFileStoreRepeatableStreaming(DataSize maxInMemorySize) {
        this.cursorProviderFunction = sm -> sm.forBytes().getFileStoreCursorStreamProviderFactory(new FileStoreCursorStreamConfig(maxInMemorySize));
        return this;
    }

    public OperationParameterizer withDefaultRepeatableIterables() {
        this.cursorProviderFunction = sm -> sm.forObjects().getDefaultCursorProviderFactory();
        return this;
    }

    public OperationParameterizer withInMemoryRepeatableIterables(int initialBufferSize, int bufferSizeIncrement, int maxBufferSize) {
        this.cursorProviderFunction = sm -> sm.forObjects().getInMemoryCursorProviderFactory(new InMemoryCursorIteratorConfig(initialBufferSize, bufferSizeIncrement, maxBufferSize));
        return this;
    }

    public OperationParameterizer withFileStoreRepeatableIterables(int maxInMemoryInstances) {
        this.cursorProviderFunction = sm -> sm.forObjects().getFileStoreCursorIteratorProviderFactory(new FileStoreCursorIteratorConfig(maxInMemoryInstances));
        return this;
    }

    public OperationParameterizer inTheContextOf(Event event) {
        Preconditions.checkArgument((boolean)(event instanceof CoreEvent), (String)("event must be an instance of " + CoreEvent.class.getSimpleName()));
        this.contextEvent = (CoreEvent)event;
        return this;
    }

    public String getConfigRef() {
        return this.configRef;
    }

    public <T> CursorProviderFactory<T> getCursorProviderFactory(StreamingManager streamingManager) {
        return this.cursorProviderFunction.apply(streamingManager);
    }

    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.retryPolicyTemplate;
    }

    @Override
    public Optional<CoreEvent> getContextEvent() {
        return Optional.ofNullable(this.contextEvent);
    }

    public void setValuesOn(ComponentParameterization.Builder<OperationModel> builder) {
        this.rawParameters.forEach((arg_0, arg_1) -> builder.withParameter(arg_0, arg_1));
        this.groupedParameters.forEach((pair, value) -> builder.withParameter((String)pair.getFirst(), (String)pair.getSecond(), value));
    }
}

