/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.property.stackabletypes;

import java.util.Optional;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;

public class StackableType {
    private final Type type;
    private final ExpressionBasedResolverFactory expressionBasedResolverFactory;
    private final StaticResolverFactory staticResolverFactory;
    private final DelegateResolverFactory delegateResolverFactory;

    private StackableType(Type type, ExpressionBasedResolverFactory expressionBasedResolverFactory, StaticResolverFactory staticResolverFactory, DelegateResolverFactory delegateResolverFactory) {
        this.type = type;
        this.expressionBasedResolverFactory = expressionBasedResolverFactory;
        this.staticResolverFactory = staticResolverFactory;
        this.delegateResolverFactory = delegateResolverFactory;
    }

    public Type getType() {
        return this.type;
    }

    Optional<ExpressionBasedResolverFactory> getExpressionBasedResolverFactory() {
        return Optional.ofNullable(this.expressionBasedResolverFactory);
    }

    Optional<StaticResolverFactory> getStaticResolverFactory() {
        return Optional.ofNullable(this.staticResolverFactory);
    }

    Optional<DelegateResolverFactory> getDelegateResolverFactory() {
        return Optional.ofNullable(this.delegateResolverFactory);
    }

    public static <T> Builder<T> builder(Class<T> type) {
        return new Builder(new TypeWrapper(type, (ClassTypeLoader)new JavaTypeLoader(Thread.currentThread().getContextClassLoader())));
    }

    @FunctionalInterface
    public static interface DelegateResolverFactory<T> {
        public ValueResolver<T> getResolver(ValueResolver var1);
    }

    @FunctionalInterface
    public static interface StaticResolverFactory<T> {
        public ValueResolver<T> getResolver(Object var1);
    }

    @FunctionalInterface
    public static interface ExpressionBasedResolverFactory<T> {
        public ValueResolver<T> getResolver(String var1, Class<T> var2, boolean var3);
    }

    public static class Builder<T> {
        private final Type type;
        private ExpressionBasedResolverFactory<T> expressionBasedResolverFactory;
        private StaticResolverFactory staticResolverFactory;
        private DelegateResolverFactory delegateResolverFactory;

        private Builder(Type type) {
            this.type = type;
        }

        public Builder<T> setExpressionBasedResolverFactory(ExpressionBasedResolverFactory<T> expressionBasedResolverFactory) {
            this.expressionBasedResolverFactory = expressionBasedResolverFactory;
            return this;
        }

        public Builder<T> setStaticResolverFactory(StaticResolverFactory<T> staticResolverFactory) {
            this.staticResolverFactory = staticResolverFactory;
            return this;
        }

        public Builder<T> setDelegateResolverFactory(DelegateResolverFactory<T> delegateResolverFactory) {
            this.delegateResolverFactory = delegateResolverFactory;
            return this;
        }

        public StackableType build() {
            return new StackableType(this.type, this.expressionBasedResolverFactory, this.staticResolverFactory, this.delegateResolverFactory);
        }
    }
}

