/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.validation;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.Typed;
import org.mule.runtime.api.meta.model.ConnectableComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.data.sample.SampleDataProviderModel;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalOperationModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingMethodModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.InjectableParameterInfo;
import org.mule.runtime.module.extension.internal.loader.java.property.SampleDataProviderFactoryModelProperty;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.runtime.module.extension.internal.value.ValueProviderUtils;
import org.mule.sdk.api.data.sample.SampleDataProvider;
import org.mule.sdk.api.runtime.streaming.PagingProvider;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public final class JavaSampleDataModelValidator
implements ExtensionModelValidator {
    public void validate(ExtensionModel model, final ProblemsReporter problemsReporter) {
        final ReflectionCache reflectionCache = new ReflectionCache();
        final Delegate delegate = new Delegate(problemsReporter);
        new ExtensionWalker(){

            protected void onSource(HasSourceModels owner, SourceModel model) {
                JavaSampleDataModelValidator.this.validateModel((ConnectableComponentModel)model, this.isConfig(owner), problemsReporter, delegate, reflectionCache);
            }

            protected void onOperation(HasOperationModels owner, OperationModel model) {
                JavaSampleDataModelValidator.this.validateModel((ConnectableComponentModel)model, this.isConfig(owner), problemsReporter, delegate, reflectionCache);
            }

            private boolean isConfig(Object owner) {
                return owner instanceof ConfigurationModel;
            }
        }.walk(model);
        delegate.validateIdsAreUnique();
    }

    private void validateModel(ConnectableComponentModel model, boolean modelHasConfig, ProblemsReporter problemsReporter, Delegate delegate, ReflectionCache reflectionCache) {
        model.getModelProperty(SampleDataProviderFactoryModelProperty.class).ifPresent(modelProperty -> this.validateResolver(model, modelHasConfig, (SampleDataProviderFactoryModelProperty)modelProperty, problemsReporter, reflectionCache, delegate));
    }

    private void validateResolver(ConnectableComponentModel model, boolean modelHasConfig, SampleDataProviderFactoryModelProperty modelProperty, ProblemsReporter problemsReporter, ReflectionCache reflectionCache, Delegate delegate) {
        Class providerClass = modelProperty.getSampleDataProviderClass();
        this.validateGenerics(model, providerClass, problemsReporter);
        String providerName = providerClass.getSimpleName();
        Optional providerModel = model.getSampleDataProviderModel();
        if (!providerModel.isPresent()) {
            throw new IllegalModelDefinitionException(String.format("Component %s should have an associated SampleDataProviderModel.", model.getName()));
        }
        delegate.addInfo(new SampleDataProviderInfo((SampleDataProviderModel)providerModel.get(), model, providerClass.getName()));
        Map<String, MetadataType> allParameters = model.getAllParameterModels().stream().collect(Collectors.toMap(NamedObject::getName, Typed::getType));
        String modelName = NameUtils.getModelName((Object)model);
        String modelTypeName = NameUtils.getComponentModelTypeName((ParameterizedModel)model);
        if (!IntrospectionUtils.isInstantiable(providerClass, reflectionCache)) {
            problemsReporter.addError(new Problem((NamedObject)model, String.format("The SampleDataProvider [%s] is not instantiable", providerName)));
        }
        for (InjectableParameterInfo parameterInfo : modelProperty.getInjectableParameters()) {
            Class gotType;
            MetadataType metadataType;
            Class expectedType;
            String parameterName = ValueProviderUtils.getParameterNameFromExtractionExpression(parameterInfo.getExtractionExpression());
            if (!allParameters.containsKey(parameterName)) {
                problemsReporter.addError(new Problem((NamedObject)model, String.format("The SampleDataProvider [%s] declares to use a parameter '%s' which doesn't exist in the %s '%s'", providerName, parameterName, modelTypeName, modelName)));
                continue;
            }
            if (!parameterInfo.getExtractionExpression().equals(parameterInfo.getParameterName()) || (expectedType = (Class)ExtensionMetadataTypeUtils.getType((MetadataType)(metadataType = allParameters.get(parameterInfo.getParameterName()))).orElseThrow(() -> new IllegalStateException(String.format("Unable to get Class for parameter: %s", parameterInfo.getParameterName())))).equals(gotType = (Class)ExtensionMetadataTypeUtils.getType((MetadataType)parameterInfo.getType()).orElseThrow(() -> new IllegalStateException(String.format("Unable to get Class for parameter: %s", parameterInfo.getParameterName()))))) continue;
            problemsReporter.addError(new Problem((NamedObject)model, String.format("The SampleDataProvider [%s] defines a parameter '%s' of type '%s' but in the %s '%s' is of type '%s'", providerName, parameterInfo.getParameterName(), gotType, modelTypeName, modelName, expectedType)));
        }
        if (modelProperty.usesConnection() && !model.requiresConnection()) {
            problemsReporter.addError(new Problem((NamedObject)model, String.format("The SampleDataProvider [%s] defines that it requires a connection, but is used in the %s '%s' which is connection less", providerName, modelTypeName, modelName)));
        }
        if (modelProperty.usesConfig() && !modelHasConfig) {
            problemsReporter.addError(new Problem((NamedObject)model, String.format("The SampleDataProvider [%s] defines that it requires a config, but is used in the %s '%s' which is config less", providerName, modelTypeName, modelName)));
        }
    }

    private void validateGenerics(ConnectableComponentModel model, Class<? extends SampleDataProvider> providerClass, ProblemsReporter problemsReporter) {
        Pair<String, String> outputTypeWithGenerics;
        String outputGenerics;
        String providerGenerics;
        Pair<Type, Type> providerGenericTypes = this.getProviderGenerics(providerClass);
        if (providerGenericTypes.getFirst() == null) {
            problemsReporter.addError(new Problem((NamedObject)model, String.format("SampleDataProvider [%s] does not specify generics definition", providerClass.getName())));
            return;
        }
        if (this.isVoid((Type)providerGenericTypes.getFirst())) {
            problemsReporter.addError(new Problem((NamedObject)model, String.format("SampleDataProvider [%s] cannot have a Void return type", providerClass.getName())));
            return;
        }
        Pair<Type, Type> outputGenericTypes = this.getOutputTypes(model, providerClass.getClassLoader());
        if (!this.validateIfPaged(model, providerClass, outputGenericTypes, providerGenericTypes, problemsReporter) && !Objects.equals(providerGenerics = this.asGenericSignature(IntrospectionUtils.getInterfaceGenerics(providerClass, SampleDataProvider.class)), outputGenerics = this.asGenericSignature((String)(outputTypeWithGenerics = this.getOutputTypesWithGenerics(model, outputGenericTypes)).getFirst(), (String)outputTypeWithGenerics.getSecond()))) {
            problemsReporter.addError(new Problem((NamedObject)model, String.format("SampleDataProvider [%s] is used at component '%s' which outputs a Result%s, but the provider generic signature is '%s'", providerClass.getName(), model.getName(), outputGenerics, providerGenerics)));
        }
    }

    private Pair<String, String> getOutputTypesWithGenerics(ConnectableComponentModel model, Pair<Type, Type> outputGenericTypes) {
        return new Pair((Object)model.getOutput().getType().getAnnotation(ClassInformationAnnotation.class).map(classInformationAnnotation -> classInformationAnnotation.toString()).orElse(this.asString((Type)outputGenericTypes.getFirst())), (Object)model.getOutputAttributes().getType().getAnnotation(ClassInformationAnnotation.class).map(classInformationAnnotation -> classInformationAnnotation.toString()).orElse(this.asString((Type)outputGenericTypes.getSecond())));
    }

    private Pair<Type, Type> getProviderGenerics(Class<? extends SampleDataProvider> providerClass) {
        List<Type> generics = IntrospectionUtils.getInterfaceGenerics(providerClass, SampleDataProvider.class);
        return generics.isEmpty() ? new Pair(null, null) : new Pair((Object)generics.get(0), (Object)generics.get(1));
    }

    private Pair<Type, Type> getOutputTypes(ConnectableComponentModel model, ClassLoader classLoader) {
        return new Pair((Object)JavaTypeUtils.getType((MetadataType)model.getOutput().getType(), (ClassLoader)classLoader), (Object)JavaTypeUtils.getType((MetadataType)model.getOutputAttributes().getType(), (ClassLoader)classLoader));
    }

    private String asGenericSignature(List<Type> types) {
        return this.asGenericSignature(types, true);
    }

    private String asGenericSignature(List<Type> types, boolean getGenerics) {
        return "<" + types.stream().map(type -> this.asString((Type)type, getGenerics)).collect(Collectors.joining(", ")) + ">";
    }

    private String asGenericSignature(String firstType, String secondType) {
        return "<" + firstType + ", " + secondType + ">";
    }

    private boolean validateIfPaged(ConnectableComponentModel component, Class<? extends SampleDataProvider> providerClass, Pair<Type, Type> outputGenericTypes, Pair<Type, Type> sampleDataProviderGenericTypes, ProblemsReporter reporter) {
        String providerAttributesSignature;
        if (!this.isAssignableFrom(PagingProvider.class, (Type)outputGenericTypes.getFirst())) {
            return false;
        }
        Type pageItemsType = (Type)this.getPagingProviderGenerics(component).getSecond();
        Type sampleDataPayloadType = (Type)sampleDataProviderGenericTypes.getFirst();
        if (!this.isAssignableFrom(Collection.class, sampleDataPayloadType)) {
            reporter.addError(new Problem((NamedObject)component, String.format("SampleDataProvider [%s] is used on component '%s' which is paged. The SampleDataProvider is thus expected to provide a payload of type 'Collection<%s>' but it returns a payload of type '%s' instead", providerClass.getName(), component.getName(), this.asString(pageItemsType), this.asString(sampleDataPayloadType))));
            return true;
        }
        List<Type> sampleDataCollectionGeneric = IntrospectionUtils.getInterfaceGenerics(sampleDataPayloadType, Collection.class);
        if (sampleDataCollectionGeneric.isEmpty() || sampleDataCollectionGeneric.get(0) == null) {
            reporter.addError(new Problem((NamedObject)component, String.format("SampleDataProvider [%s] is used on component '%s' which is paged. The SampleDataProvider is thus expected to provide a payload of type 'Collection<%s>', but an unbounded Collection was found instead. Please provide the proper generic", providerClass.getName(), component.getName(), this.asString(pageItemsType))));
            return true;
        }
        Type sampleProviderCollectionType = sampleDataCollectionGeneric.get(0);
        if (!pageItemsType.equals(sampleProviderCollectionType)) {
            reporter.addError(new Problem((NamedObject)component, String.format("SampleDataProvider [%s] is used on component '%s' which is paged. The SampleDataProvider is thus expected to provide a payload of type 'Collection<%s>', but a Collection<%s> was found instead.", providerClass.getName(), component.getName(), this.asString(pageItemsType), this.asString(sampleProviderCollectionType))));
            return true;
        }
        String componentAttributesSignature = this.asString((Type)outputGenericTypes.getSecond());
        if (!componentAttributesSignature.equals(providerAttributesSignature = this.asString((Type)sampleDataProviderGenericTypes.getSecond()))) {
            reporter.addError(new Problem((NamedObject)component, String.format("SampleDataProvider [%s] is used on component '%s' which is paged. The SampleDataProvider is thus expected to provide attributes of type '%s' but it returns attributes of type '%s' instead", providerClass.getName(), component.getName(), componentAttributesSignature, providerAttributesSignature)));
            return true;
        }
        return true;
    }

    private Pair<Type, Type> getPagingProviderGenerics(ConnectableComponentModel model) {
        return model.getModelProperty(ImplementingMethodModelProperty.class).map(mp -> {
            ParameterizedType type = (ParameterizedType)mp.getMethod().getGenericReturnType();
            return new Pair((Object)type.getActualTypeArguments()[0], (Object)type.getActualTypeArguments()[1]);
        }).orElseThrow(() -> new IllegalOperationModelDefinitionException(String.format("Operation '%s' is missing PagingProvider metadata", model.getName())));
    }

    private boolean isVoid(Type componentType) {
        return Void.class.equals((Object)componentType) || Void.TYPE.equals(componentType);
    }

    private boolean isAssignableFrom(Class base, Type target) {
        if (target instanceof Class) {
            return base.isAssignableFrom((Class)target);
        }
        if (target instanceof ParameterizedTypeImpl) {
            return base.isAssignableFrom((Class<?>)((ParameterizedTypeImpl)target).getRawType());
        }
        return false;
    }

    private String asString(Type type) {
        return this.asString(type, true);
    }

    private String asString(Type type, boolean getGenerics) {
        if (type instanceof ParameterizedTypeImpl) {
            ParameterizedTypeImpl parameterizedType = (ParameterizedTypeImpl)type;
            if (getGenerics) {
                return ((Class)parameterizedType.getRawType()).getName() + this.asGenericSignature(Arrays.asList(parameterizedType.getActualTypeArguments()), false);
            }
            return ((Class)parameterizedType.getRawType()).getName();
        }
        if (type == null) {
            return Object.class.getName();
        }
        if (this.isVoid(type)) {
            return Void.TYPE.getName();
        }
        return type.getTypeName();
    }

    private static final class Delegate {
        private Map<String, SampleDataProviderInfo> implInfo = new HashMap<String, SampleDataProviderInfo>();
        private MultiMap<String, String> idToImpl = new MultiMap();
        private ProblemsReporter problemsReporter;

        public Delegate(ProblemsReporter problemsReporter) {
            this.problemsReporter = problemsReporter;
        }

        public void addInfo(SampleDataProviderInfo sampleDataProviderInfo) {
            String valueProviderImplementation = sampleDataProviderInfo.getImplementationClassName();
            if (!this.implInfo.containsKey(valueProviderImplementation)) {
                this.implInfo.put(valueProviderImplementation, sampleDataProviderInfo);
                this.idToImpl.put((Object)sampleDataProviderInfo.getSampleDataProviderModel().getProviderId(), (Object)valueProviderImplementation);
            }
        }

        public void validateIdsAreUnique() {
            this.idToImpl.keySet().forEach(providerId -> {
                List implementationIds = this.idToImpl.getAll(providerId);
                if (implementationIds.size() > 1) {
                    String firstImpl = (String)implementationIds.get(0);
                    SampleDataProviderInfo sampleDataProviderInfo = this.implInfo.get(firstImpl);
                    this.problemsReporter.addError(new Problem((NamedObject)sampleDataProviderInfo.getOwnerModel(), String.format("The following SampleDataProvider implementations [%s] use the same id [%s]. SampleDataProvider ids must be unique.", String.join((CharSequence)", ", implementationIds), providerId)));
                }
            });
        }
    }

    private static class SampleDataProviderInfo {
        private SampleDataProviderModel sampleDataProviderModel;
        private ConnectableComponentModel ownerModel;
        private String implementationClassName;

        public SampleDataProviderInfo(SampleDataProviderModel sampleDataProviderModel, ConnectableComponentModel ownerModel, String implementationClassName) {
            this.sampleDataProviderModel = sampleDataProviderModel;
            this.ownerModel = ownerModel;
            this.implementationClassName = implementationClassName;
        }

        public SampleDataProviderModel getSampleDataProviderModel() {
            return this.sampleDataProviderModel;
        }

        public ConnectableComponentModel getOwnerModel() {
            return this.ownerModel;
        }

        public String getImplementationClassName() {
            return this.implementationClassName;
        }
    }
}

