/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher.semantic;

import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Set;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.visitor.BasicTypeMetadataVisitor;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExecutableComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.FunctionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithSemanticTermsDeclaration;
import org.mule.runtime.connectivity.internal.platform.schema.SemanticTermsHelper;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.api.loader.java.type.WithAnnotations;
import org.mule.runtime.module.extension.internal.loader.enricher.AbstractAnnotatedDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingMethodModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.MethodWrapper;
import org.mule.sdk.api.annotation.semantics.SemanticTerms;

public class SemanticTermsEnricher
extends AbstractAnnotatedDeclarationEnricher {
    private ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();

    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        new IdempotentDeclarationWalker(){

            protected void onConnectionProvider(ConnectionProviderDeclaration declaration) {
                SemanticTermsEnricher.this.extractType((BaseDeclaration<? extends BaseDeclaration>)((BaseDeclaration)declaration)).ifPresent(type -> {
                    SemanticTermsEnricher.this.addSemanticTerms(SemanticTermsHelper.getConnectionTermsFromAnnotations(type::isAnnotatedWith), (WithSemanticTermsDeclaration)declaration);
                    SemanticTermsEnricher.this.addCustomTerms(type, (WithSemanticTermsDeclaration)declaration);
                });
            }

            protected void onOperation(OperationDeclaration declaration) {
                SemanticTermsEnricher.this.extractImplementingMethod((ExecutableComponentDeclaration)declaration).map(method -> new MethodWrapper((Method)method, SemanticTermsEnricher.this.typeLoader)).ifPresent(method -> {
                    SemanticTermsEnricher.this.addSemanticTerms(SemanticTermsHelper.getAllTermsFromAnnotations(method::isAnnotatedWith), (WithSemanticTermsDeclaration)declaration);
                    SemanticTermsEnricher.this.addCustomTerms(method, (WithSemanticTermsDeclaration)declaration);
                });
            }

            protected void onSource(SourceDeclaration declaration) {
                SemanticTermsEnricher.this.extractType((BaseDeclaration<? extends BaseDeclaration>)((BaseDeclaration)declaration)).ifPresent(type -> {
                    SemanticTermsEnricher.this.addSemanticTerms(SemanticTermsHelper.getAllTermsFromAnnotations(type::isAnnotatedWith), (WithSemanticTermsDeclaration)declaration);
                    SemanticTermsEnricher.this.addCustomTerms(type, (WithSemanticTermsDeclaration)declaration);
                });
            }

            protected void onParameter(ParameterGroupDeclaration parameterGroup, ParameterDeclaration parameter) {
                SemanticTermsEnricher.this.extractDeclaredParameter(parameter).ifPresent(param -> {
                    SemanticTermsEnricher.this.addSemanticTerms(SemanticTermsHelper.getParameterTermsFromAnnotations(param::isAnnotatedWith), (WithSemanticTermsDeclaration)parameter);
                    final LinkedHashSet typeTerms = new LinkedHashSet(ExtensionMetadataTypeUtils.getSemanticTerms((MetadataType)parameter.getType()));
                    SemanticTermsEnricher.this.addTermIfPresent(typeTerms, (WithSemanticTermsDeclaration)parameter, "connectivity.ProxyConfiguration", "connectivity.proxyConfiguration");
                    SemanticTermsEnricher.this.addTermIfPresent(typeTerms, (WithSemanticTermsDeclaration)parameter, "connectivity.NtlmProxyConfiguration", "connectivity.ntlmProxyConfiguration");
                    if (typeTerms.contains("connectivity.secret")) {
                        parameter.getType().accept((MetadataTypeVisitor)new BasicTypeMetadataVisitor(){

                            protected void visitBasicType(MetadataType metadataType) {
                                typeTerms.remove("connectivity.secret");
                                typeTerms.add("connectivity.scalarSecret");
                            }
                        });
                    }
                    SemanticTermsEnricher.this.addCustomTerms(param, (WithSemanticTermsDeclaration)parameter);
                });
            }

            protected void onFunction(FunctionDeclaration declaration) {
                declaration.getModelProperty(ImplementingMethodModelProperty.class).map(ImplementingMethodModelProperty::getMethod).ifPresent(method -> SemanticTermsEnricher.this.addCustomTerms(new MethodWrapper((Method)method, SemanticTermsEnricher.this.typeLoader), (WithSemanticTermsDeclaration)declaration));
            }
        }.walk((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration());
    }

    private void addCustomTerms(WithAnnotations annotated, WithSemanticTermsDeclaration declaration) {
        annotated.getAnnotation(SemanticTerms.class).ifPresent(a -> {
            for (String term : a.value()) {
                if (StringUtils.isBlank((String)term)) continue;
                declaration.addSemanticTerm(term.trim());
            }
        });
    }

    private void addTermIfPresent(Set<String> terms, WithSemanticTermsDeclaration declaration, String term, String mappedTerm) {
        if (terms.contains(term)) {
            declaration.addSemanticTerm(mappedTerm);
        }
    }

    private void addSemanticTerms(Set<String> terms, WithSemanticTermsDeclaration declaration) {
        terms.forEach(arg_0 -> ((WithSemanticTermsDeclaration)declaration).addSemanticTerm(arg_0));
    }
}

