/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.meta.model.ImportedTypeModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.internal.loader.util.InfrastructureParameterBuilder;

public final class RedeliveryPolicyDeclarationEnricher
implements DeclarationEnricher {
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.WIRING;
    }

    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        final Reference hasObjectStoreParams = new Reference((Object)false);
        ExtensionDeclaration extension = (ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration();
        new IdempotentDeclarationWalker(){

            protected void onSource(SourceDeclaration declaration) {
                InfrastructureParameterBuilder.addRedeliveryPolicy((ParameterizedDeclaration)declaration);
                hasObjectStoreParams.set((Object)true);
            }
        }.walk(extension);
        if (((Boolean)hasObjectStoreParams.get()).booleanValue() && !this.isObjectStoreAlreadyImported(extension)) {
            ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
            extension.getImportedTypes().add(new ImportedTypeModel((ObjectType)typeLoader.load(ObjectStore.class)));
        }
    }

    private boolean isObjectStoreAlreadyImported(ExtensionDeclaration extension) {
        return extension.getImportedTypes().stream().anyMatch(model -> this.isObjectStore((MetadataType)model.getImportedType()));
    }

    private boolean isObjectStore(MetadataType type) {
        return MetadataTypeUtils.getTypeId((MetadataType)type).filter(typeId -> ObjectStore.class.getName().equals(typeId)).isPresent();
    }
}

