/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.type.runtime;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.ExecutableElement;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.module.extension.api.loader.java.type.AnnotationValueFetcher;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ClassBasedAnnotationValueFetcher;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ParameterWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapper;
import org.springframework.core.ResolvableType;

public class MethodWrapper<T extends Type>
implements MethodElement<T> {
    protected final Method method;
    protected ClassTypeLoader typeLoader;

    public MethodWrapper(Method method, ClassTypeLoader typeLoader) {
        this.method = method;
        this.typeLoader = typeLoader;
    }

    @Override
    public Optional<Method> getMethod() {
        return Optional.of(this.method);
    }

    @Override
    public List<Type> getExceptionTypes() {
        return Stream.of(this.method.getExceptionTypes()).map(type -> new TypeWrapper((Class<?>)type, this.typeLoader)).collect(Collectors.toList());
    }

    @Override
    public T getEnclosingType() {
        return (T)new TypeWrapper(this.getDeclaringClass().get(), this.typeLoader);
    }

    @Override
    public Optional<ExecutableElement> getElement() {
        return Optional.empty();
    }

    @Override
    public Optional<Class<?>> getDeclaringClass() {
        return Optional.ofNullable(this.method.getDeclaringClass());
    }

    @Override
    public List<ExtensionParameter> getParameters() {
        Parameter[] parameters = this.method.getParameters();
        ArrayList<ExtensionParameter> extensionParameters = new ArrayList<ExtensionParameter>(parameters.length);
        for (int i = 0; i < parameters.length; ++i) {
            extensionParameters.add(new ParameterWrapper(this.method, i, this.typeLoader));
        }
        return extensionParameters;
    }

    @Override
    public List<ExtensionParameter> getParameterGroups() {
        return this.getParametersAnnotatedWith(ParameterGroup.class);
    }

    @Override
    public List<ExtensionParameter> getParametersAnnotatedWith(Class<? extends Annotation> annotationClass) {
        LinkedList<ExtensionParameter> extensionParameters = new LinkedList<ExtensionParameter>();
        Parameter[] parameters = this.method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i].getAnnotation(annotationClass) == null) continue;
            extensionParameters.add(new ParameterWrapper(this.method, i, this.typeLoader));
        }
        return extensionParameters;
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    @Override
    public <A extends Annotation> Optional<A> getAnnotation(Class<A> annotationClass) {
        return Optional.ofNullable(this.method.getAnnotation(annotationClass));
    }

    @Override
    public <A extends Annotation> Optional<AnnotationValueFetcher<A>> getValueFromAnnotation(Class<A> annotationClass) {
        return this.isAnnotatedWith(annotationClass) ? Optional.of(new ClassBasedAnnotationValueFetcher<A>(annotationClass, this.method, this.typeLoader)) : Optional.empty();
    }

    @Override
    public Type getReturnType() {
        return new TypeWrapper(ResolvableType.forMethodReturnType((Method)this.method), this.typeLoader);
    }

    public boolean equals(Object obj) {
        return obj instanceof MethodElement && this.method.equals(((MethodElement)obj).getMethod().orElse(null));
    }

    public int hashCode() {
        return this.method.hashCode();
    }
}

