/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.Declarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.FunctionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasFunctionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasParametersDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NamedDeclaration;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalOperationModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.FunctionContainerElement;
import org.mule.runtime.module.extension.api.loader.java.type.FunctionElement;
import org.mule.runtime.module.extension.api.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.api.loader.java.type.WithFunctionContainers;
import org.mule.runtime.module.extension.internal.loader.java.AbstractModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.DefaultJavaModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.property.FunctionExecutorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingMethodModelProperty;
import org.mule.runtime.module.extension.internal.loader.utils.ParameterDeclarationContext;
import org.mule.runtime.module.extension.internal.runtime.function.ReflectiveFunctionExecutorFactory;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

final class FunctionModelLoaderDelegate
extends AbstractModelLoaderDelegate {
    private static final String FUNCTION = "Function";
    private final Map<MethodElement, FunctionDeclarer> functionDeclarers = new HashMap<MethodElement, FunctionDeclarer>();

    FunctionModelLoaderDelegate(DefaultJavaModelLoaderDelegate delegate) {
        super(delegate);
    }

    void declareFunctions(ExtensionDeclarer extensionDeclarer, HasFunctionDeclarer declarer, WithFunctionContainers functionContainers, ExtensionLoadingContext loadingContext) {
        functionContainers.getFunctionContainers().forEach(functionContainer -> this.declareFunctions(extensionDeclarer, declarer, (FunctionContainerElement)functionContainer, loadingContext));
    }

    void declareFunctions(ExtensionDeclarer extensionDeclarer, HasFunctionDeclarer declarer, FunctionContainerElement functionContainerElement, ExtensionLoadingContext loaderContext) {
        this.declareFunctions(extensionDeclarer, declarer, functionContainerElement, functionContainerElement.getFunctions(), loaderContext);
    }

    void declareFunctions(ExtensionDeclarer extensionDeclarer, HasFunctionDeclarer declarer, FunctionContainerElement methodOwnerClass, List<FunctionElement> functions, ExtensionLoadingContext loaderContext) {
        for (FunctionElement function : functions) {
            if (IntrospectionUtils.isIgnored(function, loaderContext)) continue;
            FunctionContainerElement functionOwner = methodOwnerClass != null ? methodOwnerClass : function.getEnclosingType();
            this.checkIsNotAnExtension(functionOwner);
            Optional<ExtensionParameter> configParameter = this.loader.getConfigParameter(function);
            if (configParameter.isPresent()) {
                throw new IllegalModelDefinitionException(String.format("Function '%s' requires a config parameter, but that is not allowed. Remove such parameter.", function.getName()));
            }
            HasFunctionDeclarer actualDeclarer = (HasFunctionDeclarer)this.loader.selectDeclarerBasedOnConfig(extensionDeclarer, (Declarer)declarer, configParameter, Optional.empty());
            if (this.functionDeclarers.containsKey(function)) {
                actualDeclarer.withFunction(this.functionDeclarers.get(function));
                continue;
            }
            FunctionDeclarer functionDeclarer = actualDeclarer.withFunction(function.getAlias());
            function.getMethod().ifPresent(method -> {
                functionDeclarer.withModelProperty((ModelProperty)new ImplementingMethodModelProperty((Method)method));
                function.getDeclaringClass().ifPresent(clazz -> functionDeclarer.withModelProperty((ModelProperty)new FunctionExecutorModelProperty(new ReflectiveFunctionExecutorFactory(clazz, (Method)method))));
            });
            functionDeclarer.withOutput().ofType(function.getReturnMetadataType());
            ParameterDeclarationContext declarationContext = new ParameterDeclarationContext(FUNCTION, (NamedDeclaration)functionDeclarer.getDeclaration());
            this.loader.getMethodParametersLoader().declare((HasParametersDeclarer)functionDeclarer, function.getParameters(), declarationContext);
            this.functionDeclarers.put(function, functionDeclarer);
        }
    }

    private void checkIsNotAnExtension(FunctionContainerElement type) {
        if (type.isAssignableFrom(this.getExtensionElement()) || this.getExtensionElement().isAssignableFrom(type)) {
            throw new IllegalOperationModelDefinitionException(String.format("Function class '%s' cannot be the same class (nor a derivative) of the extension class '%s", type.getName(), this.getExtensionElement().getName()));
        }
    }
}

