/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.property.stackabletypes;

import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.extension.internal.loader.java.property.stackabletypes.StackableType;
import org.mule.runtime.module.extension.internal.loader.java.property.stackabletypes.StackableTypesValueResolverFactory;

public class StackedTypesModelProperty
implements ModelProperty {
    private LazyValue<StackableTypesValueResolverFactory> factory;

    StackedTypesModelProperty(Stack<StackableType> stackableTypes) {
        Preconditions.checkState((!stackableTypes.empty() ? 1 : 0) != 0, (String)"Stack can't be empty");
        this.factory = new LazyValue(() -> new StackableTypesValueResolverFactory(stackableTypes));
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        return "stackableTypes";
    }

    public boolean isPublic() {
        return false;
    }

    public StackableTypesValueResolverFactory getValueResolverFactory() {
        return (StackableTypesValueResolverFactory)this.factory.get();
    }

    public static Optional<StackedTypesModelProperty> getStackedTypesModelProperty(Set<ModelProperty> modelProperties) {
        return modelProperties.stream().filter(mp -> mp instanceof StackedTypesModelProperty).map(mp -> (StackedTypesModelProperty)mp).findFirst();
    }

    public static class Builder {
        private Stack<StackableType> stackableTypes = new Stack();

        public Builder addType(StackableType stackableType) {
            this.stackableTypes.add(stackableType);
            return this;
        }

        public StackedTypesModelProperty build() {
            return new StackedTypesModelProperty(this.stackableTypes);
        }
    }
}

