/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.manager;

import java.util.Set;
import java.util.stream.Stream;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ConnectableComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.error.Errors;
import org.mule.runtime.core.api.exception.ExceptionMapper;
import org.mule.runtime.core.api.retry.policy.RetryPolicyExhaustedException;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.dsl.syntax.resolver.ImportTypesStrategy;
import org.mule.runtime.extension.api.dsl.syntax.resolver.SingleExtensionImportTypesStrategy;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public final class ExtensionErrorsRegistrant {
    public static void registerErrorMappings(ErrorTypeRepository errorTypeRepository, ErrorTypeLocator errorTypeLocator, Set<ExtensionModel> dependencies) {
        dependencies.stream().forEach(extModel -> {
            DslSyntaxResolver syntaxResolver = DslSyntaxResolver.getDefault((ExtensionModel)extModel, (ImportTypesStrategy)new SingleExtensionImportTypesStrategy());
            String nsp = MuleExtensionUtils.getExtensionsNamespace(extModel);
            ExceptionMapper.Builder mapperBuilder = ExceptionMapper.builder();
            errorTypeRepository.lookupErrorType(ComponentIdentifier.builder().namespace(nsp).name("CONNECTIVITY").build()).filter(err -> err.getParentErrorType().getNamespace().equals(Errors.CORE_NAMESPACE_NAME) && err.getParentErrorType().getIdentifier().equals("CONNECTIVITY")).ifPresent(err -> mapperBuilder.addExceptionMapping(ConnectionException.class, err));
            errorTypeRepository.lookupErrorType(ComponentIdentifier.builder().namespace(nsp).name("RETRY_EXHAUSTED").build()).filter(err -> err.getParentErrorType().getNamespace().equals(Errors.CORE_NAMESPACE_NAME) && err.getParentErrorType().getIdentifier().equals("RETRY_EXHAUSTED")).ifPresent(err -> mapperBuilder.addExceptionMapping(RetryPolicyExhaustedException.class, err));
            ExtensionErrorsRegistrant.addComponentExceptionMappers(errorTypeLocator, extModel, syntaxResolver, mapperBuilder.build());
        });
    }

    private static void addComponentExceptionMappers(ErrorTypeLocator errorTypeLocator, ExtensionModel extModel, DslSyntaxResolver syntaxResolver, ExceptionMapper mapping) {
        Stream.concat(extModel.getConfigurationModels().stream().flatMap(config -> Stream.concat(config.getOperationModels().stream(), config.getSourceModels().stream())), Stream.concat(extModel.getOperationModels().stream(), extModel.getSourceModels().stream())).map(model -> ExtensionErrorsRegistrant.identifierFromModel(syntaxResolver, model)).forEach(identifier -> errorTypeLocator.addComponentExceptionMapper(identifier, mapping));
    }

    private static ComponentIdentifier identifierFromModel(DslSyntaxResolver syntaxResolver, ConnectableComponentModel model) {
        DslElementSyntax dsl = syntaxResolver.resolve((NamedObject)model);
        return ComponentIdentifier.builder().name(dsl.getElementName()).namespace(dsl.getPrefix()).build();
    }
}

