/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public final class CollectionValueResolver<T>
implements ValueResolver<Collection<T>>,
Initialisable {
    private final List<ValueResolver<T>> resolvers;
    private final Class<? extends Collection> collectionType;
    @Inject
    private MuleContext muleContext;

    public CollectionValueResolver(Class<? extends Collection> collectionType, List<ValueResolver<T>> resolvers) {
        IntrospectionUtils.checkInstantiable(collectionType, new ReflectionCache());
        Preconditions.checkArgument((resolvers != null ? 1 : 0) != 0, (String)"resolvers cannot be null");
        this.collectionType = collectionType;
        this.resolvers = ImmutableList.copyOf(resolvers);
    }

    public static <T> CollectionValueResolver<T> of(Class<? extends Collection> collectionType, List<ValueResolver<T>> resolvers) {
        if (List.class.equals(collectionType) || Collection.class.equals(collectionType) || Iterable.class.equals(collectionType)) {
            return new CollectionValueResolver<T>(ArrayList.class, resolvers);
        }
        if (Set.class.equals(collectionType)) {
            return new CollectionValueResolver<T>(HashSet.class, resolvers);
        }
        return new CollectionValueResolver<T>(collectionType, resolvers);
    }

    @Override
    public Collection<T> resolve(ValueResolvingContext context) throws MuleException {
        Collection<T> collection = this.instantiateCollection();
        for (ValueResolver<T> resolver : this.resolvers) {
            collection.add(resolver.resolve(context));
        }
        return collection;
    }

    @Override
    public boolean isDynamic() {
        return MuleExtensionUtils.hasAnyDynamic(this.resolvers);
    }

    private Collection<T> instantiateCollection() {
        try {
            return this.collectionType.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create instance of " + this.collectionType.getName(), e);
        }
    }

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.resolvers, (boolean)true, (MuleContext)this.muleContext);
    }
}

