/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.xml.namespace.QName;
import org.mule.runtime.api.component.execution.ExecutionResult;
import org.mule.runtime.api.component.execution.InputEvent;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.core.privileged.registry.LegacyRegistryUtils;
import org.mule.runtime.core.privileged.util.ObjectNameHelper;
import org.mule.runtime.extension.api.runtime.route.Chain;
import org.mule.runtime.module.extension.internal.runtime.operation.ImmutableProcessorChainExecutor;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.reactivestreams.Publisher;

public final class ProcessorChainValueResolver
implements ValueResolver<Chain> {
    private final StreamingManager streamingManager;
    private final MessageProcessorChain chain;

    public ProcessorChainValueResolver(StreamingManager streamingManager, MuleContext ctx, MessageProcessorChain delegate) {
        this.streamingManager = streamingManager;
        this.chain = new LazyInitializerChainDecorator(ctx, delegate);
        try {
            LegacyRegistryUtils.registerObject((MuleContext)ctx, (String)new ObjectNameHelper(ctx).getUniqueName(""), (Object)this.chain);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not register nested MessageProcessorChain"), (Throwable)e);
        }
    }

    public ProcessorChainValueResolver(StreamingManager streamingManager, MuleContext ctx, List<Processor> processors) {
        this(streamingManager, ctx, MessageProcessors.newChain(Optional.empty(), processors));
    }

    @Override
    public Chain resolve(ValueResolvingContext context) throws MuleException {
        return new ImmutableProcessorChainExecutor(this.streamingManager, context.getEvent(), this.chain);
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public boolean isContent() {
        return false;
    }

    private static final class LazyInitializerChainDecorator
    implements MessageProcessorChain {
        private final MessageProcessorChain delegate;
        private final MuleContext muleContext;
        private boolean initialised = false;

        LazyInitializerChainDecorator(MuleContext ctx, MessageProcessorChain chain) {
            this.delegate = chain;
            this.muleContext = ctx;
        }

        public void initialise() throws InitialisationException {
            if (!this.initialised) {
                LifecycleUtils.initialiseIfNeeded((Object)this.delegate, (MuleContext)this.muleContext);
                this.initialised = true;
            }
        }

        public void start() throws MuleException {
            this.initialise();
            this.delegate.start();
        }

        public void stop() throws MuleException {
            this.delegate.stop();
        }

        public void dispose() {
            this.delegate.dispose();
            this.initialised = false;
        }

        public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
            return this.delegate.apply(publisher);
        }

        public List<Processor> getMessageProcessors() {
            return this.delegate.getMessageProcessors();
        }

        public CompletableFuture<ExecutionResult> execute(InputEvent inputEvent) {
            return this.delegate.execute(inputEvent);
        }

        public CompletableFuture<Event> execute(Event event) {
            return this.delegate.execute(event);
        }

        public Object getAnnotation(QName name) {
            return this.delegate.getAnnotation(name);
        }

        public Map<QName, Object> getAnnotations() {
            return this.delegate.getAnnotations();
        }

        public void setAnnotations(Map<QName, Object> annotations) {
            this.delegate.setAnnotations(annotations);
        }

        public ComponentLocation getLocation() {
            return this.delegate.getLocation();
        }

        public Location getRootContainerLocation() {
            return this.delegate.getRootContainerLocation();
        }

        public void setMuleContext(MuleContext context) {
            this.delegate.setMuleContext(context);
        }

        public CoreEvent process(CoreEvent event) throws MuleException {
            return this.delegate.process(event);
        }
    }
}

