/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode;

import java.lang.reflect.Field;
import java.util.Map;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.util.func.Once;
import org.mule.runtime.core.internal.retry.ReconnectionConfig;
import org.mule.runtime.extension.api.connectivity.NoConnectivityTest;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeState;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthGrantType;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.OAuthConnectionProviderWrapper;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode.AuthorizationCodeConfig;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode.AuthorizationCodeOAuthHandler;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode.UpdatingAuthorizationCodeState;
import org.mule.runtime.module.extension.internal.util.FieldSetter;
import org.mule.runtime.oauth.api.AuthorizationCodeOAuthDancer;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;

public class AuthorizationCodeConnectionProviderWrapper<C>
extends OAuthConnectionProviderWrapper<C>
implements NoConnectivityTest {
    private final AuthorizationCodeConfig oauthConfig;
    private final AuthorizationCodeOAuthHandler oauthHandler;
    private final FieldSetter<ConnectionProvider<C>, AuthorizationCodeState> authCodeStateSetter;
    private final Once.RunOnce dance;
    private AuthorizationCodeOAuthDancer dancer;

    public AuthorizationCodeConnectionProviderWrapper(ConnectionProvider<C> delegate, AuthorizationCodeConfig oauthConfig, Map<Field, String> callbackValues, AuthorizationCodeOAuthHandler oauthHandler, ReconnectionConfig reconnectionConfig) {
        super(delegate, reconnectionConfig, callbackValues);
        this.oauthConfig = oauthConfig;
        this.oauthHandler = oauthHandler;
        this.authCodeStateSetter = this.getOAuthStateSetter(delegate, AuthorizationCodeState.class, "Authorization Code");
        this.dance = Once.of(this::updateAuthState);
    }

    public C connect() throws ConnectionException {
        this.dance.runOnce();
        return (C)super.connect();
    }

    private void updateAuthState() {
        ConnectionProvider delegate = this.getDelegate();
        ResourceOwnerOAuthContext context = this.getContext();
        this.authCodeStateSetter.set(delegate, new UpdatingAuthorizationCodeState(this.oauthConfig, this.dancer, context, updatedContext -> this.updateOAuthParameters(delegate, (ResourceOwnerOAuthContext)updatedContext)));
        this.updateOAuthParameters(delegate, context);
    }

    @Override
    public void refreshToken(String resourceOwnerId) {
        this.oauthHandler.refreshToken(this.oauthConfig.getOwnerConfigName(), resourceOwnerId);
    }

    @Override
    public void invalidate(String resourceOwnerId) {
        this.oauthHandler.invalidate(this.oauthConfig.getOwnerConfigName(), resourceOwnerId);
    }

    @Override
    public OAuthGrantType getGrantType() {
        return this.oauthConfig.getGrantType();
    }

    public String getResourceOwnerId() {
        return this.getContext().getResourceOwnerId();
    }

    private ResourceOwnerOAuthContext getContext() {
        return this.oauthHandler.getOAuthContext(this.oauthConfig).orElseThrow(() -> new IllegalArgumentException("OAuth authorization dance not yet performed for resourceOwnerId " + this.oauthConfig.getResourceOwnerId()));
    }

    public void start() throws MuleException {
        this.dancer = this.oauthHandler.register(this.oauthConfig);
        super.start();
    }
}

