/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import java.util.Objects;
import java.util.Optional;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.el.ExpressionManagerSession;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;

public class ValueResolvingContext
implements AutoCloseable {
    private CoreEvent event;
    private final ConfigurationInstance config;
    private final ExpressionManagerSession session;
    private final boolean resolveCursors;

    private ValueResolvingContext(CoreEvent event, ExpressionManagerSession session, ConfigurationInstance config, boolean resolveCursors) {
        this.event = event;
        this.session = session;
        this.config = config;
        this.resolveCursors = resolveCursors;
    }

    public static Builder builder(CoreEvent event) {
        return new Builder().withEvent(event);
    }

    public static Builder builder(CoreEvent event, ExpressionManager expressionManager) {
        return new Builder().withEvent(event).withExpressionManager(expressionManager);
    }

    public CoreEvent getEvent() {
        return this.event;
    }

    public void changeEvent(CoreEvent event) {
        Objects.requireNonNull(event);
        this.event = event;
    }

    public Optional<ConfigurationInstance> getConfig() {
        return Optional.ofNullable(this.config);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ValueResolvingContext)) {
            return false;
        }
        ValueResolvingContext that = (ValueResolvingContext)o;
        return Objects.equals(this.event, that.event) && Objects.equals(this.config, that.config);
    }

    public int hashCode() {
        return Objects.hash(this.event, this.config);
    }

    public boolean resolveCursors() {
        return this.resolveCursors;
    }

    public ExpressionManagerSession getSession() {
        return this.session;
    }

    @Override
    public void close() {
        if (this.session != null) {
            this.session.close();
        }
    }

    public static class Builder {
        private CoreEvent event;
        private Optional<ConfigurationInstance> config = Optional.empty();
        private ExpressionManager manager;
        private boolean resolveCursors = true;

        public Builder withEvent(CoreEvent event) {
            this.event = event;
            return this;
        }

        public Builder withConfig(Optional<ConfigurationInstance> config) {
            this.config = config;
            return this;
        }

        public Builder withConfig(ConfigurationInstance config) {
            this.config = Optional.ofNullable(config);
            return this;
        }

        public Builder withExpressionManager(ExpressionManager manager) {
            this.manager = manager;
            return this;
        }

        public Builder resolveCursors(boolean resolveCursors) {
            this.resolveCursors = resolveCursors;
            return this;
        }

        public ValueResolvingContext build() {
            if (this.event == null) {
                return new ValueResolvingContext(null, null, null, true);
            }
            if (this.manager == null) {
                return new ValueResolvingContext(this.event, null, this.config.orElse(null), this.resolveCursors);
            }
            return new ValueResolvingContext(this.event, this.manager.openSession(this.event.asBindingContext()), this.config.orElse(null), this.resolveCursors);
        }
    }
}

