/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.func.Once;
import org.mule.runtime.core.internal.el.DefaultExpressionManager;
import org.mule.runtime.core.privileged.util.AttributeEvaluator;
import org.mule.runtime.module.extension.internal.runtime.resolver.ExpressionBasedValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;

public class ExpressionValueResolver<T>
implements ExpressionBasedValueResolver<T>,
Initialisable {
    @Inject
    private ExtendedExpressionManager extendedExpressionManager;
    @Inject
    private Registry registry;
    final AttributeEvaluator evaluator;
    private final String expression;
    private final Once.RunOnce evaluatorInitialiser = Once.of(() -> {
        LifecycleUtils.initialiseIfNeeded((Object)this.extendedExpressionManager);
        this.getEvaluator().initialize(this.extendedExpressionManager);
    });
    private Boolean melDefault;
    private Boolean melAvailable;

    ExpressionValueResolver(String expression, DataType expectedDataType) {
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)expression) ? 1 : 0) != 0, (String)"Expression cannot be blank or null");
        this.expression = expression;
        this.evaluator = new AttributeEvaluator(expression, expectedDataType);
    }

    public ExpressionValueResolver(String expression, DataType expectedDataType, Boolean melDefault, Boolean melAvailable) {
        this(expression, expectedDataType);
        this.melDefault = melDefault;
        this.melAvailable = melAvailable;
    }

    public ExpressionValueResolver(String expression) {
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)expression) ? 1 : 0) != 0, (String)"Expression cannot be blank or null");
        this.expression = expression;
        this.evaluator = new AttributeEvaluator(expression);
    }

    void setExtendedExpressionManager(ExtendedExpressionManager extendedExpressionManager) {
        this.extendedExpressionManager = extendedExpressionManager;
    }

    public void initialise() throws InitialisationException {
        this.initEvaluator();
        if (this.melDefault == null) {
            this.melDefault = Boolean.valueOf(System.getProperty("mule.test.mel.default", "false"));
        }
        if (this.melAvailable == null) {
            this.melAvailable = this.registry.lookupByName("_compatibilityPluginInstalled").isPresent();
        }
    }

    @Override
    public T resolve(ValueResolvingContext context) throws MuleException {
        TypedValue typedValue = this.resolveTypedValue(context);
        Object value = typedValue.getValue();
        if (ClassUtils.isInstance(ValueResolver.class, (Object)value)) {
            value = ((ValueResolver)value).resolve(context);
        }
        return (T)value;
    }

    protected <V> TypedValue<V> resolveTypedValue(ValueResolvingContext context) {
        if (context.getSession() == null || this.isMelAvailable() && !DefaultExpressionManager.hasDwExpression((String)this.expression) && !DefaultExpressionManager.hasMelExpression((String)this.expression) && this.melDefault.booleanValue() || DefaultExpressionManager.hasMelExpression((String)this.expression)) {
            return this.evaluator.resolveTypedValue(context.getEvent());
        }
        return this.evaluator.resolveTypedValue(context.getSession());
    }

    void initEvaluator() {
        this.evaluatorInitialiser.runOnce();
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    public boolean isMelAvailable() {
        return this.melAvailable;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    private AttributeEvaluator getEvaluator() {
        return this.evaluator;
    }
}

