/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.streaming.iterator.Consumer;
import org.mule.runtime.core.api.streaming.iterator.ConsumerStreamingIterator;
import org.mule.runtime.core.api.streaming.iterator.ListConsumer;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.connectivity.ExtensionConnectionSupplier;
import org.mule.runtime.module.extension.internal.runtime.operation.DefaultExecutionMediator;
import org.mule.runtime.module.extension.internal.runtime.operation.ExecutionMediator;
import org.mule.runtime.module.extension.internal.runtime.operation.OperationMessageProcessor;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.streaming.PagingProviderProducer;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public class PagedOperationMessageProcessor
extends OperationMessageProcessor {
    private final ExtensionConnectionSupplier connectionSupplier;

    public PagedOperationMessageProcessor(ExtensionModel extensionModel, OperationModel operationModel, ConfigurationProvider configurationProvider, String target, String targetValue, ResolverSet resolverSet, CursorProviderFactory cursorProviderFactory, RetryPolicyTemplate retryPolicyTemplate, ExtensionManager extensionManager, PolicyManager policyManager, ReflectionCache reflectionCache, ExtensionConnectionSupplier connectionSupplier) {
        super(extensionModel, operationModel, configurationProvider, target, targetValue, resolverSet, cursorProviderFactory, retryPolicyTemplate, extensionManager, policyManager, reflectionCache);
        this.connectionSupplier = connectionSupplier;
    }

    private DefaultExecutionMediator.ValueTransformer transformPagingDelegate() {
        return (operationContext, value) -> {
            if (value == null) {
                throw new IllegalStateException("Obtained paging delegate cannot be null");
            }
            ConfigurationInstance config = (ConfigurationInstance)operationContext.getConfiguration().get();
            PagingProviderProducer producer = new PagingProviderProducer((PagingProvider)value, config, (ExecutionContextAdapter)operationContext, this.connectionSupplier);
            ListConsumer consumer = new ListConsumer(producer);
            consumer.loadNextPage();
            return new ConsumerStreamingIterator((Consumer)consumer);
        };
    }

    @Override
    protected ExecutionMediator createExecutionMediator() {
        return new DefaultExecutionMediator<ComponentModel>(this.extensionModel, this.componentModel, this.connectionManager, this.muleContext.getErrorTypeRepository(), this.transformPagingDelegate());
    }
}

