/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.type.TypeCatalog;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.dsl.syntax.DslSyntaxUtils;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.property.InfrastructureParameterModelProperty;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;

public class ParameterDslDeclarationEnricher
implements DeclarationEnricher {
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.POST_STRUCTURE;
    }

    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        new EnricherDelegate().apply(extensionLoadingContext);
    }

    private static class EnricherDelegate {
        private ExtensionDeclaration extensionDeclaration;

        private EnricherDelegate() {
        }

        public void apply(ExtensionLoadingContext extensionLoadingContext) {
            this.extensionDeclaration = (ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration();
            final TypeCatalog typeCatalog = extensionLoadingContext.getDslResolvingContext().getTypeCatalog();
            new IdempotentDeclarationWalker(){

                protected void onParameter(ParameterGroupDeclaration parameterGroup, final ParameterDeclaration declaration) {
                    final ParameterDslConfiguration.Builder builder = ParameterDslConfiguration.builder();
                    final boolean isContent = !declaration.getRole().equals((Object)ParameterRole.BEHAVIOUR);
                    final ParameterDslConfiguration dslConfiguration = declaration.getDslConfiguration();
                    declaration.getType().accept(new MetadataTypeVisitor(){

                        protected void defaultVisit(MetadataType metadataType) {
                            builder.allowsInlineDefinition(dslConfiguration.allowsInlineDefinition() && isContent).allowTopLevelDefinition(false).allowsReferences(false);
                        }

                        public void visitString(StringType stringType) {
                            boolean isText = declaration.getLayoutModel() != null && declaration.getLayoutModel().isText();
                            builder.allowsInlineDefinition(dslConfiguration.allowsInlineDefinition() && (isText || isContent)).allowTopLevelDefinition(false).allowsReferences(false);
                        }

                        public void visitArrayType(ArrayType arrayType) {
                            MetadataType genericType = arrayType.getType();
                            boolean supportsInline = DslSyntaxUtils.supportsInlineDeclaration((MetadataType)arrayType, (ExpressionSupport)declaration.getExpressionSupport(), (ParameterDslConfiguration)dslConfiguration, (boolean)isContent);
                            boolean isWrapped = this.allowsInlineAsWrappedType(genericType, typeCatalog);
                            builder.allowsInlineDefinition(dslConfiguration.allowsInlineDefinition() && (supportsInline || isWrapped)).allowTopLevelDefinition(dslConfiguration.allowTopLevelDefinition()).allowsReferences(dslConfiguration.allowsReferences());
                        }

                        public void visitAnyType(AnyType anyType) {
                            if (ExtensionMetadataTypeUtils.isReferableType((MetadataType)anyType)) {
                                builder.allowsReferences(dslConfiguration.allowsReferences()).allowTopLevelDefinition(false).allowsInlineDefinition(false);
                            } else {
                                this.defaultVisit((MetadataType)anyType);
                            }
                        }

                        public void visitObject(ObjectType objectType) {
                            if (ExtensionMetadataTypeUtils.isMap((MetadataType)objectType)) {
                                builder.allowsInlineDefinition(dslConfiguration.allowsInlineDefinition());
                            } else if (!declaration.getModelProperty(InfrastructureParameterModelProperty.class).isPresent()) {
                                boolean supportsInline = DslSyntaxUtils.supportsInlineDeclaration((MetadataType)objectType, (ExpressionSupport)declaration.getExpressionSupport(), (ParameterDslConfiguration)dslConfiguration, (boolean)isContent);
                                boolean isWrapped = this.allowsInlineAsWrappedType((MetadataType)objectType, typeCatalog);
                                builder.allowsInlineDefinition(dslConfiguration.allowsInlineDefinition() && (supportsInline || isWrapped));
                            }
                            builder.allowTopLevelDefinition(dslConfiguration.allowTopLevelDefinition()).allowsReferences(dslConfiguration.allowsReferences());
                        }

                        public void visitUnion(UnionType unionType) {
                            unionType.getTypes().forEach(type -> type.accept((MetadataTypeVisitor)this));
                        }
                    });
                    declaration.setDslConfiguration(builder.build());
                }
            }.walk(this.extensionDeclaration);
        }

        boolean allowsInlineAsWrappedType(MetadataType type, TypeCatalog typeCatalog) {
            return this.extensionDeclaration.getSubTypes().stream().anyMatch(s -> s.getBaseType().equals(type)) || DslSyntaxUtils.typeRequiresWrapperElement((MetadataType)type, (TypeCatalog)typeCatalog);
        }
    }
}

