/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.util.func.CheckedBiFunction;
import org.mule.runtime.extension.api.runtime.operation.ComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.execution.OperationArgumentResolverFactory;
import org.mule.runtime.module.extension.internal.runtime.execution.ReflectiveMethodComponentExecutor;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class ReflectiveMethodOperationExecutor<M extends ComponentModel>
implements ComponentExecutor<M>,
OperationArgumentResolverFactory<M>,
MuleContextAware,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectiveMethodOperationExecutor.class);
    final ReflectiveMethodComponentExecutor<M> executor;
    private MuleContext muleContext;
    private BiFunction<Object, ExecutionContext<M>, Object> resultTransformer = (o, e) -> o;

    public ReflectiveMethodOperationExecutor(M operationModel, Method operationMethod, Object operationInstance) {
        this.executor = new ReflectiveMethodComponentExecutor(operationModel.getParameterGroupModels(), operationMethod, operationInstance);
    }

    public ReflectiveMethodOperationExecutor(M operationModel, Method operationMethod, Object operationInstance, CheckedBiFunction<Object, ExecutionContext<M>, Object> resultTransformer) {
        this.executor = new ReflectiveMethodComponentExecutor(operationModel.getParameterGroupModels(), operationMethod, operationInstance);
        this.resultTransformer = resultTransformer;
    }

    public Publisher<Object> execute(ExecutionContext<M> executionContext) {
        try {
            Object result = this.executor.execute(executionContext);
            result = this.resultTransformer.apply(result, executionContext);
            return Mono.justOrEmpty((Object)result);
        }
        catch (Exception e) {
            return this.handleError(e, (ExecutionContextAdapter)executionContext);
        }
        catch (Throwable t) {
            return this.handleError(Exceptions.wrapFatal((Throwable)t), (ExecutionContextAdapter)executionContext);
        }
    }

    private Publisher<Object> handleError(Throwable t, ExecutionContextAdapter<M> executionContext) {
        CompletionCallback completionCallback = (CompletionCallback)executionContext.getVariable("MULE_COMPLETION_CALLBACK_CONTEXT_PARAM");
        if (completionCallback != null) {
            if (t instanceof Exception) {
                completionCallback.error(t);
            } else {
                completionCallback.error((Throwable)new MuleRuntimeException(t));
            }
        }
        return Mono.error((Throwable)t);
    }

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.executor, (boolean)true, (MuleContext)this.muleContext);
        LifecycleUtils.initialiseIfNeeded(this.resultTransformer, (boolean)true, (MuleContext)this.muleContext);
    }

    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.executor);
    }

    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.executor);
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.executor, (Logger)LOGGER);
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        this.executor.setMuleContext(this.muleContext);
    }

    @Override
    public Function<ExecutionContext<M>, Map<String, Object>> createArgumentResolver(M operationModel) {
        return this.executor instanceof OperationArgumentResolverFactory ? this.executor.createArgumentResolver(operationModel) : ec -> Collections.emptyMap();
    }
}

