/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import java.util.concurrent.Callable;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.time.TimeSupplier;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.config.ImmutableExpirationPolicy;
import org.mule.runtime.core.internal.time.LocalTimeSupplier;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.module.extension.internal.loader.utils.ImplicitObjectUtils;
import org.mule.runtime.module.extension.internal.runtime.config.ConfigurationInstanceFactory;
import org.mule.runtime.module.extension.internal.runtime.config.ConfigurationProviderToolingAdapter;
import org.mule.runtime.module.extension.internal.runtime.config.DynamicConfigurationProvider;
import org.mule.runtime.module.extension.internal.runtime.config.ImplicitConfigurationProviderFactory;
import org.mule.runtime.module.extension.internal.runtime.resolver.ImplicitConnectionProviderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public final class DefaultImplicitConfigurationProviderFactory
implements ImplicitConfigurationProviderFactory {
    @Override
    public ConfigurationProvider createImplicitConfigurationProvider(ExtensionModel extensionModel, ConfigurationModel implicitConfigurationModel, CoreEvent event, ReflectionCache reflectionCache, MuleContext muleContext) {
        if (implicitConfigurationModel == null || !ExtensionModelUtils.canBeUsedImplicitly((ParameterizedModel)implicitConfigurationModel)) {
            throw new IllegalStateException("Could not find a config for extension '" + extensionModel.getName() + "' and none can be created automatically. Please define one");
        }
        String providerName = MuleExtensionUtils.getImplicitConfigurationProviderName(extensionModel, implicitConfigurationModel);
        Callable<ResolverSet> resolverSetCallable = () -> ImplicitObjectUtils.buildImplicitResolverSet((ParameterizedModel)implicitConfigurationModel, reflectionCache, muleContext);
        ClassLoader pluginClassloader = MuleExtensionUtils.getClassLoader(extensionModel);
        ResolverSet resolverSet = (ResolverSet)ClassUtils.withContextClassLoader((ClassLoader)pluginClassloader, resolverSetCallable);
        try {
            ImplicitConnectionProviderValueResolver implicitConnectionProviderValueResolver = new ImplicitConnectionProviderValueResolver(implicitConfigurationModel.getName(), extensionModel, implicitConfigurationModel, reflectionCache, muleContext);
            ConfigurationInstance configurationInstance = (ConfigurationInstance)ClassUtils.withContextClassLoader((ClassLoader)pluginClassloader, () -> new ConfigurationInstanceFactory(extensionModel, implicitConfigurationModel, resolverSet, reflectionCache, muleContext).createConfiguration(providerName, event, implicitConnectionProviderValueResolver));
            if (resolverSet.isDynamic() || this.needsDynamicConnectionProvider(extensionModel, implicitConfigurationModel, implicitConnectionProviderValueResolver)) {
                return new DynamicConfigurationProvider(providerName, extensionModel, implicitConfigurationModel, resolverSet, implicitConnectionProviderValueResolver, ImmutableExpirationPolicy.getDefault((TimeSupplier)new LocalTimeSupplier()), reflectionCache, muleContext);
            }
            return new ConfigurationProviderToolingAdapter(providerName, extensionModel, implicitConfigurationModel, configurationInstance, reflectionCache, muleContext);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Could not create an implicit configuration '%s' for the extension '%s'", implicitConfigurationModel.getName(), extensionModel.getName())), (Throwable)e);
        }
    }

    private boolean needsDynamicConnectionProvider(ExtensionModel extensionModel, ConfigurationModel configurationModel, ImplicitConnectionProviderValueResolver implicitConnectionProviderValueResolver) {
        return !ExtensionModelUtils.getConnectedComponents((ExtensionModel)extensionModel, (ConfigurationModel)configurationModel).isEmpty() && implicitConnectionProviderValueResolver.isDynamic();
    }
}

