/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.extension.api.annotation.SubTypeMapping;
import org.mule.runtime.extension.api.annotation.SubTypesMapping;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.module.extension.api.loader.java.type.AnnotationValueFetcher;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.enricher.AbstractAnnotatedDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.MuleExtensionAnnotationParser;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionTypeDescriptorModelProperty;

public final class SubTypesDeclarationEnricher
extends AbstractAnnotatedDeclarationEnricher {
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        ExtensionDeclarer declarer = extensionLoadingContext.getExtensionDeclarer();
        ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)declarer.getDeclaration();
        Optional implementingType = extensionDeclaration.getModelProperty(ExtensionTypeDescriptorModelProperty.class);
        if (!implementingType.isPresent()) {
            return;
        }
        Type type = ((ExtensionTypeDescriptorModelProperty)implementingType.get()).getType();
        List<AnnotationValueFetcher<SubTypeMapping>> typeMappings = MuleExtensionAnnotationParser.parseRepeatableAnnotation(type, SubTypeMapping.class, c -> ((SubTypesMapping)c).value());
        if (!typeMappings.isEmpty()) {
            this.declareSubTypesMapping(declarer, typeMappings, extensionDeclaration.getName());
        }
    }

    private void declareSubTypesMapping(ExtensionDeclarer declarer, List<AnnotationValueFetcher<SubTypeMapping>> typeMappings, String name) {
        if (typeMappings.stream().map(valueFetcher -> valueFetcher.getClassValue(SubTypeMapping::baseType)).distinct().collect(Collectors.toList()).size() != typeMappings.size()) {
            throw new IllegalModelDefinitionException(String.format("There should be only one SubtypeMapping for any given base type in extension [%s]. Duplicated base types are not allowed", name));
        }
        typeMappings.forEach(mapping -> declarer.withSubTypes(mapping.getClassValue(SubTypeMapping::baseType).asMetadataType(), (Collection)mapping.getClassArrayValue(SubTypeMapping::subTypes).stream().map(Type::asMetadataType).collect(org.mule.runtime.api.util.collection.Collectors.toImmutableList())));
    }
}

