/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.execution.ExecutionTemplate;
import org.mule.runtime.core.api.execution.TransactionalExecutionTemplate;
import org.mule.runtime.core.api.retry.policy.NoRetryPolicyTemplate;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.core.api.util.func.CheckedBiFunction;
import org.mule.runtime.core.internal.connection.ConnectionManagerAdapter;
import org.mule.runtime.core.internal.connection.ConnectionProviderWrapper;
import org.mule.runtime.extension.api.runtime.Interceptable;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.operation.ComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.Interceptor;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.config.MutableConfigurationStats;
import org.mule.runtime.module.extension.internal.runtime.exception.ExceptionHandlerManager;
import org.mule.runtime.module.extension.internal.runtime.exception.ModuleExceptionHandler;
import org.mule.runtime.module.extension.internal.runtime.operation.ExecutionMediator;
import org.mule.runtime.module.extension.internal.runtime.operation.InterceptorsExecutionResult;
import org.mule.runtime.module.extension.internal.runtime.operation.PrecalculatedExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public final class DefaultExecutionMediator<T extends ComponentModel>
implements ExecutionMediator<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExecutionMediator.class);
    private final ExceptionHandlerManager exceptionEnricherManager;
    private final ConnectionManagerAdapter connectionManager;
    private final ExecutionTemplate<?> defaultExecutionTemplate = callback -> callback.process();
    private final ModuleExceptionHandler moduleExceptionHandler;
    private final List<ValueTransformer> valueTransformers;
    private final RetryPolicyTemplate fallbackRetryPolicyTemplate = new NoRetryPolicyTemplate();

    public DefaultExecutionMediator(ExtensionModel extensionModel, T operationModel, ConnectionManagerAdapter connectionManager, ErrorTypeRepository typeRepository, ValueTransformer ... valueTransformers) {
        this.connectionManager = connectionManager;
        this.exceptionEnricherManager = new ExceptionHandlerManager(extensionModel, (ComponentModel)operationModel);
        this.moduleExceptionHandler = new ModuleExceptionHandler((ComponentModel)operationModel, extensionModel, typeRepository);
        this.valueTransformers = valueTransformers != null ? Arrays.asList(valueTransformers) : Collections.emptyList();
    }

    @Override
    public Publisher<Object> execute(ComponentExecutor<T> executor, ExecutionContextAdapter<T> context) {
        Optional<MutableConfigurationStats> stats = this.getMutableConfigurationStats(context);
        stats.ifPresent(s -> s.addInflightOperation());
        try {
            return (Mono)this.getExecutionTemplate(context).execute(() -> this.executeWithInterceptors(executor, context, this.collectInterceptors(context, executor), stats));
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
        catch (Throwable t) {
            return Mono.error((Throwable)Exceptions.wrapFatal((Throwable)t));
        }
    }

    private Mono<Object> executeWithInterceptors(ComponentExecutor<T> executor, ExecutionContextAdapter<T> context, List<Interceptor> interceptors, Optional<MutableConfigurationStats> stats) {
        ArrayList executedInterceptors = new ArrayList(interceptors.size());
        Mono publisher = Mono.create(sink -> {
            Mono result;
            InterceptorsExecutionResult beforeExecutionResult = this.before(context, interceptors);
            if (beforeExecutionResult.isOk()) {
                result = Mono.from((Publisher)((Publisher)ClassUtils.withContextClassLoader((ClassLoader)MuleExtensionUtils.getClassLoader(context.getExtensionModel()), () -> executor.execute((ExecutionContext)context))));
                executedInterceptors.addAll(interceptors);
            } else {
                result = Mono.error((Throwable)beforeExecutionResult.getThrowable());
                executedInterceptors.addAll(beforeExecutionResult.getExecutedInterceptors());
            }
            result.map(value -> this.transform(context, value)).doOnSuccess(value -> {
                this.onSuccess(context, value, interceptors);
                stats.ifPresent(s -> s.discountInflightOperation());
                sink.success(value);
            }).onErrorMap(t -> this.mapError(context, interceptors, (Throwable)t)).subscribe(v -> {}, arg_0 -> ((MonoSink)sink).error(arg_0));
        }).doOnSuccessOrError((value, e) -> {
            try {
                this.after(context, value, executedInterceptors);
            }
            finally {
                executedInterceptors.clear();
            }
        });
        return Mono.from((Publisher)this.getRetryPolicyTemplate(context).applyPolicy((Publisher)publisher, e -> ExceptionUtils.extractConnectionException((Throwable)e).isPresent(), e -> stats.ifPresent(s -> s.discountInflightOperation()), throwable -> throwable));
    }

    private Throwable mapError(ExecutionContextAdapter context, List<Interceptor> interceptors, Throwable e) {
        e = this.exceptionEnricherManager.process(e);
        e = this.moduleExceptionHandler.processException(e);
        e = this.onError(context, e, interceptors);
        return e;
    }

    private Object transform(ExecutionContextAdapter context, Object value) {
        for (ValueTransformer transformer : this.valueTransformers) {
            value = transformer.apply(context, value);
        }
        return value;
    }

    InterceptorsExecutionResult before(ExecutionContext executionContext, List<Interceptor> interceptors) {
        ArrayList<Interceptor> interceptorList = new ArrayList<Interceptor>();
        try {
            for (Interceptor interceptor : interceptors) {
                interceptorList.add(interceptor);
                interceptor.before(executionContext);
            }
        }
        catch (Exception e) {
            return new InterceptorsExecutionResult(this.exceptionEnricherManager.handleThrowable(e), interceptorList);
        }
        return new InterceptorsExecutionResult(null, interceptorList);
    }

    private void onSuccess(ExecutionContext executionContext, Object result, List<Interceptor> interceptors) {
        this.intercept(interceptors, interceptor -> interceptor.onSuccess(executionContext, result), interceptor -> String.format("Interceptor %s threw exception executing 'onSuccess' phase. Exception will be ignored. Next interceptors (if any) will be executed and the operation's result will be returned", interceptor));
    }

    private Throwable onError(ExecutionContext executionContext, Throwable e, List<Interceptor> interceptors) {
        Reference exceptionHolder = new Reference((Object)e);
        this.intercept(interceptors, interceptor -> {
            Throwable decoratedException = interceptor.onError(executionContext, (Throwable)exceptionHolder.get());
            if (decoratedException != null) {
                exceptionHolder.set((Object)decoratedException);
            }
        }, interceptor -> String.format("Interceptor %s threw exception executing 'onError' phase. Exception will be ignored. Next interceptors (if any) will be executed and the operation's exception will be returned", interceptor));
        return (Throwable)exceptionHolder.get();
    }

    void after(ExecutionContext executionContext, Object result, List<Interceptor> interceptors) {
        this.intercept(interceptors, interceptor -> interceptor.after(executionContext, result), interceptor -> String.format("Interceptor %s threw exception executing 'after' phase. Exception will be ignored. Next interceptors (if any) will be executed and the operation's result be returned", interceptor));
    }

    private void intercept(List<Interceptor> interceptors, Consumer<Interceptor> closure, Function<Interceptor, String> exceptionMessageFunction) {
        interceptors.forEach(interceptor -> {
            block2: {
                try {
                    closure.accept((Interceptor)interceptor);
                }
                catch (Exception e) {
                    if (!LOGGER.isDebugEnabled()) break block2;
                    LOGGER.debug((String)exceptionMessageFunction.apply((Interceptor)interceptor), (Throwable)e);
                }
            }
        });
    }

    private <T> ExecutionTemplate<T> getExecutionTemplate(ExecutionContextAdapter<ComponentModel> context) {
        return context.getTransactionConfig().map(txConfig -> TransactionalExecutionTemplate.createTransactionalExecutionTemplate((MuleContext)context.getMuleContext(), (TransactionConfig)txConfig)).orElse(this.defaultExecutionTemplate);
    }

    private RetryPolicyTemplate getRetryPolicyTemplate(ExecutionContextAdapter<T> context) {
        return context.getRetryPolicyTemplate().orElseGet(() -> context.getConfiguration().flatMap(ConfigurationInstance::getConnectionProvider).map(provider -> {
            if (provider instanceof ConnectionProviderWrapper) {
                return ((ConnectionProviderWrapper)provider).getRetryPolicyTemplate();
            }
            return this.connectionManager.getRetryTemplateFor(provider);
        }).orElse(this.fallbackRetryPolicyTemplate));
    }

    private Optional<MutableConfigurationStats> getMutableConfigurationStats(ExecutionContext<T> context) {
        return context.getConfiguration().map(ConfigurationInstance::getStatistics).filter(s -> s instanceof MutableConfigurationStats).map(s -> (MutableConfigurationStats)s);
    }

    private List<Interceptor> collectInterceptors(ExecutionContextAdapter<T> context, ComponentExecutor<T> executor) {
        return this.collectInterceptors(context.getConfiguration(), context instanceof PrecalculatedExecutionContextAdapter ? ((PrecalculatedExecutionContextAdapter)context).getOperationExecutor() : executor);
    }

    List<Interceptor> collectInterceptors(Optional<ConfigurationInstance> configurationInstance, ComponentExecutor executor) {
        LinkedList<Interceptor> accumulator = new LinkedList<Interceptor>();
        configurationInstance.ifPresent(config -> this.collectInterceptors(accumulator, config));
        this.collectInterceptors(accumulator, (Object)executor);
        return accumulator;
    }

    private void collectInterceptors(List<Interceptor> accumulator, Object subject) {
        if (subject instanceof Interceptable) {
            accumulator.addAll(((Interceptable)subject).getInterceptors());
        }
    }

    @FunctionalInterface
    public static interface ValueTransformer
    extends CheckedBiFunction<ExecutionContextAdapter, Object, Object> {
    }
}

