/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation.resulthandler;

import java.util.Map;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MapDataType;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.internal.runtime.operation.resulthandler.ReturnHandler;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public final class MapReturnHandler
implements ReturnHandler<Map> {
    private final Class<?> mapKeyType;
    private final Class<?> mapValueType;
    private final MapDataType mapDataType;

    public MapReturnHandler(HasOutputModel hasOutputModel) {
        MetadataType type = hasOutputModel.getOutput().getType();
        Preconditions.checkArgument((boolean)ExtensionMetadataTypeUtils.isMap((MetadataType)type), (String)"The given output type is not a Map");
        this.mapDataType = (MapDataType)IntrospectionUtils.toDataType(type);
        this.mapKeyType = this.mapDataType.getKeyDataType().getType();
        this.mapValueType = this.mapDataType.getValueDataType().getType();
    }

    @Override
    public Message.Builder toMessageBuilder(Map value) {
        return Message.builder().mapValue(value, this.mapKeyType, this.mapValueType);
    }

    @Override
    public DataType getDataType() {
        return this.mapDataType;
    }

    @Override
    public boolean handles(Object value) {
        return value instanceof Map;
    }
}

