/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.transaction;

import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.api.util.func.CheckedConsumer;
import org.mule.runtime.core.api.util.func.CheckedRunnable;
import org.mule.runtime.extension.api.tx.TransactionHandle;

public abstract class IdempotentTransactionHandle<T>
implements TransactionHandle {
    private final AtomicBoolean txResolved = new AtomicBoolean(false);
    private final T txResource;
    private final CheckedConsumer<T> commitAction;
    private final CheckedConsumer<T> rollbackAction;

    IdempotentTransactionHandle(T txResource, CheckedConsumer<T> commitAction, CheckedConsumer<T> rollbackAction) {
        this.txResource = txResource;
        this.commitAction = commitAction;
        this.rollbackAction = rollbackAction;
    }

    public boolean isTransacted() {
        return true;
    }

    public void commit() throws TransactionException {
        this.resolveTxAs(() -> {
            try {
                this.commitAction.accept(this.txResource);
            }
            catch (Throwable e) {
                throw new TransactionException(e);
            }
        });
    }

    public void rollback() throws TransactionException {
        this.resolveTxAs(() -> {
            try {
                this.rollbackAction.accept(this.txResource);
            }
            catch (Throwable e) {
                throw new TransactionException(e);
            }
        });
    }

    private void resolveTxAs(CheckedRunnable task) {
        if (this.txResolved.compareAndSet(false, true)) {
            task.run();
            TransactionCoordination.getInstance().clear();
        }
    }
}

