/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution;

import java.lang.reflect.Method;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.runtime.operation.ComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ComponentExecutorFactory;
import org.mule.runtime.module.extension.internal.runtime.operation.ReflectiveMethodOperationExecutor;

public final class ReflectiveOperationExecutorFactory<T, M extends ComponentModel>
implements ComponentExecutorFactory<M> {
    private final Class<T> implementationClass;
    private final Method operationMethod;

    public ReflectiveOperationExecutorFactory(Class<T> implementationClass, Method operationMethod) {
        Preconditions.checkArgument((implementationClass != null ? 1 : 0) != 0, (String)"implementationClass cannot be null");
        Preconditions.checkArgument((operationMethod != null ? 1 : 0) != 0, (String)"operationMethod cannot be null");
        this.implementationClass = implementationClass;
        this.operationMethod = operationMethod;
    }

    public ComponentExecutor<M> createExecutor(M operationModel) {
        T delegate;
        try {
            delegate = this.implementationClass.newInstance();
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not create instance of operation class " + this.implementationClass.getName())), (Throwable)e);
        }
        return new ReflectiveMethodOperationExecutor<M>(operationModel, this.operationMethod, delegate);
    }
}

