/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExecutableComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;
import org.mule.runtime.api.metadata.resolving.NamedTypeResolver;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.metadata.MetadataResolverFactory;
import org.mule.runtime.extension.api.metadata.MetadataResolverUtils;
import org.mule.runtime.extension.api.metadata.NullMetadataResolver;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.extension.internal.property.MetadataKeyIdModelProperty;
import org.mule.runtime.extension.internal.property.MetadataKeyPartModelProperty;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public class MetadataComponentModelValidator
implements ExtensionModelValidator {
    private static final String EMPTY_RESOLVER_NAME = "%s '%s' specifies a metadata resolver [%s] which has an empty %s name";

    public void validate(final ExtensionModel extensionModel, final ProblemsReporter problemsReporter) {
        HashBasedTable names = HashBasedTable.create();
        new ExtensionWalker((Table)names){
            final /* synthetic */ Table val$names;
            {
                this.val$names = table;
            }

            public void onOperation(HasOperationModels owner, OperationModel model) {
                this.validateComponent((ExecutableComponentModel)model);
            }

            public void onSource(HasSourceModels owner, SourceModel model) {
                this.validateComponent((ExecutableComponentModel)model);
            }

            private void validateComponent(ExecutableComponentModel model) {
                MetadataComponentModelValidator.this.validateMetadataReturnType(extensionModel, model, problemsReporter);
                MetadataResolverFactory resolverFactory = MuleExtensionUtils.getMetadataResolverFactory((EnrichableModel)model);
                MetadataComponentModelValidator.this.validateMetadataOutputAttributes(model, resolverFactory, problemsReporter);
                MetadataComponentModelValidator.this.validateMetadataKeyId((ComponentModel)model, resolverFactory, problemsReporter);
                MetadataComponentModelValidator.this.validateCategoriesInScope((ComponentModel)model, resolverFactory, problemsReporter);
                MetadataComponentModelValidator.this.validateResolversName((ComponentModel)model, resolverFactory, this.val$names, problemsReporter);
            }
        }.walk(extensionModel);
    }

    private void validateResolversName(ComponentModel model, MetadataResolverFactory resolverFactory, Table<String, String, Class<?>> names, ProblemsReporter problemsReporter) {
        LinkedList<Object> resolvers = new LinkedList<Object>();
        resolvers.addAll(this.getAllInputResolvers(model, resolverFactory));
        resolvers.add(resolverFactory.getOutputResolver());
        resolvers.stream().filter(r -> !r.getClass().equals(NullMetadataResolver.class)).forEach(r -> {
            if (StringUtils.isBlank((CharSequence)r.getResolverName())) {
                problemsReporter.addError(new Problem((NamedObject)model, String.format(EMPTY_RESOLVER_NAME, NameUtils.getComponentModelTypeName((ParameterizedModel)model), model.getName(), r.getClass().getSimpleName(), "resolver")));
            } else {
                if (names.get((Object)r.getCategoryName(), (Object)r.getResolverName()) != null && names.get((Object)r.getCategoryName(), (Object)r.getResolverName()) != r.getClass()) {
                    problemsReporter.addError(new Problem((NamedObject)model, String.format("%s [%s] specifies metadata resolvers with repeated name [%s] for the same category [%s]. Resolver names should be unique for a given category. Affected resolvers are '%s' and '%s'", NameUtils.getComponentModelTypeName((ParameterizedModel)model), model.getName(), r.getResolverName(), r.getCategoryName(), ((Class)names.get((Object)r.getCategoryName(), (Object)r.getResolverName())).getSimpleName(), r.getClass().getSimpleName())));
                }
                names.put((Object)r.getCategoryName(), (Object)r.getResolverName(), r.getClass());
            }
        });
    }

    private void validateMetadataKeyId(final ComponentModel model, MetadataResolverFactory resolverFactory, final ProblemsReporter problemsReporter) {
        Optional keyId = model.getModelProperty(MetadataKeyIdModelProperty.class);
        if (keyId.isPresent()) {
            if (resolverFactory.getOutputResolver() instanceof NullMetadataResolver && this.getAllInputResolvers(model, resolverFactory).isEmpty()) {
                problemsReporter.addError(new Problem((NamedObject)model, String.format("Component [%s] defines a MetadataKeyId parameter but neither an Output nor Type resolver that makes use of it was defined", model.getName())));
            }
            ((MetadataKeyIdModelProperty)keyId.get()).getType().accept(new MetadataTypeVisitor(){

                public void visitObject(ObjectType objectType) {
                    List parts = model.getAllParameterModels().stream().filter(p -> p.getModelProperty(MetadataKeyPartModelProperty.class).isPresent()).collect(Collectors.toList());
                    List defaultParts = parts.stream().filter(p -> p.getDefaultValue() != null).collect(Collectors.toList());
                    if (!defaultParts.isEmpty() && defaultParts.size() != parts.size()) {
                        String typeName = ExtensionMetadataTypeUtils.getId((MetadataType)objectType).orElse("Anonymous type");
                        problemsReporter.addError(new Problem((NamedObject)model, String.format("[%s] type multilevel key defines [%s] MetadataKeyPart with default values, but the type contains [%s] MetadataKeyParts. All the annotated MetadataKeyParts should have a default value if at least one part has a default value.", typeName, defaultParts.size(), parts.size())));
                    }
                }
            });
        } else if (!(resolverFactory.getKeyResolver() instanceof NullMetadataResolver)) {
            problemsReporter.addError(new Problem((NamedObject)model, String.format("Component [%s] does not define a MetadataKeyId parameter but a type keys resolver of type [%s] was associated to it", model.getName(), resolverFactory.getKeyResolver().getClass().getName())));
        }
    }

    private void validateMetadataOutputAttributes(ExecutableComponentModel component, MetadataResolverFactory resolverFactory, ProblemsReporter problemsReporter) {
        if (MetadataTypeUtils.isVoid((MetadataType)component.getOutputAttributes().getType()) && !(resolverFactory.getOutputAttributesResolver() instanceof NullMetadataResolver) && !MetadataTypeUtils.isCollection((MetadataType)component.getOutput().getType())) {
            problemsReporter.addError(new Problem((NamedObject)component, String.format("%s '%s' has an attributes metadata resolver defined but it doesn't set any attributes", NameUtils.getComponentModelTypeName((ParameterizedModel)component), component.getName())));
        }
    }

    private void validateMetadataReturnType(final ExtensionModel extensionModel, final ExecutableComponentModel component, final ProblemsReporter problemsReporter) {
        if (MuleExtensionUtils.getMetadataResolverFactory((EnrichableModel)component).getOutputResolver() instanceof NullMetadataResolver) {
            component.getOutput().getType().accept(new MetadataTypeVisitor(){

                public void visitObject(ObjectType objectType) {
                    objectType.getOpenRestriction().ifPresent(t -> MetadataComponentModelValidator.this.checkValidType((ComponentModel)component, extensionModel, t, problemsReporter));
                    MetadataComponentModelValidator.this.checkValidType((ComponentModel)component, extensionModel, (MetadataType)objectType, problemsReporter);
                }

                public void visitArrayType(ArrayType arrayType) {
                    arrayType.getType().accept((MetadataTypeVisitor)this);
                }
            });
        }
    }

    private void validateCategoriesInScope(ComponentModel componentModel, MetadataResolverFactory metadataResolverFactory, ProblemsReporter problemsReporter) {
        this.validateCategoryNames(componentModel, problemsReporter, MetadataResolverUtils.getAllResolvers((MetadataResolverFactory)metadataResolverFactory));
    }

    private List<InputTypeResolver<Object>> getAllInputResolvers(ComponentModel componentModel, MetadataResolverFactory resolverFactory) {
        return componentModel.getAllParameterModels().stream().map(NamedObject::getName).map(arg_0 -> ((MetadataResolverFactory)resolverFactory).getInputResolver(arg_0)).collect(Collectors.toList());
    }

    private void validateCategoryNames(ComponentModel componentModel, ProblemsReporter problemsReporter, List<NamedTypeResolver> resolvers) {
        resolvers.stream().filter(r -> org.mule.runtime.core.api.util.StringUtils.isBlank((String)r.getCategoryName())).findFirst().ifPresent(r -> problemsReporter.addError(new Problem((NamedObject)componentModel, String.format(EMPTY_RESOLVER_NAME, NameUtils.getComponentModelTypeName((ParameterizedModel)componentModel), componentModel.getName(), r.getClass().getSimpleName(), "category"))));
        Set names = resolvers.stream().filter(r -> !MetadataResolverUtils.isNullResolver((NamedTypeResolver)r)).map(NamedTypeResolver::getCategoryName).collect(Collectors.toSet());
        if (names.size() > 1) {
            problemsReporter.addError(new Problem((NamedObject)componentModel, String.format("%s '%s' specifies metadata resolvers that doesn't belong to the same category. The following categories were the ones found [%s]", NameUtils.getComponentModelTypeName((ParameterizedModel)componentModel), componentModel.getName(), StringUtils.join(names, (String)","))));
        }
    }

    private void failIfTypeIsObject(ComponentModel componentModel, ExtensionModel extensionModel, MetadataType metadataType, String componentTypeName, Class<?> type, ProblemsReporter problemsReporter) {
        if (Object.class.equals(type)) {
            problemsReporter.addError(new Problem((NamedObject)extensionModel, String.format("Extension '%s' specifies a/an %s named '%s' with type '%s' as return type. Components that return a type such as Object or Map (or a collection of any of those) must have defined an OutputResolver", extensionModel.getName(), componentTypeName, componentModel.getName(), ExtensionMetadataTypeUtils.getId((MetadataType)metadataType))));
        }
    }

    private void failIfTypeIsInterface(ComponentModel componentModel, ExtensionModel extensionModel, MetadataType metadataType, String componentTypeName, Class<?> type, ProblemsReporter problemsReporter) {
        if (this.isInvalidInterface(metadataType, type)) {
            problemsReporter.addError(new Problem((NamedObject)extensionModel, String.format("Extension '%s' specifies a/an %s named '%s' with type '%s' as return type. Components that return an interface (or a collection of interfaces) must have defined an OutputResolver", extensionModel.getName(), componentTypeName, componentModel.getName(), ExtensionMetadataTypeUtils.getId((MetadataType)metadataType))));
        }
    }

    private void checkValidType(ComponentModel componentModel, ExtensionModel extensionModel, MetadataType metadataType, ProblemsReporter problemsReporter) {
        String componentTypeName = NameUtils.getComponentModelTypeName((ParameterizedModel)componentModel);
        ExtensionMetadataTypeUtils.getType((MetadataType)metadataType).ifPresent(type -> {
            this.failIfTypeIsObject(componentModel, extensionModel, metadataType, componentTypeName, (Class<?>)type, problemsReporter);
            this.failIfTypeIsInterface(componentModel, extensionModel, metadataType, componentTypeName, (Class<?>)type, problemsReporter);
        });
    }

    private boolean isInvalidInterface(MetadataType metadataType, Class<?> type) {
        return type.isInterface() && metadataType instanceof ObjectType && !ExtensionMetadataTypeUtils.isMap((MetadataType)metadataType) && !type.equals(Message.class) && ExtensionMetadataTypeUtils.getType((MetadataType)metadataType).map(t -> Serializable.class.equals(t)).orElse(false) == false;
    }
}

