/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.parameter.ElementReference;
import org.mule.runtime.extension.api.annotation.ElementReferences;
import org.mule.runtime.extension.api.annotation.param.reference.ConfigReference;
import org.mule.runtime.extension.api.annotation.param.reference.FlowReference;
import org.mule.runtime.extension.api.annotation.param.reference.ObjectStoreReference;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.module.extension.internal.loader.enricher.AbstractAnnotatedDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.property.DeclaringMemberModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingParameterModelProperty;

public final class ElementReferenceDeclarionEnricher
extends AbstractAnnotatedDeclarationEnricher {
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        new IdempotentDeclarationWalker(){

            protected void onParameter(ParameterGroupDeclaration parameterGroup, ParameterDeclaration declaration) {
                declaration.getModelProperty(ImplementingParameterModelProperty.class).ifPresent(param -> declaration.setElementReferences(ElementReferenceDeclarionEnricher.this.getReferences(param.getParameter())));
                declaration.getModelProperty(DeclaringMemberModelProperty.class).ifPresent(field -> declaration.setElementReferences(ElementReferenceDeclarionEnricher.this.getReferences(field.getDeclaringField())));
            }
        }.walk((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration());
    }

    private List<ElementReference> getReferences(AnnotatedElement element) {
        ElementReferences references = element.getAnnotation(ElementReferences.class);
        if (references != null) {
            return Arrays.stream(references.value()).map(ref -> new ElementReference(ref.namespace(), ref.name(), ElementReference.ElementType.CONFIG)).collect(Collectors.toList());
        }
        ConfigReference ref2 = element.getAnnotation(ConfigReference.class);
        if (ref2 != null) {
            return Collections.singletonList(new ElementReference(ref2.namespace(), ref2.name(), ElementReference.ElementType.CONFIG));
        }
        if (element.getAnnotation(FlowReference.class) != null) {
            return Collections.singletonList(new ElementReference("mule", "flow", ElementReference.ElementType.FLOW));
        }
        if (element.getAnnotation(ObjectStoreReference.class) != null) {
            return Collections.singletonList(new ElementReference("os", "objectStore", ElementReference.ElementType.OBJECT_STORE));
        }
        return Collections.emptyList();
    }
}

