/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import javax.inject.Inject;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.module.extension.internal.runtime.resolver.ExpressionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public class TypeSafeExpressionValueResolver<T>
implements ValueResolver<T>,
Initialisable {
    private final MetadataType expectedMetadataType;
    private final Class<T> expectedType;
    private final String expression;
    private TypeSafeValueResolverWrapper<T> delegate;
    @Inject
    private TransformationService transformationService;
    @Inject
    private ExtendedExpressionManager extendedExpressionManager;

    public TypeSafeExpressionValueResolver(String expression, MetadataType expectedMetadataType) {
        Preconditions.checkArgument((expectedMetadataType != null ? 1 : 0) != 0, (String)"expected type cannot be null");
        this.expression = expression;
        this.expectedType = JavaTypeUtils.getType((MetadataType)expectedMetadataType);
        this.expectedMetadataType = expectedMetadataType;
    }

    @Override
    public T resolve(ValueResolvingContext context) throws MuleException {
        return this.delegate.resolve(context);
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    public void initialise() throws InitialisationException {
        ExpressionValueResolver resolver = new ExpressionValueResolver(this.expression, IntrospectionUtils.toDataType(this.expectedMetadataType));
        resolver.setExtendedExpressionManager(this.extendedExpressionManager);
        this.delegate = new TypeSafeValueResolverWrapper<T>(resolver, this.expectedType);
        this.delegate.setTransformationService(this.transformationService);
        this.delegate.initialise();
    }

    public void setTransformationService(TransformationService transformationService) {
        this.transformationService = transformationService;
    }

    public void setExtendedExpressionManager(ExtendedExpressionManager extendedExpressionManager) {
        this.extendedExpressionManager = extendedExpressionManager;
    }
}

