/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationState;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.module.extension.internal.runtime.config.ConfigurationObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.config.DefaultImplicitConnectionProviderFactory;
import org.mule.runtime.module.extension.internal.runtime.config.ImmutableConfigurationState;
import org.mule.runtime.module.extension.internal.runtime.config.ImplicitConnectionProviderFactory;
import org.mule.runtime.module.extension.internal.runtime.config.LifecycleAwareConfigurationInstance;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionProviderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public final class ConfigurationInstanceFactory<T> {
    private final ConfigurationModel configurationModel;
    private final ConfigurationObjectBuilder<T> configurationObjectBuilder;
    private final ImplicitConnectionProviderFactory implicitConnectionProviderFactory;
    private final boolean requiresConnection;
    private final MuleContext muleContext;

    public ConfigurationInstanceFactory(ExtensionModel extensionModel, ConfigurationModel configurationModel, ResolverSet resolverSet, MuleContext muleContext) {
        this.configurationModel = configurationModel;
        this.muleContext = muleContext;
        this.configurationObjectBuilder = new ConfigurationObjectBuilder(configurationModel, resolverSet);
        this.requiresConnection = !ExtensionModelUtils.getConnectedComponents((ExtensionModel)extensionModel, (ConfigurationModel)configurationModel).isEmpty();
        this.implicitConnectionProviderFactory = new DefaultImplicitConnectionProviderFactory(extensionModel, configurationModel, muleContext);
    }

    public <C> ConfigurationInstance createConfiguration(String name, CoreEvent event, ConnectionProviderValueResolver<C> connectionProviderResolver) throws MuleException {
        Pair<T, ResolverSetResult> configValue = this.createConfigurationInstance(name, event);
        Optional<Object> connectionProvider = this.requiresConnection ? Optional.ofNullable(connectionProviderResolver.resolve(ValueResolvingContext.from(event))) : Optional.empty();
        return new LifecycleAwareConfigurationInstance(name, this.configurationModel, configValue.getFirst(), this.createState((ResolverSetResult)configValue.getSecond(), connectionProvider), MuleExtensionUtils.createInterceptors((EnrichableModel)this.configurationModel), connectionProvider.map(Pair::getFirst));
    }

    public <C> ConfigurationInstance createConfiguration(String name, ResolverSetResult configValues, CoreEvent event, Optional<ConnectionProviderValueResolver<C>> connectionProviderResolver) throws MuleException {
        Pair<T, ResolverSetResult> configValue = this.createConfigurationInstance(name, configValues);
        Optional<Object> connectionProvider = this.requiresConnection && connectionProviderResolver.isPresent() ? Optional.ofNullable(connectionProviderResolver.get().resolve(ValueResolvingContext.from(event))) : Optional.empty();
        return new LifecycleAwareConfigurationInstance(name, this.configurationModel, configValue.getFirst(), this.createState((ResolverSetResult)configValue.getSecond(), connectionProvider), MuleExtensionUtils.createInterceptors((EnrichableModel)this.configurationModel), connectionProvider.map(Pair::getFirst));
    }

    public <C> ConfigurationInstance createConfiguration(String name, ResolverSetResult configValues, CoreEvent event, ConnectionProviderValueResolver<C> connectionProviderResolver, ResolverSetResult connectionProviderValues) throws MuleException {
        Pair<T, ResolverSetResult> configValue = this.createConfigurationInstance(name, configValues);
        Optional<Object> connectionProvider = Optional.empty();
        if (this.requiresConnection && connectionProviderResolver != null) {
            if (connectionProviderResolver.getObjectBuilder().isPresent()) {
                connectionProvider = Optional.ofNullable(connectionProviderResolver.getObjectBuilder().get().build(connectionProviderValues));
            }
            if (!connectionProvider.isPresent()) {
                connectionProvider = Optional.ofNullable(connectionProviderResolver.resolve(ValueResolvingContext.from(event)));
            }
        }
        return new LifecycleAwareConfigurationInstance(name, this.configurationModel, configValue.getFirst(), this.createState((ResolverSetResult)configValue.getSecond(), connectionProvider), MuleExtensionUtils.createInterceptors((EnrichableModel)this.configurationModel), connectionProvider.map(Pair::getFirst));
    }

    private Pair<T, ResolverSetResult> createConfigurationInstance(String name, ResolverSetResult resolverSetResult) throws MuleException {
        Pair<T, ResolverSetResult> config = this.configurationObjectBuilder.build(resolverSetResult);
        IntrospectionUtils.injectFields((EnrichableModel)this.configurationModel, config.getFirst(), name, this.muleContext.getConfiguration().getDefaultEncoding());
        return config;
    }

    private Pair<T, ResolverSetResult> createConfigurationInstance(String name, CoreEvent event) throws MuleException {
        Pair config = (Pair)this.configurationObjectBuilder.build(ValueResolvingContext.from(event));
        IntrospectionUtils.injectFields((EnrichableModel)this.configurationModel, config.getFirst(), name, this.muleContext.getConfiguration().getDefaultEncoding());
        return config;
    }

    private <C> ConfigurationState createState(ResolverSetResult configValues, Optional<Pair<ConnectionProvider<C>, ResolverSetResult>> connectionProvider) {
        return new ImmutableConfigurationState(this.nullSafeMap(configValues), connectionProvider.map(p -> this.nullSafeMap((ResolverSetResult)p.getSecond())).orElseGet(Collections::emptyMap));
    }

    private Map<String, Object> nullSafeMap(ResolverSetResult result) {
        return result.asMap().entrySet().stream().filter(entry -> entry.getValue() != null).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> entry.getValue()));
    }
}

