/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime;

import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.module.extension.api.runtime.privileged.EventedExecutionContext;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;

public class LazyExecutionContext<M extends ComponentModel>
implements EventedExecutionContext<M> {
    private final Map<String, ValueResolver<?>> valueResolvers;
    private final M componentModel;
    private final ExtensionModel extensionModel;
    private final ValueResolvingContext resolvingContext;

    public LazyExecutionContext(ResolverSet resolverSet, M componentModel, ExtensionModel extensionModel, ValueResolvingContext resolvingContext) {
        this.valueResolvers = resolverSet.getResolvers();
        this.componentModel = componentModel;
        this.extensionModel = extensionModel;
        this.resolvingContext = resolvingContext;
    }

    public boolean hasParameter(String parameterName) {
        return this.valueResolvers.containsKey(parameterName);
    }

    public <T> T getParameter(String parameterName) {
        if (this.hasParameter(parameterName)) {
            try {
                return (T)this.valueResolvers.get(parameterName).resolve(this.resolvingContext);
            }
            catch (MuleException e) {
                throw new RuntimeException(e);
            }
        }
        throw new NoSuchElementException();
    }

    public Optional<ConfigurationInstance> getConfiguration() {
        return this.resolvingContext.getConfig();
    }

    @Override
    public CoreEvent getEvent() {
        return this.resolvingContext.getEvent();
    }

    @Override
    public void changeEvent(CoreEvent updated) {
        this.resolvingContext.changeEvent(updated);
    }

    public M getComponentModel() {
        return this.componentModel;
    }

    public ExtensionModel getExtensionModel() {
        return this.extensionModel;
    }
}

