/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceCallbackModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.extension.api.declaration.type.TypeUtils;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public final class InputParametersTypeModelValidator
implements ExtensionModelValidator {
    public void validate(ExtensionModel extensionModel, final ProblemsReporter problems) {
        final HashSet validatedTypes = new HashSet();
        new IdempotentExtensionWalker(){

            public void onOperation(OperationModel model) {
                model.getAllParameterModels().forEach(parameterModel -> InputParametersTypeModelValidator.this.validateJavaType((ComponentModel)model, parameterModel.getType(), problems, validatedTypes));
            }

            public void onSource(SourceModel model) {
                this.validateCallback(model, model.getSuccessCallback());
                this.validateCallback(model, model.getErrorCallback());
                this.validateCallback(model, model.getTerminateCallback());
            }

            private void validateCallback(SourceModel model, Optional<SourceCallbackModel> callback) {
                callback.ifPresent(cb -> cb.getAllParameterModels().forEach(parameterModel -> InputParametersTypeModelValidator.this.validateJavaType((ComponentModel)model, parameterModel.getType(), problems, validatedTypes)));
            }
        }.walk(extensionModel);
        extensionModel.getSubTypes().forEach(subTypesModel -> this.getClassForValidation((MetadataType)subTypesModel.getBaseType()).filter(validatedTypes::contains).ifPresent(type -> subTypesModel.getSubTypes().forEach(subtype -> this.validateSubtypesHaveGetters(extensionModel, (MetadataType)subtype, problems, validatedTypes))));
    }

    private void validateJavaType(ComponentModel model, MetadataType type, ProblemsReporter problems, Set<Class<?>> validatedTypes) {
        if (type.getMetadataFormat().equals((Object)MetadataFormat.JAVA)) {
            this.validateParameterFieldsHaveGetters(model, type, problems, validatedTypes);
        }
    }

    private void validateSubtypesHaveGetters(ExtensionModel extensionModel, MetadataType subtype, ProblemsReporter problems, Set<Class<?>> validatedTypes) {
        this.validateType(String.format("Extension '%s' defines a subtype", extensionModel.getName()), (NamedObject)extensionModel, subtype, problems, validatedTypes);
    }

    private void validateParameterFieldsHaveGetters(ComponentModel model, MetadataType parameterMetadataType, ProblemsReporter problems, Set<Class<?>> validatedTypes) {
        this.validateType(String.format("%s '%s' has an argument", NameUtils.getComponentModelTypeName((ParameterizedModel)model), model.getName()), (NamedObject)model, parameterMetadataType, problems, validatedTypes);
    }

    private void validateType(String message, NamedObject namedObject, MetadataType type, ProblemsReporter problems, final Set<Class<?>> validatedTypes) {
        this.getClassForValidation(type).ifPresent(parameterType -> type.accept(new MetadataTypeVisitor((Class)parameterType, problems, namedObject, message){
            final /* synthetic */ Class val$parameterType;
            final /* synthetic */ ProblemsReporter val$problems;
            final /* synthetic */ NamedObject val$namedObject;
            final /* synthetic */ String val$message;
            {
                this.val$parameterType = clazz;
                this.val$problems = problemsReporter;
                this.val$namedObject = namedObject;
                this.val$message = string;
            }

            public void visitObject(ObjectType objectType) {
                if (validatedTypes.add(this.val$parameterType)) {
                    Collection parameters = objectType.getFields();
                    Set fieldsWithGetters = IntrospectionUtils.getFieldsWithGetters(this.val$parameterType).stream().map(TypeUtils::getAlias).map(String::toLowerCase).collect(Collectors.toSet());
                    Set parameterWithoutGetters = parameters.stream().map(f -> f.getKey().getName().getLocalPart()).filter(fieldName -> !fieldsWithGetters.contains(fieldName.toLowerCase())).collect(Collectors.toSet());
                    if (!parameterWithoutGetters.isEmpty()) {
                        this.val$problems.addError(new Problem(this.val$namedObject, String.format("%s of type '%s' which contains fields (%s) that doesn't have the corresponding getter methods or getter methods that doesn't correspond to any of the present fields", this.val$message, this.val$parameterType.getName(), parameterWithoutGetters.stream().collect(Collectors.joining(", ")))));
                    }
                }
            }

            public void visitArrayType(ArrayType arrayType) {
                InputParametersTypeModelValidator.this.validateType(this.val$message, this.val$namedObject, arrayType.getType(), this.val$problems, validatedTypes);
            }
        }));
    }

    private Optional<Class<Object>> getClassForValidation(MetadataType type) {
        if (!type.getMetadataFormat().equals((Object)MetadataFormat.JAVA)) {
            return Optional.empty();
        }
        return ExtensionMetadataTypeUtils.getType((MetadataType)type);
    }
}

