/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.connection.HasConnectionProviderModels;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.annotation.param.DefaultEncoding;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.property.ClassLoaderModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingMethodModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.MethodWrapper;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public final class InjectedFieldsModelValidator
implements ExtensionModelValidator {
    public void validate(ExtensionModel extensionModel, ProblemsReporter problemsReporter) {
        HashSet validatedTypes = new HashSet();
        extensionModel.getModelProperty(ClassLoaderModelProperty.class).ifPresent(classLoaderModelProperty -> new ExtensionWalker((ClassLoaderModelProperty)classLoaderModelProperty, validatedTypes, problemsReporter){
            final /* synthetic */ ClassLoaderModelProperty val$classLoaderModelProperty;
            final /* synthetic */ Set val$validatedTypes;
            final /* synthetic */ ProblemsReporter val$problemsReporter;
            {
                this.val$classLoaderModelProperty = classLoaderModelProperty;
                this.val$validatedTypes = set;
                this.val$problemsReporter = problemsReporter;
            }

            protected void onSource(HasSourceModels owner, SourceModel model) {
                this.validateFields((NamedObject)model, model.getModelProperty(ImplementingTypeModelProperty.class), DefaultEncoding.class);
            }

            protected void onConfiguration(ConfigurationModel model) {
                this.validateFields((NamedObject)model, model.getModelProperty(ImplementingTypeModelProperty.class), DefaultEncoding.class);
                this.validateFields((NamedObject)model, model.getModelProperty(ImplementingTypeModelProperty.class), RefName.class);
            }

            protected void onOperation(HasOperationModels owner, OperationModel model) {
                this.validateArguments((NamedObject)model, model.getModelProperty(ImplementingMethodModelProperty.class), DefaultEncoding.class);
            }

            protected void onConnectionProvider(HasConnectionProviderModels owner, ConnectionProviderModel model) {
                this.validateFields((NamedObject)model, model.getModelProperty(ImplementingTypeModelProperty.class), DefaultEncoding.class);
                this.validateFields((NamedObject)model, model.getModelProperty(ImplementingTypeModelProperty.class), RefName.class);
            }

            protected void onParameter(ParameterizedModel owner, ParameterGroupModel groupModel, final ParameterModel model) {
                if (model.getType().getMetadataFormat().equals((Object)MetadataFormat.JAVA)) {
                    model.getType().accept(new MetadataTypeVisitor(){

                        public void visitObject(ObjectType objectType) {
                            JavaTypeUtils.getId((MetadataType)objectType).ifPresent(typeId -> {
                                try {
                                    Class type = ClassUtils.loadClass((String)typeId, (ClassLoader)val$classLoaderModelProperty.getClassLoader());
                                    if (val$validatedTypes.add(type)) {
                                        this.validateType((NamedObject)model, type, DefaultEncoding.class);
                                    }
                                }
                                catch (ClassNotFoundException e) {
                                    val$problemsReporter.addWarning(new Problem((NamedObject)model, String.format("Class '%s' couldn't be validated because it wasn't found", typeId)));
                                }
                            });
                        }
                    });
                }
            }

            private void validateArguments(NamedObject model, Optional<ImplementingMethodModelProperty> modelProperty, Class<? extends Annotation> annotationClass) {
                modelProperty.ifPresent(implementingMethodModelProperty -> {
                    ExtensionParameter argument;
                    MethodWrapper methodWrapper = new MethodWrapper(implementingMethodModelProperty.getMethod());
                    int size = methodWrapper.getParametersAnnotatedWith(annotationClass).size();
                    if (size == 0) {
                        return;
                    }
                    if (size > 1) {
                        this.val$problemsReporter.addError(new Problem(model, String.format("Operation method '%s' has %d arguments annotated with @%s. Only one argument may carry that annotation", methodWrapper.getName(), size, annotationClass.getSimpleName())));
                    }
                    if (!String.class.equals((Object)(argument = methodWrapper.getParametersAnnotatedWith(annotationClass).get(0)).getJavaType())) {
                        this.val$problemsReporter.addError(new Problem(model, String.format("Operation method '%s' declares an argument '%s' which is annotated with @%s and is of type '%s'. Only arguments of type String are allowed to carry such annotation", methodWrapper.getName(), argument.getName(), annotationClass.getSimpleName(), argument.getType().getName())));
                    }
                });
            }

            private void validateFields(NamedObject model, Optional<ImplementingTypeModelProperty> modelProperty, Class<? extends Annotation> annotationClass) {
                modelProperty.ifPresent(implementingTypeModelProperty -> this.validateType(model, implementingTypeModelProperty.getType(), annotationClass));
            }

            private void validateType(NamedObject model, Class<?> type, Class<? extends Annotation> annotationClass) {
                Field field;
                List<Field> fields = IntrospectionUtils.getAnnotatedFields(type, annotationClass);
                if (fields.isEmpty()) {
                    return;
                }
                if (fields.size() > 1) {
                    this.val$problemsReporter.addError(new Problem(model, String.format("Class '%s' has %d fields annotated with @%s. Only one field may carry that annotation", type.getName(), fields.size(), annotationClass.getSimpleName())));
                }
                if (!String.class.equals((field = fields.get(0)).getType())) {
                    this.val$problemsReporter.addError(new Problem(model, String.format("Class '%s' declares the field '%s' which is annotated with @%s and is of type '%s'. Only fields of type String are allowed to carry such annotation", type.getName(), field.getName(), annotationClass.getSimpleName(), field.getType().getName())));
                }
            }
        }.walk(extensionModel));
    }
}

