/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.meta.model.ExternalLibraryModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.Declarer;
import org.mule.runtime.api.meta.model.declaration.fluent.DeclaresExternalLibraries;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasConnectionProviderDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasFunctionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasModelProperties;
import org.mule.runtime.api.meta.model.declaration.fluent.HasOperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasSourceDeclarer;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.annotation.ExternalLib;
import org.mule.runtime.extension.api.annotation.ExternalLibs;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.license.RequiresEnterpriseLicense;
import org.mule.runtime.extension.api.annotation.license.RequiresEntitlement;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.module.extension.api.loader.ModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.ConfigModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.ConnectionProviderModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.FunctionModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.MuleExtensionAnnotationParser;
import org.mule.runtime.module.extension.internal.loader.java.OperationModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.ParameterModelsLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.SourceModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.contributor.InfrastructureFieldContributor;
import org.mule.runtime.module.extension.internal.loader.java.contributor.ParameterDeclarerContributor;
import org.mule.runtime.module.extension.internal.loader.java.contributor.StackableTypesParameterContributor;
import org.mule.runtime.module.extension.internal.loader.java.property.ExceptionHandlerModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.LicenseModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.internal.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.internal.loader.java.type.ExtensionTypeFactory;
import org.mule.runtime.module.extension.internal.loader.java.type.SourceElement;
import org.mule.runtime.module.extension.internal.loader.java.type.WithAnnotations;
import org.mule.runtime.module.extension.internal.loader.java.type.WithParameters;

public class DefaultJavaModelLoaderDelegate
implements ModelLoaderDelegate {
    protected final Class<?> extensionType;
    protected final ClassTypeLoader typeLoader;
    protected final String version;
    private final ConfigModelLoaderDelegate configLoaderDelegate = new ConfigModelLoaderDelegate(this);
    private final OperationModelLoaderDelegate operationLoaderDelegate = new OperationModelLoaderDelegate(this);
    private final FunctionModelLoaderDelegate functionModelLoaderDelegate = new FunctionModelLoaderDelegate(this);
    private final SourceModelLoaderDelegate sourceModelLoaderDelegate = new SourceModelLoaderDelegate(this);
    private final ConnectionProviderModelLoaderDelegate connectionProviderModelLoaderDelegate = new ConnectionProviderModelLoaderDelegate(this);
    private final ParameterModelsLoaderDelegate fieldParametersLoader;
    private final ParameterModelsLoaderDelegate methodParametersLoader;

    public DefaultJavaModelLoaderDelegate(Class<?> extensionType, String version) {
        Preconditions.checkArgument((extensionType != null ? 1 : 0) != 0, (String)String.format("describer %s does not specify an extension type", this.getClass().getName()));
        this.extensionType = extensionType;
        this.version = version;
        this.typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(extensionType.getClassLoader());
        this.fieldParametersLoader = new ParameterModelsLoaderDelegate((List<ParameterDeclarerContributor>)this.getParameterFieldsContributors(), this.typeLoader);
        this.methodParametersLoader = new ParameterModelsLoaderDelegate(this.getParameterMethodsContributors(), this.typeLoader);
    }

    private List<ParameterDeclarerContributor> getParameterMethodsContributors() {
        return ImmutableList.of((Object)StackableTypesParameterContributor.defaultContributor(this.typeLoader));
    }

    private ImmutableList<ParameterDeclarerContributor> getParameterFieldsContributors() {
        return ImmutableList.of((Object)new InfrastructureFieldContributor(), (Object)StackableTypesParameterContributor.defaultContributor(this.typeLoader));
    }

    @Override
    public ExtensionDeclarer declare(ExtensionLoadingContext context) {
        ExtensionElement extensionElement = ExtensionTypeFactory.getExtensionType(this.extensionType);
        Extension extension = MuleExtensionAnnotationParser.getExtension(this.extensionType);
        ExtensionDeclarer declarer = context.getExtensionDeclarer().named(extension.name()).onVersion(this.version).fromVendor(extension.vendor()).withCategory(extension.category()).withModelProperty((ModelProperty)new ImplementingTypeModelProperty(this.extensionType));
        this.processLicenseRequirements(declarer);
        this.parseExternalLibs(extensionElement, (DeclaresExternalLibraries)declarer);
        this.addExceptionEnricher(extensionElement, (HasModelProperties)declarer);
        this.configLoaderDelegate.declareConfigurations(declarer, extensionElement);
        this.connectionProviderModelLoaderDelegate.declareConnectionProviders((HasConnectionProviderDeclarer)declarer, extensionElement);
        if (!CollectionUtils.isEmpty(extensionElement.getConfigurations())) {
            this.operationLoaderDelegate.declareOperations(declarer, (HasOperationDeclarer)declarer, null, extensionElement.getOperations(), false);
            this.functionModelLoaderDelegate.declareFunctions(declarer, (HasFunctionDeclarer)declarer, null, extensionElement.getFunctions());
            extensionElement.getSources().forEach(source -> this.sourceModelLoaderDelegate.declareMessageSource(declarer, (HasSourceDeclarer)declarer, (SourceElement)source, false));
        }
        return declarer;
    }

    private void processLicenseRequirements(ExtensionDeclarer declarer) {
        Optional<RequiresEntitlement> requiresEntitlementOptional = MuleExtensionAnnotationParser.getOptionalAnnotation(this.extensionType, RequiresEntitlement.class);
        Optional<RequiresEnterpriseLicense> requiresEnterpriseLicenseOptional = MuleExtensionAnnotationParser.getOptionalAnnotation(this.extensionType, RequiresEnterpriseLicense.class);
        boolean requiresEnterpriseLicense = requiresEnterpriseLicenseOptional.map(requiresEnterpriseLicenseAnnotation -> true).orElse(false);
        boolean allowsEvaluationLicense = requiresEnterpriseLicenseOptional.map(RequiresEnterpriseLicense::allowEvaluationLicense).orElse(true);
        Optional<Object> requiredEntitlement = Optional.ofNullable(requiresEntitlementOptional.map(RequiresEntitlement::name).orElse(null));
        declarer.withModelProperty((ModelProperty)new LicenseModelProperty(requiresEnterpriseLicense, allowsEvaluationLicense, requiredEntitlement));
    }

    void parseExternalLibs(WithAnnotations withAnnotations, DeclaresExternalLibraries declarer) {
        Optional<ExternalLibs> externalLibs = withAnnotations.getAnnotation(ExternalLibs.class);
        if (externalLibs.isPresent()) {
            Arrays.stream(externalLibs.get().value()).forEach(lib -> this.parseExternalLib(declarer, (ExternalLib)lib));
        } else {
            withAnnotations.getAnnotation(ExternalLib.class).ifPresent(lib -> this.parseExternalLib(declarer, (ExternalLib)lib));
        }
    }

    private void parseExternalLib(DeclaresExternalLibraries declarer, ExternalLib externalLibAnnotation) {
        ExternalLibraryModel.ExternalLibraryModelBuilder builder = ExternalLibraryModel.builder().withName(externalLibAnnotation.name()).withDescription(externalLibAnnotation.description()).withType(externalLibAnnotation.type()).isOptional(externalLibAnnotation.optional());
        StringUtils.ifNotBlank((String)externalLibAnnotation.nameRegexpMatcher(), arg_0 -> ((ExternalLibraryModel.ExternalLibraryModelBuilder)builder).withRegexpMatcher(arg_0));
        StringUtils.ifNotBlank((String)externalLibAnnotation.requiredClassName(), arg_0 -> ((ExternalLibraryModel.ExternalLibraryModelBuilder)builder).withRequiredClassName(arg_0));
        StringUtils.ifNotBlank((String)externalLibAnnotation.coordinates(), arg_0 -> ((ExternalLibraryModel.ExternalLibraryModelBuilder)builder).withCoordinates(arg_0));
        declarer.withExternalLibrary(builder.build());
    }

    <M extends WithAnnotations> HasModelProperties addExceptionEnricher(M model, HasModelProperties declarer) {
        MuleExtensionAnnotationParser.getExceptionEnricherFactory(model).map(ExceptionHandlerModelProperty::new).ifPresent(arg_0 -> ((HasModelProperties)declarer).withModelProperty(arg_0));
        return declarer;
    }

    Class<?>[] getOperationClasses(Class<?> extensionType) {
        Operations operations = extensionType.getAnnotation(Operations.class);
        return operations == null ? ArrayUtils.EMPTY_CLASS_ARRAY : operations.value();
    }

    boolean isInvalidConfigSupport(boolean supportsConfig, Optional<ExtensionParameter> ... parameters) {
        return !supportsConfig && Stream.of(parameters).anyMatch(Optional::isPresent);
    }

    Declarer selectDeclarerBasedOnConfig(ExtensionDeclarer extensionDeclarer, Declarer declarer, Optional<ExtensionParameter> ... parameters) {
        for (Optional<ExtensionParameter> parameter : parameters) {
            if (!parameter.isPresent()) continue;
            return declarer;
        }
        return extensionDeclarer;
    }

    Optional<ExtensionParameter> getConfigParameter(WithParameters element) {
        return element.getParametersAnnotatedWith(Config.class).stream().findFirst();
    }

    Optional<ExtensionParameter> getConnectionParameter(WithParameters element) {
        return element.getParametersAnnotatedWith(Connection.class).stream().findFirst();
    }

    ConfigModelLoaderDelegate getConfigLoaderDelegate() {
        return this.configLoaderDelegate;
    }

    OperationModelLoaderDelegate getOperationLoaderDelegate() {
        return this.operationLoaderDelegate;
    }

    FunctionModelLoaderDelegate getFunctionModelLoaderDelegate() {
        return this.functionModelLoaderDelegate;
    }

    SourceModelLoaderDelegate getSourceModelLoaderDelegate() {
        return this.sourceModelLoaderDelegate;
    }

    ConnectionProviderModelLoaderDelegate getConnectionProviderModelLoaderDelegate() {
        return this.connectionProviderModelLoaderDelegate;
    }

    ClassTypeLoader getTypeLoader() {
        return this.typeLoader;
    }

    Class<?> getExtensionType() {
        return this.extensionType;
    }

    protected ParameterModelsLoaderDelegate getFieldParametersLoader() {
        return this.fieldParametersLoader;
    }

    protected ParameterModelsLoaderDelegate getMethodParametersLoader() {
        return this.methodParametersLoader;
    }
}

