/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.IntersectionType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.meta.model.declaration.fluent.ComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConstructDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NamedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.NestableElementDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.NestedChainDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.NestedRouteDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithAllowedStereotypesDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithConstructsDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithOperationsDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithSourcesDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithStereotypesDeclaration;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModelBuilder;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.param.stereotype.AllowedStereotypes;
import org.mule.runtime.extension.api.annotation.param.stereotype.Stereotype;
import org.mule.runtime.extension.api.annotation.param.stereotype.Validator;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.declaration.type.annotation.StereotypeTypeAnnotation;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;
import org.mule.runtime.extension.api.stereotype.StereotypeDefinition;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingMethodModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.internal.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.internal.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.java.type.WithAnnotations;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.MethodWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapper;
import org.mule.runtime.module.extension.internal.loader.utils.ModelLoaderUtils;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public class StereotypesDeclarationEnricher
implements DeclarationEnricher {
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        ClassUtils.withContextClassLoader((ClassLoader)extensionLoadingContext.getExtensionClassLoader(), () -> new EnricherDelegate().apply(extensionLoadingContext));
    }

    private static class ClassStereotypeResolver
    extends StereotypeResolver<Type> {
        public ClassStereotypeResolver(Type annotatedElement, WithStereotypesDeclaration declaration, String namespace, StereotypeModel fallbackStereotype, Map<StereotypeDefinition, StereotypeModel> stereotypesCache) {
            super(annotatedElement, declaration, namespace, fallbackStereotype, stereotypesCache);
        }

        @Override
        protected <T extends Annotation> T getAnnotation(Class<T> annotationType) {
            return (T)((Type)this.annotatedElement).getAnnotation(annotationType).orElseGet(() -> {
                Class declaringClass = ((Type)this.annotatedElement).getDeclaringClass();
                if (declaringClass != null) {
                    return IntrospectionUtils.getAnnotation(declaringClass, annotationType);
                }
                return null;
            });
        }

        @Override
        protected String resolveDescription() {
            return "Class '" + ((Type)this.annotatedElement).getName() + "'";
        }
    }

    private static class MethodStereotypeResolver
    extends StereotypeResolver<MethodElement> {
        private final MethodWrapper methodElement;

        public MethodStereotypeResolver(MethodWrapper methodElement, ComponentDeclaration declaration, String namespace, StereotypeModel fallbackStereotype, Map<StereotypeDefinition, StereotypeModel> stereotypesCache) {
            super(methodElement, (WithStereotypesDeclaration)declaration, namespace, fallbackStereotype, stereotypesCache);
            this.methodElement = methodElement;
        }

        @Override
        protected void resolveStereotype() {
            super.resolveStereotype();
            this.addAllowedStereotypes(this.namespace, (ComponentDeclaration)this.declaration, this.methodElement);
        }

        @Override
        protected void addFallbackStereotype() {
            new ClassStereotypeResolver(new TypeWrapper(((MethodElement)this.annotatedElement).getDeclaringClass()), this.declaration, this.namespace, this.fallbackStereotype, (Map<StereotypeDefinition, StereotypeModel>)this.stereotypesCache).resolveStereotype();
        }

        private void addAllowedStereotypes(String namespace, ComponentDeclaration<?> declaration, MethodWrapper methodElement) {
            Map<String, NestableElementDeclaration> nested = declaration.getNestedComponents().stream().collect(Collectors.toMap(NamedDeclaration::getName, n -> n));
            methodElement.getParameters().stream().filter(p -> nested.containsKey(p.getAlias())).forEach(parameter -> {
                if (ModelLoaderUtils.isProcessorChain(parameter)) {
                    this.addAllowedStereotypes(namespace, (ExtensionParameter)parameter, (WithAllowedStereotypesDeclaration)nested.get(parameter.getAlias()));
                } else if (ModelLoaderUtils.isRoute(parameter)) {
                    NestedRouteDeclaration route = (NestedRouteDeclaration)nested.get(parameter.getAlias());
                    Optional<AllowedStereotypes> allowedStereotypes = parameter.getType().getAnnotation(AllowedStereotypes.class);
                    allowedStereotypes.ifPresent(processorsStereotypes -> {
                        NestableElementDeclaration processorsChain = route.getNestedComponents().stream().filter(routeChild -> routeChild instanceof NestedChainDeclaration).findFirst().orElseThrow(() -> new IllegalStateException("Missing Chain component in Route declaration"));
                        this.addAllowedStereotypes((WithAllowedStereotypesDeclaration)processorsChain, processorsStereotypes.value(), namespace);
                    });
                }
            });
        }

        private void addAllowedStereotypes(WithAllowedStereotypesDeclaration declaration, Class<? extends StereotypeDefinition>[] stereotypes, String namespace) {
            for (Class<? extends StereotypeDefinition> definition : stereotypes) {
                declaration.addAllowedStereotype(MethodStereotypeResolver.createCustomStereotype(definition, namespace, this.stereotypesCache));
            }
        }

        private void addAllowedStereotypes(String namespace, ExtensionParameter parameter, WithAllowedStereotypesDeclaration declaration) {
            Optional<AllowedStereotypes> allowedStereotypes = parameter.getAnnotation(AllowedStereotypes.class);
            if (allowedStereotypes.isPresent()) {
                this.addAllowedStereotypes(declaration, allowedStereotypes.get().value(), namespace);
            } else {
                declaration.addAllowedStereotype(MuleStereotypes.PROCESSOR);
            }
        }

        @Override
        protected <T extends Annotation> T getAnnotation(Class<T> annotationType) {
            return (T)((Annotation)((MethodElement)this.annotatedElement).getAnnotation(annotationType).orElse(null));
        }

        @Override
        protected String resolveDescription() {
            return "Method '" + ((MethodElement)this.annotatedElement).getName() + "'";
        }
    }

    private static abstract class StereotypeResolver<T extends WithAnnotations> {
        protected final T annotatedElement;
        protected final WithStereotypesDeclaration declaration;
        protected final String namespace;
        protected final StereotypeModel fallbackStereotype;
        protected Validator validatorAnnotation;
        protected Stereotype stereotypeAnnotation;
        protected Map<StereotypeDefinition, StereotypeModel> stereotypesCache;

        protected static StereotypeModel createCustomStereotype(Class<? extends StereotypeDefinition> definitionClass, String namespace, Map<StereotypeDefinition, StereotypeModel> stereotypesCache) {
            try {
                return StereotypeResolver.getStereotype((StereotypeDefinition)ClassUtils.instantiateClass(definitionClass, (Object[])new Object[0]), namespace, stereotypesCache);
            }
            catch (Exception e) {
                throw new IllegalModelDefinitionException("Invalid StereotypeDefinition found with name: " + definitionClass.getName(), (Throwable)e);
            }
        }

        protected static StereotypeModel getStereotype(StereotypeDefinition stereotypeDefinition, String namespace, Map<StereotypeDefinition, StereotypeModel> stereotypesCache) {
            return stereotypesCache.computeIfAbsent(stereotypeDefinition, definition -> {
                if (!StringUtils.isBlank((String)stereotypeDefinition.getNamespace()) && !namespace.equals(stereotypeDefinition.getNamespace())) {
                    throw new IllegalModelDefinitionException(String.format("Stereotype '%s' defines namespace '%s' which doesn't match extension stereotype '%s'. No extension can define stereotypes on namespaces other than its own", stereotypeDefinition.getName(), stereotypeDefinition.getNamespace(), namespace));
                }
                StereotypeModelBuilder builder = StereotypeModelBuilder.newStereotype((String)stereotypeDefinition.getName(), (String)namespace);
                stereotypeDefinition.getParent().ifPresent(parent -> {
                    String parentNamespace = parent.getNamespace();
                    if (StringUtils.isBlank((String)parentNamespace)) {
                        parentNamespace = namespace;
                    }
                    builder.withParent(StereotypeResolver.getStereotype(parent, parentNamespace, stereotypesCache));
                });
                return builder.build();
            });
        }

        protected StereotypeResolver(T annotatedElement, WithStereotypesDeclaration declaration, String namespace, StereotypeModel fallbackStereotype, Map<StereotypeDefinition, StereotypeModel> stereotypesCache) {
            this.annotatedElement = annotatedElement;
            this.declaration = declaration;
            this.namespace = namespace;
            this.stereotypesCache = stereotypesCache;
            this.fallbackStereotype = fallbackStereotype;
            this.stereotypeAnnotation = this.getAnnotation(Stereotype.class);
            this.validatorAnnotation = this.getAnnotation(Validator.class);
            if (this.validatorAnnotation != null && this.stereotypeAnnotation != null) {
                throw new IllegalModelDefinitionException(String.format("%s is annotated with both @%s and @%s. Only one can be provided at the same time for the same component", this.resolveDescription(), Stereotype.class.getSimpleName(), Validator.class.getSimpleName()));
            }
        }

        protected abstract <T extends Annotation> T getAnnotation(Class<T> var1);

        protected abstract String resolveDescription();

        protected void resolveStereotype() {
            if (this.validatorAnnotation != null) {
                this.addValidationStereotype();
            } else if (this.stereotypeAnnotation != null) {
                this.declaration.withStereotype(this.createCustomStereotype());
            } else {
                this.addFallbackStereotype();
            }
        }

        protected void addFallbackStereotype() {
            this.declaration.withStereotype(this.fallbackStereotype);
        }

        protected StereotypeModel createCustomStereotype() {
            return StereotypeResolver.createCustomStereotype(this.stereotypeAnnotation.value(), this.namespace, this.stereotypesCache);
        }

        protected void addValidationStereotype() {
            this.declaration.withStereotype(StereotypeModelBuilder.newStereotype((String)MuleStereotypes.VALIDATOR_DEFINITION.getName(), (String)this.namespace).withParent(MuleStereotypes.VALIDATOR).build());
        }
    }

    private static class EnricherDelegate {
        private final Map<StereotypeDefinition, StereotypeModel> stereotypes = new HashMap<StereotypeDefinition, StereotypeModel>();

        private EnricherDelegate() {
        }

        public void apply(ExtensionLoadingContext extensionLoadingContext) {
            ExtensionDeclarer extensionDeclarer = extensionLoadingContext.getExtensionDeclarer();
            ExtensionDeclaration declaration = (ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration();
            Optional implementingType = declaration.getModelProperty(ImplementingTypeModelProperty.class);
            final String namespace = this.getStereotypePrefix(extensionDeclarer);
            final StereotypeModel defaultConfigStereotype = StereotypeModelBuilder.newStereotype((String)"CONFIG", (String)namespace).withParent(MuleStereotypes.CONFIG).build();
            final StereotypeModel defaultConnectionStereotype = StereotypeModelBuilder.newStereotype((String)"CONNECTION", (String)namespace).withParent(MuleStereotypes.CONNECTION).build();
            if (implementingType.isPresent()) {
                new IdempotentDeclarationWalker(){

                    protected void onConfiguration(ConfigurationDeclaration declaration) {
                        declaration.getModelProperty(ImplementingTypeModelProperty.class).map(ImplementingTypeModelProperty::getType).ifPresent(declaringType -> new ClassStereotypeResolver(new TypeWrapper((Class<?>)declaringType), (WithStereotypesDeclaration)declaration, namespace, defaultConfigStereotype, (Map<StereotypeDefinition, StereotypeModel>)stereotypes).resolveStereotype());
                    }

                    protected void onConnectionProvider(ConnectedDeclaration owner, ConnectionProviderDeclaration declaration) {
                        declaration.getModelProperty(ImplementingTypeModelProperty.class).map(ImplementingTypeModelProperty::getType).ifPresent(declaringType -> new ClassStereotypeResolver(new TypeWrapper((Class<?>)declaringType), (WithStereotypesDeclaration)declaration, namespace, defaultConnectionStereotype, (Map<StereotypeDefinition, StereotypeModel>)stereotypes).resolveStereotype());
                    }

                    protected void onConstruct(WithConstructsDeclaration owner, ConstructDeclaration declaration) {
                        declaration.getModelProperty(ImplementingMethodModelProperty.class).map(ImplementingMethodModelProperty::getMethod).map(MethodWrapper::new).ifPresent(methodElement -> new MethodStereotypeResolver((MethodWrapper)methodElement, (ComponentDeclaration)declaration, namespace, MuleStereotypes.PROCESSOR, (Map<StereotypeDefinition, StereotypeModel>)stereotypes).resolveStereotype());
                    }

                    public void onOperation(WithOperationsDeclaration owner, OperationDeclaration declaration) {
                        declaration.getModelProperty(ImplementingMethodModelProperty.class).map(ImplementingMethodModelProperty::getMethod).map(MethodWrapper::new).ifPresent(methodElement -> new MethodStereotypeResolver((MethodWrapper)methodElement, (ComponentDeclaration)declaration, namespace, MuleStereotypes.PROCESSOR, (Map<StereotypeDefinition, StereotypeModel>)stereotypes).resolveStereotype());
                    }

                    protected void onSource(WithSourcesDeclaration owner, SourceDeclaration declaration) {
                        declaration.getModelProperty(ImplementingTypeModelProperty.class).map(ImplementingTypeModelProperty::getType).ifPresent(declaringType -> new ClassStereotypeResolver(new TypeWrapper((Class<?>)declaringType), (WithStereotypesDeclaration)declaration, namespace, MuleStereotypes.SOURCE, (Map<StereotypeDefinition, StereotypeModel>)stereotypes).resolveStereotype());
                    }
                }.walk(declaration);
            }
            this.resolveStereotypes(declaration, namespace);
        }

        private void resolveStereotypes(ExtensionDeclaration declaration, String namespace) {
            Function<Class, StereotypeModel> resolver = def -> StereotypeResolver.createCustomStereotype(def, namespace, this.stereotypes);
            declaration.getTypes().forEach(type -> this.resolveStereotype((ObjectType)type, (Function<Class<? extends StereotypeDefinition>, StereotypeModel>)resolver));
        }

        private void resolveStereotype(ObjectType type, final Function<Class<? extends StereotypeDefinition>, StereotypeModel> resolver) {
            type.accept(new MetadataTypeVisitor(){

                public void visitObject(ObjectType objectType) {
                    objectType.getAnnotation(StereotypeTypeAnnotation.class).ifPresent(a -> a.resolveStereotype(resolver));
                    objectType.getFields().forEach(f -> f.getValue().accept((MetadataTypeVisitor)this));
                }

                public void visitArrayType(ArrayType arrayType) {
                    arrayType.getType().accept((MetadataTypeVisitor)this);
                }

                public void visitUnion(UnionType unionType) {
                    unionType.getTypes().forEach(t -> t.accept((MetadataTypeVisitor)this));
                }

                public void visitIntersection(IntersectionType intersectionType) {
                    intersectionType.getTypes().forEach(t -> t.accept((MetadataTypeVisitor)this));
                }
            });
        }

        private String getStereotypePrefix(ExtensionDeclarer extensionDeclarer) {
            return ((ExtensionDeclaration)extensionDeclarer.getDeclaration()).getXmlDslModel().getPrefix().toUpperCase();
        }
    }
}

