/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.api.loader;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.annotation.privileged.DeclarationEnrichers;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.module.extension.api.loader.ModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.enricher.BooleanParameterDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.ConnectionDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.DefaultEncodingDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.DisplayDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.DynamicMetadataDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.ErrorsDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.ExtensionDescriptionsEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.ExtensionsErrorsDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.ImportedTypesDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.JavaConfigurationDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.JavaExportedTypesDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.JavaOAuthDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.JavaPrivilegedExportedTypesDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.JavaXmlDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.MimeTypeParametersDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.ParameterAllowedStereotypesDeclarionEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.ParameterLayoutOrderDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.RedeliveryPolicyDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.RefNameDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.StereotypesDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.SubTypesDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.ValueProvidersParameterDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.validation.ComponentLocationModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.ConfigurationModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.ConnectionProviderModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.InputParametersTypeModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.JavaSubtypesModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.MetadataComponentModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.NullSafeModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.OAuthConnectionProviderModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.OperationParametersTypeModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.OperationReturnTypeModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.PagedOperationModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.ParameterGroupModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.ParameterPluralNameModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.ParameterTypeModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.PrivilegedApiValidator;
import org.mule.runtime.module.extension.internal.loader.validation.ValueProviderModelValidator;

public class AbstractJavaExtensionModelLoader
extends ExtensionModelLoader {
    public static final String TYPE_PROPERTY_NAME = "type";
    public static final String VERSION = "version";
    private final List<ExtensionModelValidator> customValidators = Collections.unmodifiableList(Arrays.asList(new ConfigurationModelValidator(), new ConnectionProviderModelValidator(), new InputParametersTypeModelValidator(), new JavaSubtypesModelValidator(), new MetadataComponentModelValidator(), new NullSafeModelValidator(), new OperationReturnTypeModelValidator(), new OperationParametersTypeModelValidator(), new PagedOperationModelValidator(), new ParameterGroupModelValidator(), new ParameterTypeModelValidator(), new ParameterPluralNameModelValidator(), new OAuthConnectionProviderModelValidator(), new ValueProviderModelValidator(), new PrivilegedApiValidator(), new ComponentLocationModelValidator()));
    private final List<DeclarationEnricher> customDeclarationEnrichers = Collections.unmodifiableList(Arrays.asList(new JavaXmlDeclarationEnricher(), new BooleanParameterDeclarationEnricher(), new RefNameDeclarationEnricher(), new DefaultEncodingDeclarationEnricher(), new ConnectionDeclarationEnricher(), new ErrorsDeclarationEnricher(), new StereotypesDeclarationEnricher(), new ExtensionsErrorsDeclarationEnricher(), new MimeTypeParametersDeclarationEnricher(), new DisplayDeclarationEnricher(), new DynamicMetadataDeclarationEnricher(), new ImportedTypesDeclarationEnricher(), new JavaConfigurationDeclarationEnricher(), new JavaExportedTypesDeclarationEnricher(), new JavaPrivilegedExportedTypesDeclarationEnricher(), new JavaOAuthDeclarationEnricher(), new RedeliveryPolicyDeclarationEnricher(), new SubTypesDeclarationEnricher(), new ExtensionDescriptionsEnricher(), new ValueProvidersParameterDeclarationEnricher(), new ParameterAllowedStereotypesDeclarionEnricher(), new ParameterLayoutOrderDeclarationEnricher()));
    private final String id;
    private final BiFunction<Class<?>, String, ModelLoaderDelegate> delegateFactory;

    public AbstractJavaExtensionModelLoader(String id, BiFunction<Class<?>, String, ModelLoaderDelegate> delegate) {
        this.id = id;
        this.delegateFactory = delegate;
    }

    public String getId() {
        return this.id;
    }

    protected void configureContextBeforeDeclaration(ExtensionLoadingContext context) {
        context.addCustomValidators(this.customValidators);
        context.addCustomDeclarationEnrichers(this.customDeclarationEnrichers);
        context.addCustomDeclarationEnrichers(this.getPrivilegedDeclarationEnrichers(context));
    }

    protected void declareExtension(ExtensionLoadingContext context) {
        Class<?> extensionType = this.getExtensionType(context);
        String version = (String)context.getParameter(VERSION).orElseThrow(() -> new IllegalArgumentException("version not specified"));
        this.delegateFactory.apply(extensionType, version).declare(context);
    }

    private Collection<DeclarationEnricher> getPrivilegedDeclarationEnrichers(ExtensionLoadingContext context) {
        Class<?> extensionType = this.getExtensionType(context);
        try {
            ClassLoader extensionClassLoader = context.getExtensionClassLoader();
            Class<?> annotation = extensionClassLoader.loadClass(DeclarationEnrichers.class.getName());
            DeclarationEnrichers enrichers = (DeclarationEnrichers)extensionType.getAnnotation(annotation);
            if (enrichers != null) {
                return (Collection)ClassUtils.withContextClassLoader((ClassLoader)extensionClassLoader, () -> Arrays.stream(enrichers.value()).map(this::instantiateOrFail).collect(Collectors.toList()));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    private Class<?> getExtensionType(ExtensionLoadingContext context) {
        String type = (String)context.getParameter(TYPE_PROPERTY_NAME).get();
        if (StringUtils.isBlank((CharSequence)type)) {
            throw new IllegalArgumentException(String.format("Property '%s' has not been specified", TYPE_PROPERTY_NAME));
        }
        try {
            return ClassUtils.loadClass((String)type, (ClassLoader)context.getExtensionClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(String.format("Class '%s' cannot be loaded", type), e);
        }
    }

    private <R> R instantiateOrFail(Class<R> clazz) {
        try {
            return (R)ClassUtils.instantiateClass(clazz, (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error instantiating class: [" + clazz + "].", e);
        }
    }
}

