/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.streaming;

import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.util.func.CheckedSupplier;
import org.mule.runtime.core.internal.streaming.object.iterator.Producer;
import org.mule.runtime.core.transaction.TransactionCoordination;
import org.mule.runtime.extension.api.runtime.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.module.extension.internal.runtime.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.connectivity.ExtensionConnectionSupplier;
import org.mule.runtime.module.extension.internal.runtime.streaming.PagingProviderWrapper;
import org.mule.runtime.module.extension.internal.runtime.transaction.ExtensionTransactionKey;

public final class PagingProviderProducer<T>
implements Producer<List<T>> {
    private PagingProvider<Object, T> delegate;
    private final ConfigurationInstance config;
    private final ExtensionConnectionSupplier connectionSupplier;
    private final ExecutionContextAdapter executionContext;
    private final ConnectionSupplierFactory connectionSupplierFactory;

    public PagingProviderProducer(PagingProvider<Object, T> delegate, ConfigurationInstance config, ExecutionContextAdapter executionContext, ExtensionConnectionSupplier connectionSupplier) {
        this.delegate = new PagingProviderWrapper<Object, T>(delegate);
        this.config = config;
        this.executionContext = executionContext;
        this.connectionSupplier = connectionSupplier;
        this.connectionSupplierFactory = this.createConnectionSupplierFactory();
    }

    public List<T> produce() {
        return this.performWithConnection(connection -> this.delegate.getPage(connection));
    }

    public int getSize() {
        return this.performWithConnection(connection -> this.delegate.getTotalResults(connection)).orElse(-1);
    }

    private <R> R performWithConnection(Function<Object, R> function) {
        try (ConnectionSupplier connectionSupplier = null;){
            connectionSupplier = this.connectionSupplierFactory.getConnectionSupplier();
            R r = function.apply(connectionSupplier.getConnection());
            return r;
        }
    }

    public void close() throws IOException {
        try {
            this.delegate.close();
        }
        finally {
            this.connectionSupplierFactory.dispose();
        }
    }

    private ConnectionSupplierFactory createConnectionSupplierFactory() {
        if (this.delegate.useStickyConnections() || this.isTransactional()) {
            return new StickyConnectionSupplierFactory();
        }
        return new DefaultConnectionSupplierFactory();
    }

    private boolean isTransactional() {
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        return tx != null && tx.hasResource((Object)new ExtensionTransactionKey(this.config));
    }

    private class StickyConnectionSupplier
    implements ConnectionSupplier {
        private final Object connection;

        public StickyConnectionSupplier(Object connection) {
            this.connection = connection;
        }

        @Override
        public Object getConnection() throws MuleException {
            return this.connection;
        }

        @Override
        public void close() {
        }
    }

    private class DefaultConnectionSupplier
    implements ConnectionSupplier {
        private final ConnectionHandler connectionHandler;

        public DefaultConnectionSupplier(ConnectionHandler connectionHandler) {
            this.connectionHandler = connectionHandler;
        }

        @Override
        public Object getConnection() throws MuleException {
            return this.connectionHandler.getConnection();
        }

        @Override
        public void close() {
            this.connectionHandler.release();
        }
    }

    private static interface ConnectionSupplier {
        public Object getConnection() throws MuleException;

        public void close();
    }

    private class StickyConnectionSupplierFactory
    implements ConnectionSupplierFactory {
        private final LazyValue<ConnectionSupplier> stickyConnection = new LazyValue((Supplier)new CheckedSupplier<ConnectionSupplier>(){

            public ConnectionSupplier getChecked() throws Throwable {
                StickyConnectionSupplierFactory.this.connectionHandler = PagingProviderProducer.this.connectionSupplier.getConnection(PagingProviderProducer.this.executionContext);
                return new StickyConnectionSupplier(StickyConnectionSupplierFactory.this.connectionHandler.getConnection());
            }
        });
        private ConnectionHandler connectionHandler;

        private StickyConnectionSupplierFactory() {
        }

        @Override
        public ConnectionSupplier getConnectionSupplier() throws MuleException {
            return (ConnectionSupplier)this.stickyConnection.get();
        }

        @Override
        public void dispose() {
            if (this.connectionHandler != null) {
                this.connectionHandler.release();
            }
        }
    }

    private class DefaultConnectionSupplierFactory
    implements ConnectionSupplierFactory {
        private DefaultConnectionSupplierFactory() {
        }

        @Override
        public ConnectionSupplier getConnectionSupplier() throws MuleException {
            return new DefaultConnectionSupplier(PagingProviderProducer.this.connectionSupplier.getConnection(PagingProviderProducer.this.executionContext));
        }

        @Override
        public void dispose() {
        }
    }

    private static interface ConnectionSupplierFactory {
        public ConnectionSupplier getConnectionSupplier() throws MuleException;

        public void dispose();
    }
}

