/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import java.util.function.BiConsumer;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.util.AttributeEvaluator;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;

public class ExpressionValueResolver<T>
implements ValueResolver<T> {
    @Inject
    private ExtendedExpressionManager extendedExpressionManager;
    final AttributeEvaluator evaluator;
    private boolean evaluatorInitialized = false;
    private BiConsumer<AttributeEvaluator, ExtendedExpressionManager> evaluatorInitialiser = (evaluator, extendedExpressionManager) -> {
        ExtendedExpressionManager extendedExpressionManager2 = extendedExpressionManager;
        synchronized (extendedExpressionManager2) {
            if (!this.evaluatorInitialized) {
                evaluator.initialize(extendedExpressionManager);
                this.evaluatorInitialiser = (e, c) -> {};
                this.evaluatorInitialized = true;
            }
        }
    };

    ExpressionValueResolver(String expression, DataType expectedDataType) {
        Preconditions.checkArgument((!StringUtils.isBlank((String)expression) ? 1 : 0) != 0, (String)"Expression cannot be blank or null");
        this.evaluator = new AttributeEvaluator(expression, expectedDataType);
    }

    public ExpressionValueResolver(String expression) {
        Preconditions.checkArgument((!StringUtils.isBlank((String)expression) ? 1 : 0) != 0, (String)"Expression cannot be blank or null");
        this.evaluator = new AttributeEvaluator(expression);
    }

    void setExtendedExpressionManager(ExtendedExpressionManager extendedExpressionManager) {
        this.extendedExpressionManager = extendedExpressionManager;
    }

    @Override
    public T resolve(ValueResolvingContext context) throws MuleException {
        this.initEvaluator();
        TypedValue typedValue = this.evaluator.resolveTypedValue(context.getEvent());
        Object value = typedValue.getValue();
        if (ClassUtils.isInstance(ValueResolver.class, (Object)value)) {
            value = ((ValueResolver)value).resolve(context);
        }
        return (T)value;
    }

    void initEvaluator() {
        this.evaluatorInitialiser.accept(this.evaluator, this.extendedExpressionManager);
    }

    @Override
    public boolean isDynamic() {
        return true;
    }
}

