/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.extension.api.dsql.DsqlParser;
import org.mule.runtime.extension.api.dsql.DsqlQuery;
import org.mule.runtime.extension.api.dsql.QueryTranslator;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;

public final class NativeQueryParameterValueResolver
implements ValueResolver<String> {
    private static final DsqlParser dsqlParser = DsqlParser.getInstance();
    private static final String ERROR = "Error creating QueryTranslator [%s], query translators must have a default constructor";
    private final String query;
    private final Class<? extends QueryTranslator> translatorClass;

    public NativeQueryParameterValueResolver(String query, Class<? extends QueryTranslator> translator) {
        this.query = query;
        this.translatorClass = translator;
    }

    @Override
    public String resolve(ValueResolvingContext context) throws MuleException {
        if (!DsqlParser.isDsqlQuery((String)this.query)) {
            return this.query;
        }
        DsqlQuery dsqlQuery = dsqlParser.parse(this.query);
        QueryTranslator queryTranslator = this.instantiateTranslator(this.translatorClass);
        return dsqlQuery.translate(queryTranslator);
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    private QueryTranslator instantiateTranslator(Class<? extends QueryTranslator> translator) {
        try {
            return translator.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException(String.format(ERROR, translator.getSimpleName()));
        }
    }
}

