/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import java.util.Optional;
import javax.inject.Inject;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.TransformationService;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.extension.api.runtime.parameter.ParameterResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeExpressionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;

class ExpressionBasedParameterResolver<T>
implements ParameterResolver<T>,
Initialisable {
    private final String expression;
    private final ValueResolvingContext context;
    private final MetadataType metadataType;
    private TypeSafeExpressionValueResolver<T> valueResolver;
    @Inject
    private TransformationService transformationService;
    @Inject
    private ExtendedExpressionManager extendedExpressionManager;

    ExpressionBasedParameterResolver(String expression, MetadataType metadataType, ValueResolvingContext context) {
        this.expression = expression;
        this.context = context;
        this.metadataType = metadataType;
    }

    public T resolve() {
        try {
            return this.valueResolver.resolve(this.context);
        }
        catch (MuleException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public Optional<String> getExpression() {
        return Optional.ofNullable(this.expression);
    }

    public void initialise() throws InitialisationException {
        this.valueResolver = new TypeSafeExpressionValueResolver(this.expression, this.metadataType);
        this.valueResolver.setExtendedExpressionManager(this.extendedExpressionManager);
        this.valueResolver.setTransformationService(this.transformationService);
        this.valueResolver.initialise();
    }

    public void setTransformationService(TransformationService transformationService) {
        this.transformationService = transformationService;
    }

    public void setExtendedExpressionManager(ExtendedExpressionManager extendedExpressionManager) {
        this.extendedExpressionManager = extendedExpressionManager;
    }
}

