/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.OperationExecutor;
import org.mule.runtime.module.extension.internal.runtime.execution.OperationArgumentResolverFactory;
import org.mule.runtime.module.extension.internal.runtime.execution.ReflectiveMethodComponentExecutor;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public final class ReflectiveMethodOperationExecutor
implements OperationExecutor,
OperationArgumentResolverFactory,
MuleContextAware,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectiveMethodOperationExecutor.class);
    private final ReflectiveMethodComponentExecutor<OperationModel> executor;
    private MuleContext muleContext;

    public ReflectiveMethodOperationExecutor(OperationModel operationModel, Method operationMethod, Object operationInstance) {
        this.executor = new ReflectiveMethodComponentExecutor(operationModel.getParameterGroupModels(), operationMethod, operationInstance);
    }

    public Publisher<Object> execute(ExecutionContext<OperationModel> executionContext) {
        try {
            return Mono.justOrEmpty((Object)this.executor.execute(executionContext));
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
        catch (Throwable t) {
            return Mono.error((Throwable)Exceptions.wrapFatal((Throwable)t));
        }
    }

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.executor, (boolean)true, (MuleContext)this.muleContext);
    }

    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.executor);
    }

    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.executor);
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.executor, (Logger)LOGGER);
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        this.executor.setMuleContext(this.muleContext);
    }

    @Override
    public Function<ExecutionContext<OperationModel>, Map<String, Object>> createArgumentResolver(OperationModel operationModel) {
        return this.executor instanceof OperationArgumentResolverFactory ? this.executor.createArgumentResolver(operationModel) : ec -> Collections.emptyMap();
    }
}

